/*
 * Decompiled with CFR 0.152.
 */
package net.seface.somemoreblocks.events;

import java.nio.file.Path;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.event.AddPackFindersEvent;
import net.seface.somemoreblocks.SomeMoreBlocks;
import net.seface.somemoreblocks.registries.SMBBlocks;

@Mod.EventBusSubscriber(modid="somemoreblocks", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientSetupEvent {
    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            SomeMoreBlocks.initClient();
            ClientSetupEvent.registerFlowerPots();
        });
    }

    @SubscribeEvent
    public static void onFindPacks(AddPackFindersEvent event) {
        if (event.getPackType() != PackType.CLIENT_RESOURCES) {
            return;
        }
        Path rpPath = ModList.get().getModFileById("somemoreblocks").getFile().findResource(new String[]{"resourcepacks/update_1_21"});
        Pack pack = Pack.readMetaAndCreate((String)SomeMoreBlocks.id("update_1_21").toString(), (Component)Component.translatable((String)"somemoreblocks.resourcepack.update_1_21.name"), (boolean)false, (Pack.ResourcesSupplier)new PathPackResources.PathResourcesSupplier(rpPath, false), (PackType)PackType.CLIENT_RESOURCES, (Pack.Position)Pack.Position.BOTTOM, (PackSource)PackSource.BUILT_IN);
        event.addRepositorySource(source -> source.accept(pack));
    }

    private static void registerFlowerPots() {
        ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(SMBBlocks.LUMINOUS_FLOWER.getId(), SMBBlocks.POTTED_LUMINOUS_FLOWER);
        ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(SMBBlocks.SNOW_FERN.getId(), SMBBlocks.POTTED_SNOW_FERN);
        ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(SMBBlocks.TINY_CACTUS.getId(), SMBBlocks.POTTED_TINY_CACTUS);
    }
}

