/*
 * Decompiled with CFR 0.152.
 */
package com.example.bloodinfection999.common.blocks;

import com.example.bloodinfection999.common.data.InfectionData;
import com.example.bloodinfection999.common.entity.InfectedChickenEntity;
import com.example.bloodinfection999.common.entity.InfectedPigEntity;
import com.example.bloodinfection999.common.entity.InfectedSheepEntity;
import com.example.bloodinfection999.core.init.EffectInit;
import com.example.bloodinfection999.core.init.ModGameRules;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class InfectedBlock
extends Block {
    public InfectedBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    public void m_6807_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        super.m_6807_(pState, pLevel, pPos, pOldState, pIsMoving);
        if (!pLevel.m_5776_()) {
            InfectionData.get((ServerLevel)pLevel).increment();
        }
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        super.m_6810_(pState, pLevel, pPos, pNewState, pIsMoving);
        if (!pLevel.m_5776_()) {
            InfectionData.get((ServerLevel)pLevel).decrement();
        }
    }

    public void m_141947_(Level pLevel, BlockPos pPos, BlockState pState, Entity pEntity) {
        LivingEntity livingEntity;
        if (pEntity instanceof LivingEntity && !((livingEntity = (LivingEntity)pEntity) instanceof InfectedChickenEntity) && !(livingEntity instanceof InfectedPigEntity) && !(livingEntity instanceof InfectedSheepEntity)) {
            livingEntity.m_7292_(new MobEffectInstance((MobEffect)EffectInit.INFECTION_TOXIN.get(), 20, 0));
        }
        super.m_141947_(pLevel, pPos, pState, pEntity);
    }

    public void m_213897_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (!pLevel.f_46443_ && pLevel.m_46469_().m_46207_(ModGameRules.RULE_DO_INFECTION_SPREAD)) {
            pLevel.m_186460_(pPos, (Block)this, 100);
            int infectedBlockCount = InfectionData.get(pLevel).getInfectedBlockCount();
            float spreadChance = 0.25f + (float)(infectedBlockCount / 100) * 0.01f;
            Player nearestPlayer = null;
            double nearestDistSq = Double.MAX_VALUE;
            for (Player player : pLevel.m_6907_()) {
                double distSq = player.m_20275_((double)pPos.m_123341_(), (double)pPos.m_123342_(), (double)pPos.m_123343_());
                if (!(distSq < nearestDistSq)) continue;
                nearestDistSq = distSq;
                nearestPlayer = player;
            }
            if (nearestPlayer != null) {
                if (nearestDistSq <= 1.0) {
                    spreadChance *= 1.5f;
                } else if (nearestDistSq <= 10000.0) {
                    spreadChance *= 1.2f;
                }
            }
            if (pRandom.m_188501_() < spreadChance) {
                this.trySpread(pLevel, pPos, pRandom, nearestPlayer);
            }
        }
    }

    private void trySpread(ServerLevel pLevel, BlockPos pPos, RandomSource pRandom, @Nullable Player targetPlayer) {
        BlockPos targetPos = null;
        if (targetPlayer != null) {
            Vec3 playerPos = targetPlayer.m_20182_();
            Vec3 blockPos = new Vec3((double)pPos.m_123341_(), (double)pPos.m_123342_(), (double)pPos.m_123343_());
            Vec3 direction = playerPos.m_82546_(blockPos).m_82541_();
            double maxDot = -1.0;
            for (Direction dir : Direction.values()) {
                Vec3 neighborDir;
                double dot;
                BlockPos neighborPos = pPos.m_121945_(dir);
                if (!this.canSpreadInto(pLevel.m_8055_(neighborPos), neighborPos, pLevel) || !((dot = direction.m_82526_(neighborDir = new Vec3((double)dir.m_122429_(), (double)dir.m_122430_(), (double)dir.m_122431_()))) > maxDot)) continue;
                maxDot = dot;
                targetPos = neighborPos;
            }
        } else {
            Direction direction = Direction.m_235672_((RandomSource)pRandom);
            BlockPos neighborPos = pPos.m_121945_(direction);
            if (this.canSpreadInto(pLevel.m_8055_(neighborPos), neighborPos, pLevel)) {
                targetPos = neighborPos;
            }
        }
        if (targetPos != null) {
            pLevel.m_46597_(targetPos, this.m_49966_());
        }
    }

    private boolean canSpreadInto(BlockState state, BlockPos pos, ServerLevel level) {
        if (state.m_60713_((Block)this) || state.m_60795_() || state.m_60713_(Blocks.f_49990_) || state.m_60713_(Blocks.f_49991_)) {
            return false;
        }
        return state.m_60800_((BlockGetter)level, pos) != -1.0f;
    }
}

