/*
 * Decompiled with CFR 0.152.
 */
package core.file.format;

import core.file.format.TextFile;
import core.io.IO;
import core.io.PathIO;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class ScriptFile
extends TextFile {
    private Deletion deletion = Deletion.NEVER;
    private ProcessBuilder.Redirect redirect = ProcessBuilder.Redirect.DISCARD;

    public ScriptFile(PathIO io, Charset charset, List<String> root) {
        super((IO)io, charset, root);
    }

    public ScriptFile(PathIO io, Charset charset) {
        super((IO)io, charset);
    }

    public ScriptFile(PathIO io, List<String> root) {
        super((IO)io, root);
    }

    public ScriptFile(PathIO io) {
        super(io);
    }

    public Process run() throws IOException, InterruptedException, ExecutionException {
        return this.runAsync().get();
    }

    public CompletableFuture<Process> runAsync() throws IOException {
        ProcessBuilder builder = new ProcessBuilder("bash", this.getIO().getPath().toString()).directory(Optional.ofNullable(this.getIO().getPath().getParent()).map(Path::toFile).orElseGet(() -> new File("/"))).redirectOutput(this.redirect());
        Process process = builder.start();
        return process.onExit().thenApply(finished -> {
            try {
                if (!this.deletion().apply((Process)finished).booleanValue()) {
                    return finished;
                }
                this.getIO().delete();
                return finished;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public PathIO getIO() {
        return (PathIO)super.getIO();
    }

    public Deletion deletion() {
        return this.deletion;
    }

    public ScriptFile deletion(Deletion deletion) {
        this.deletion = deletion;
        return this;
    }

    public ProcessBuilder.Redirect redirect() {
        return this.redirect;
    }

    public ScriptFile redirect(ProcessBuilder.Redirect redirect) {
        this.redirect = redirect;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ScriptFile that = (ScriptFile)o;
        return Objects.equals(this.deletion, that.deletion) && Objects.equals(this.redirect, that.redirect);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.deletion, this.redirect);
    }

    @Override
    public String toString() {
        return "ScriptFile{deletion=" + String.valueOf(this.deletion) + ", redirect=" + String.valueOf(this.redirect) + "} " + super.toString();
    }

    @FunctionalInterface
    public static interface Deletion
    extends Function<Process, Boolean> {
        public static final Deletion ALWAYS = process -> true;
        public static final Deletion NEVER = ALWAYS.negate();
        public static final Deletion ON_SUCCESS = process -> process.exitValue() == 0;
        public static final Deletion ON_FAILURE = ON_SUCCESS.negate();

        @Override
        public Boolean apply(Process var1);

        default public Deletion negate() {
            return process -> this.apply(process) == false;
        }
    }
}

