/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.portals.action;

import core.paper.messenger.PluginMessenger;
import io.papermc.paper.entity.TeleportFlag;
import java.net.InetSocketAddress;
import java.util.concurrent.ThreadLocalRandom;
import net.thenextlvl.portals.PortalLike;
import net.thenextlvl.portals.action.ActionType;
import net.thenextlvl.portals.action.ActionTypes;
import net.thenextlvl.portals.listener.PortalListener;
import net.thenextlvl.portals.model.Bounds;
import net.thenextlvl.portals.shape.BoundingBox;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class SimpleActionTypes
implements ActionTypes {
    public static final SimpleActionTypes INSTANCE = new SimpleActionTypes();
    private final PluginMessenger messenger = new PluginMessenger((Plugin)JavaPlugin.getProvidingPlugin(SimpleActionTypes.class));
    private final ActionType<String> connect = ActionType.create("connect", String.class, (entity, portal, server) -> {
        if (!(entity instanceof Player)) {
            return false;
        }
        Player player = (Player)entity;
        this.messenger.connect(player, (String)server);
        return true;
    });
    private final ActionType<String> runCommand = ActionType.create("run_command", String.class, (entity, portal, input) -> {
        if (!(entity instanceof Player)) {
            return false;
        }
        Player player = (Player)entity;
        player.performCommand(input.replace("<player>", player.getName()));
        return true;
    });
    private final ActionType<String> runConsoleCommand = ActionType.create("run_console_command", String.class, (entity, portal, input) -> {
        if (!(entity instanceof Player)) {
            return false;
        }
        Player player = (Player)entity;
        String command = input.replace("<player>", player.getName());
        player.getServer().dispatchCommand((CommandSender)player.getServer().getConsoleSender(), command);
        return true;
    });
    private final ActionType<Location> teleport = ActionType.create("teleport", Location.class, (entity, portal, location) -> {
        entity.teleportAsync(location, PlayerTeleportEvent.TeleportCause.PLUGIN);
        return true;
    });
    private final ActionType<PortalLike> teleportPortal = ActionType.create("teleport_portal", PortalLike.class, (entity, portal, target) -> target.getPortal().map(targetPortal -> {
        int tV;
        int tW;
        int sV;
        BoundingBox sourceBB = portal.getBoundingBox();
        BoundingBox targetBB = targetPortal.getBoundingBox();
        Location from = entity.getLocation();
        double[] sMin = new double[]{sourceBB.getMinX(), sourceBB.getMinY(), sourceBB.getMinZ()};
        double[] sMax = new double[]{sourceBB.getMaxX(), sourceBB.getMaxY(), sourceBB.getMaxZ()};
        double[] dArray = new double[]{sMax[0] - sMin[0], sMax[1] - sMin[1], sMax[2] - sMin[2]};
        double[] sSize = dArray;
        int sW = 0;
        if (sSize[1] < sSize[sW]) {
            sW = 1;
        }
        if (sSize[2] < sSize[sW]) {
            sW = 2;
        }
        int sU = sW == 0 ? 1 : 0;
        int n = sV = sW == 2 ? 1 : 2;
        if (sSize[sV] > sSize[sU]) {
            int tmp = sU;
            sU = sV;
            sV = tmp;
        }
        double eps = 1.0E-6;
        double margin = 0.001;
        double[] pos = new double[]{from.getX(), from.getY(), from.getZ()};
        double fu = sSize[sU] < eps ? 0.0 : (pos[sU] - sMin[sU]) / Math.max(sSize[sU], eps);
        double fv = sSize[sV] < eps ? 0.0 : (pos[sV] - sMin[sV]) / Math.max(sSize[sV], eps);
        double fw = sSize[sW] < eps ? 0.0 : (pos[sW] - sMin[sW]) / Math.max(sSize[sW], eps);
        fu = Math.min(1.0 - margin, Math.max(margin, fu));
        fw = Math.min(1.0 - margin, Math.max(margin, fw));
        double[] tMin = new double[]{targetBB.getMinX(), targetBB.getMinY(), targetBB.getMinZ()};
        double[] tMax = new double[]{targetBB.getMaxX(), targetBB.getMaxY(), targetBB.getMaxZ()};
        double[] tSize = new double[]{tMax[0] - tMin[0], tMax[1] - tMin[1], tMax[2] - tMin[2]};
        if (tSize[1] < tSize[tW = 0]) {
            tW = 1;
        }
        if (tSize[2] < tSize[tW]) {
            tW = 2;
        }
        int tU = tW == 0 ? 1 : 0;
        int n2 = tV = tW == 2 ? 1 : 2;
        if (tSize[tV] > tSize[tU]) {
            int tmp = tU;
            tU = tV;
            tV = tmp;
        }
        double[] dest = new double[3];
        dest[tU] = tMin[tU] + fu * tSize[tU];
        dest[tV] = tMin[tV] + fv * tSize[tV];
        dest[tW] = tMin[tW] + fw * tSize[tW];
        Location destination = new Location(targetPortal.getWorld(), dest[0], dest[1], dest[2]).setRotation(from.getRotation());
        entity.teleportAsync(destination, PlayerTeleportEvent.TeleportCause.PLUGIN, (TeleportFlag[])TeleportFlag.Relative.values()).thenAccept(success -> {
            if (success.booleanValue()) {
                PortalListener.setLastPortal(entity, targetPortal);
            }
        });
        return true;
    }).orElse(false));
    private final ActionType<Bounds> teleportRandom = ActionType.create("teleport_random", Bounds.class, (entity, portal, bounds) -> {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        Location location = bounds.getRandomLocation(random).setRotation(entity.getLocation().getRotation());
        entity.teleportAsync(location, PlayerTeleportEvent.TeleportCause.PLUGIN);
        return true;
    });
    private final ActionType<InetSocketAddress> transfer = ActionType.create("transfer", InetSocketAddress.class, (entity, portal, address) -> {
        if (!(entity instanceof Player)) {
            return false;
        }
        Player player = (Player)entity;
        player.transfer(address.getHostName(), address.getPort());
        return true;
    });

    @Override
    public ActionType<String> connect() {
        return this.connect;
    }

    @Override
    public ActionType<String> runCommand() {
        return this.runCommand;
    }

    @Override
    public ActionType<String> runConsoleCommand() {
        return this.runConsoleCommand;
    }

    @Override
    public ActionType<Location> teleport() {
        return this.teleport;
    }

    @Override
    public ActionType<PortalLike> teleportPortal() {
        return this.teleportPortal;
    }

    @Override
    public ActionType<Bounds> teleportRandom() {
        return this.teleportRandom;
    }

    @Override
    public ActionType<InetSocketAddress> transfer() {
        return this.transfer;
    }
}

