/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.portals.adapter;

import java.time.Duration;
import net.thenextlvl.nbt.serialization.ParserException;
import net.thenextlvl.nbt.serialization.TagAdapter;
import net.thenextlvl.nbt.serialization.TagDeserializationContext;
import net.thenextlvl.nbt.serialization.TagSerializationContext;
import net.thenextlvl.nbt.tag.CompoundTag;
import net.thenextlvl.nbt.tag.Tag;
import net.thenextlvl.portals.Portal;
import net.thenextlvl.portals.PortalsPlugin;
import net.thenextlvl.portals.action.EntryAction;
import net.thenextlvl.portals.portal.PaperPortal;
import net.thenextlvl.portals.shape.BoundingBox;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class PortalAdapter
implements TagAdapter<Portal> {
    private final PortalsPlugin plugin;

    public PortalAdapter(PortalsPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public Portal deserialize(Tag tag, TagDeserializationContext context) throws ParserException {
        CompoundTag root = tag.getAsCompound();
        String name = root.get("name").getAsString();
        BoundingBox boundingBox = context.deserialize((Tag)root.get("boundingBox"), BoundingBox.class);
        PaperPortal portal = new PaperPortal(this.plugin, name, boundingBox);
        root.optional("cooldown").map(tag1 -> context.deserialize((Tag)tag1, Duration.class)).ifPresent(portal::setCooldown);
        root.optional("entryAction").map(tag1 -> context.deserialize((Tag)tag1, EntryAction.class)).ifPresent(portal::setEntryAction);
        root.optional("entryCost").map(tag1 -> context.deserialize((Tag)tag1, Double.class)).ifPresent(portal::setEntryCost);
        root.optional("entryPermission").map(tag1 -> context.deserialize((Tag)tag1, String.class)).ifPresent(portal::setEntryPermission);
        return portal;
    }

    @Override
    public Tag serialize(Portal portal, TagSerializationContext context) throws ParserException {
        CompoundTag tag = CompoundTag.empty();
        tag.add("name", portal.getName());
        tag.add("boundingBox", context.serialize((Object)portal.getBoundingBox(), BoundingBox.class));
        portal.getEntryAction().ifPresent(action -> tag.add("entryAction", context.serialize(action)));
        portal.getEntryPermission().ifPresent(permission -> tag.add("entryPermission", (String)permission));
        tag.add("cooldown", context.serialize(portal.getCooldown()));
        tag.add("entryCost", portal.getEntryCost());
        return tag;
    }
}

