/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.portals.listener;

import io.papermc.paper.event.entity.EntityMoveEvent;
import io.papermc.paper.math.Position;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.thenextlvl.portals.Portal;
import net.thenextlvl.portals.PortalsPlugin;
import net.thenextlvl.portals.event.EntityPortalExitEvent;
import net.thenextlvl.portals.event.PreEntityPortalEnterEvent;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPortalEnterEvent;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Vector;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class PortalListener
implements Listener {
    private final PortalsPlugin plugin;
    private final Map<Portal, Map<UUID, Instant>> lastEntry = new HashMap<Portal, Map<UUID, Instant>>();
    private final Map<UUID, Portal> lastPortal = new HashMap<UUID, Portal>();

    public PortalListener(PortalsPlugin plugin) {
        this.plugin = plugin;
    }

    private boolean hasCooldown(Portal portal, Entity entity) {
        Map<UUID, Instant> entries = this.lastEntry.get(portal);
        if (entries == null) {
            return false;
        }
        Instant lastEntry = entries.get(entity.getUniqueId());
        return lastEntry != null && Instant.now().isBefore(lastEntry.plus(portal.getCooldown()));
    }

    private void setLastEntry(Portal portal, Entity entity) {
        this.lastEntry.computeIfAbsent(portal, ignored -> new HashMap()).put(entity.getUniqueId(), Instant.now());
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntityMove(EntityMoveEvent event) {
        if (!event.hasChangedPosition()) {
            return;
        }
        if (this.plugin.config().ignoreEntityMovement()) {
            return;
        }
        if (this.processMovement((Entity)event.getEntity(), event.getTo())) {
            return;
        }
        this.pushAway((Entity)event.getEntity(), event.getTo());
        event.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerMove(PlayerMoveEvent event) {
        if (!event.hasChangedPosition()) {
            return;
        }
        if (this.processMovement((Entity)event.getPlayer(), event.getTo())) {
            return;
        }
        this.pushAway((Entity)event.getPlayer(), event.getTo());
        event.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        this.processTeleport((Entity)event.getPlayer(), event.getTo());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityTeleport(EntityTeleportEvent event) {
        Location to = event.getTo() != null ? event.getTo() : event.getEntity().getLocation();
        this.processTeleport(event.getEntity(), to);
    }

    private void processTeleport(Entity entity, Location to) {
        BoundingBox boundingBox = this.translate(entity.getBoundingBox(), to);
        this.plugin.portalProvider().getPortals(to.getWorld()).filter(portal -> portal.getBoundingBox().overlaps(boundingBox)).findAny().ifPresent(portal -> this.lastPortal.put(entity.getUniqueId(), (Portal)portal));
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerToggleSneak(PlayerToggleSneakEvent event) {
        if (event.isSneaking()) {
            return;
        }
        if (this.processMovement((Entity)event.getPlayer(), event.getPlayer().getLocation())) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onEntityPortalEnter(EntityPortalEnterEvent event) {
        this.plugin.portalProvider().getPortals(event.getLocation().getWorld()).filter(portal -> portal.getBoundingBox().contains((Position)event.getLocation())).findAny().ifPresent(portal -> event.setCancelled(true));
    }

    private boolean processMovement(Entity entity, Location to) {
        BoundingBox boundingBox = this.translate(entity.getBoundingBox(), to);
        return this.plugin.portalProvider().getPortals(entity.getWorld()).filter(portal -> portal.getBoundingBox().overlaps(boundingBox)).findAny().map(portal -> {
            if (portal.equals(this.lastPortal.get(entity.getUniqueId()))) {
                return true;
            }
            if (!new PreEntityPortalEnterEvent((Portal)portal, entity).callEvent()) {
                return false;
            }
            if (!portal.getEntryPermission().map(arg_0 -> ((Entity)entity).hasPermission(arg_0)).orElse(true).booleanValue()) {
                return false;
            }
            if (portal.getCooldown().isPositive() && this.hasCooldown((Portal)portal, entity)) {
                return false;
            }
            if (portal.getEntryCost() > 0.0 && !this.withdrawEntryCost((Portal)portal, entity)) {
                return false;
            }
            if (!new net.thenextlvl.portals.event.EntityPortalEnterEvent((Portal)portal, entity).callEvent()) {
                return false;
            }
            if (portal.getCooldown().isPositive()) {
                this.setLastEntry((Portal)portal, entity);
            }
            this.lastPortal.put(entity.getUniqueId(), (Portal)portal);
            return portal.getEntryAction().map(action -> action.onEntry(entity, (Portal)portal)).orElse(true);
        }).orElseGet(() -> {
            Portal removed = this.lastPortal.remove(entity.getUniqueId());
            if (removed != null) {
                new EntityPortalExitEvent(removed, entity).callEvent();
            }
            return true;
        });
    }

    private BoundingBox translate(BoundingBox boundingBox, Location location) {
        double widthX = boundingBox.getWidthX() / 2.0;
        double widthZ = boundingBox.getWidthZ() / 2.0;
        return new BoundingBox(location.getX() - widthX, location.getY(), location.getZ() - widthZ, location.getX() + widthX, location.getY() + boundingBox.getHeight(), location.getZ() + widthZ);
    }

    private void pushAway(Entity entity, Location to) {
        if (!this.plugin.config().pushBackOnEntryDenied()) {
            return;
        }
        entity.getScheduler().run((Plugin)this.plugin, task -> {
            Vector direction = entity.getLocation().toVector().subtract(to.toVector()).normalize();
            entity.setVelocity(direction.multiply(this.plugin.config().pushbackSpeed()));
        }, null);
    }

    private boolean withdrawEntryCost(Portal portal, Entity entity) {
        if (!this.plugin.config().entryCosts()) {
            return true;
        }
        if (!(entity instanceof Player)) {
            return true;
        }
        Player player = (Player)entity;
        return this.plugin.economyProvider().withdraw(player, portal.getEntryCost());
    }
}

