/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.Platform;
import com.lowdragmc.mbd2.client.ClientProxy;
import com.lowdragmc.mbd2.common.CommonProxy;
import java.io.File;
import java.io.Serializable;
import java.util.Random;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="mbd2")
public class MBD2 {
    public static final String MOD_ID = "mbd2";
    public static final String NAME = "Multiblocked2";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Multiblocked2");
    public static final Random RND = new Random();
    private static final AtomicReference<Object> location = new AtomicReference();

    public MBD2() {
        MBD2.init();
        DistExecutor.unsafeRunForDist(() -> ClientProxy::new, () -> CommonProxy::new);
    }

    private static File createDir() {
        File location = new File(LDLib.getLDLibDir(), "assets/mbd2");
        if (location.mkdirs()) {
            LOGGER.info("create mbd2 resources folder");
        }
        return location;
    }

    public static void init() {
        LOGGER.info("{} is initializing on platform: {}", (Object)NAME, (Object)Platform.platformName());
    }

    public static ResourceLocation id(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    public static boolean isGeckolibLoaded() {
        return LDLib.isModLoaded((String)"geckolib");
    }

    public static boolean isBotaniaLoaded() {
        return LDLib.isModLoaded((String)"botania");
    }

    public static boolean isNaturesAuraLoaded() {
        return LDLib.isModLoaded((String)"naturesaura");
    }

    public static boolean isPneumaticCraftLoaded() {
        return LDLib.isModLoaded((String)"pneumaticcraft");
    }

    public static boolean isEmbersLoaded() {
        return LDLib.isModLoaded((String)"embers");
    }

    public static boolean isGTMLoaded() {
        return LDLib.isModLoaded((String)"gtceu");
    }

    public static boolean isMekanismLoaded() {
        return LDLib.isModLoaded((String)"mekanism");
    }

    public static boolean isCreateLoaded() {
        return LDLib.isModLoaded((String)"create");
    }

    public static boolean isPhotonLoaded() {
        return LDLib.isModLoaded((String)"photon");
    }

    public static boolean isKubeJSLoaded() {
        return LDLib.isModLoaded((String)"kubejs");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getLocation() {
        Serializable value = location.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = location;
            synchronized (atomicReference) {
                value = location.get();
                if (value == null) {
                    File actualValue = MBD2.createDir();
                    value = actualValue == null ? location : actualValue;
                    location.set(value);
                }
            }
        }
        return (File)(value == location ? null : value);
    }
}

