/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.api.capability.recipe;

import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.jei.IngredientIO;
import com.lowdragmc.mbd2.api.recipe.content.Content;
import com.lowdragmc.mbd2.api.recipe.content.ContentModifier;
import com.lowdragmc.mbd2.api.recipe.content.IContentSerializer;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;

public abstract class RecipeCapability<T> {
    public final String name;
    public final IContentSerializer<T> serializer;

    protected RecipeCapability(String name, IContentSerializer<T> serializer) {
        this.name = name;
        this.serializer = serializer;
    }

    public final T deepCopyContent(Object content) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        this.serializer.toNetwork(buf, content);
        return this.serializer.fromNetwork(buf);
    }

    public final T deepCopyContent(Object content, ContentModifier modifier) {
        return this.serializer.copyWithModifier(this.deepCopyContent(content), modifier);
    }

    public T copyInner(T content) {
        return this.serializer.copyInner(content);
    }

    public T copyWithModifier(T content, ContentModifier modifier) {
        return this.serializer.copyWithModifier(content, modifier);
    }

    public final T copyContent(Object content) {
        return (T)this.copyInner(content);
    }

    public final T copyContent(Object content, ContentModifier modifier) {
        return (T)this.copyWithModifier(content, modifier);
    }

    public T of(Object o) {
        return this.serializer.of(o);
    }

    public Component getTraslateComponent() {
        return Component.m_237115_((String)"recipe.capability.%s.name".formatted(this.name));
    }

    public abstract T createDefaultContent();

    public abstract Widget createPreviewWidget(T var1);

    public abstract Widget createXEITemplate();

    public abstract void bindXEIWidget(Widget var1, Content var2, IngredientIO var3);

    public abstract void createContentConfigurator(ConfiguratorGroup var1, Supplier<T> var2, Consumer<T> var3);

    public abstract Component getLeftErrorInfo(List<T> var1);

    public double calculateAmount(List<T> left) {
        return 1.0;
    }
}

