/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.api.machine;

import com.lowdragmc.mbd2.api.capability.MBDCapabilities;
import com.lowdragmc.mbd2.api.machine.IMachine;
import com.lowdragmc.mbd2.api.machine.IMultiPart;
import com.lowdragmc.mbd2.api.pattern.BlockPattern;
import com.lowdragmc.mbd2.api.pattern.MultiblockState;
import com.lowdragmc.mbd2.api.pattern.MultiblockWorldSavedData;
import com.lowdragmc.mbd2.api.recipe.MBDRecipe;
import com.lowdragmc.mbd2.api.recipe.RecipeLogic;
import com.lowdragmc.mbd2.api.recipe.content.ContentModifier;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public interface IMultiController
extends IMachine {
    public static Optional<IMultiController> ofController(@Nullable BlockEntity blockEntity) {
        return blockEntity == null ? Optional.empty() : blockEntity.getCapability(MBDCapabilities.CAPABILITY_MACHINE).resolve().filter(IMultiController.class::isInstance).map(IMultiController.class::cast);
    }

    public static Optional<IMultiController> ofController(@Nonnull BlockGetter level, @Nonnull BlockPos pos) {
        return IMultiController.ofController(level.m_7702_(pos));
    }

    default public boolean checkPattern() {
        BlockPattern pattern = this.getPattern();
        return pattern != null && pattern.checkPatternAt(this.getMultiblockState(), false);
    }

    default public boolean checkPatternWithLock() {
        Lock lock = this.getPatternLock();
        lock.lock();
        boolean result = this.checkPattern();
        lock.unlock();
        return result;
    }

    default public boolean checkPatternWithTryLock() {
        Lock lock = this.getPatternLock();
        if (lock.tryLock()) {
            boolean result = this.checkPattern();
            lock.unlock();
            return result;
        }
        return false;
    }

    public BlockPattern getPattern();

    public boolean isFormed();

    public boolean isFormedValid();

    @Nonnull
    public MultiblockState getMultiblockState();

    @Override
    @Nullable
    default public MBDRecipe getModifiedRecipe(@Nonnull MBDRecipe recipe) {
        for (IMultiPart part : this.getParts()) {
            recipe = part.modifyControllerRecipe(recipe, this.getRecipeLogic());
            if (recipe != null) continue;
            return null;
        }
        return recipe;
    }

    @Override
    default public ContentModifier getMaxParallel(@NotNull MBDRecipe recipe) {
        ContentModifier maxParallel = IMachine.super.getMaxParallel(recipe);
        for (IMultiPart part : this.getParts()) {
            maxParallel = maxParallel.merge(part.getMaxControllerParallel(recipe, this.getRecipeLogic()));
        }
        return maxParallel;
    }

    @Override
    default public boolean alwaysTryModifyRecipe() {
        for (IMultiPart part : this.getParts()) {
            if (!part.alwaysTryModifyControllerRecipe()) continue;
            return true;
        }
        return false;
    }

    default public void asyncCheckPattern(long periodID) {
        Level level;
        if ((this.getMultiblockState().hasError() || !this.isFormed()) && (this.getOffset() + periodID) % 4L == 0L && this.checkPatternWithTryLock() && (level = this.getLevel()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_7654_().execute(() -> {
                this.getPatternLock().lock();
                if (this.checkPatternWithLock()) {
                    this.onStructureFormed();
                    MultiblockWorldSavedData mwsd = MultiblockWorldSavedData.getOrCreate(serverLevel);
                    mwsd.addMapping(this.getMultiblockState());
                    mwsd.removeAsyncLogic(this);
                }
                this.getPatternLock().unlock();
            });
        }
    }

    public void onStructureFormed();

    default public void onStructureInvalid() {
        this.onStructureInvalid(false);
    }

    public void onStructureInvalid(boolean var1);

    public List<IMultiPart> getParts();

    public void onPartUnload();

    public Lock getPatternLock();

    default public boolean shouldAddPartToController(IMultiPart part) {
        return true;
    }

    @Nullable
    default public BlockState getPartAppearance(IMultiPart part, Direction side, BlockState sourceState, BlockPos sourcePos) {
        return null;
    }

    @Override
    default public void notifyRecipeStatusChanged(RecipeLogic.Status oldStatus, RecipeLogic.Status newStatus) {
        for (IMultiPart part : this.getParts()) {
            part.notifyControllerRecipeStatusChanged(this, oldStatus, newStatus);
        }
    }

    @Override
    default public boolean beforeWorking(MBDRecipe recipe) {
        IMachine.super.beforeWorking(recipe);
        for (IMultiPart part : this.getParts()) {
            if (!part.beforeControllerWorking(this)) continue;
            return true;
        }
        return false;
    }

    @Override
    default public boolean onWorking() {
        IMachine.super.onWorking();
        for (IMultiPart part : this.getParts()) {
            if (!part.onControllerWorking(this)) continue;
            return true;
        }
        return false;
    }

    @Override
    default public void onWaiting() {
        IMachine.super.onWaiting();
        for (IMultiPart part : this.getParts()) {
            part.onControllerWaiting(this);
        }
    }

    @Override
    default public void afterWorking() {
        IMachine.super.afterWorking();
        for (IMultiPart part : this.getParts()) {
            part.afterControllerWorking(this);
        }
    }
}

