/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.api.pattern.predicates;

import com.google.common.base.Suppliers;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ArrayConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.configurator.Configurator;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.configurator.SearchComponentConfigurator;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.utils.BlockInfo;
import com.lowdragmc.mbd2.api.pattern.predicates.SimplePredicate;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITag;
import net.minecraftforge.registries.tags.ITagManager;

@LDLRegister(name="tags", group="predicate")
public class PredicateTags
extends SimplePredicate {
    @Persisted
    protected ResourceLocation[] tags = new ResourceLocation[0];

    public PredicateTags(ResourceLocation ... tags) {
        this.tags = tags;
        this.buildPredicate();
    }

    @Override
    public SimplePredicate buildPredicate() {
        this.tags = (ResourceLocation[])Arrays.stream(this.tags).filter(Objects::nonNull).toArray(ResourceLocation[]::new);
        if (this.tags.length == 0) {
            this.tags = new ResourceLocation[]{BlockTags.f_13029_.f_203868_()};
        }
        TagKey[] tagKeys = (TagKey[])Arrays.stream(this.tags).map(BlockTags::create).toArray(TagKey[]::new);
        this.predicate = state -> Arrays.stream(tagKeys).anyMatch(tagKey -> state.getBlockState().m_60734_().m_204297_().m_203656_(tagKey));
        this.candidates = Suppliers.memoize(() -> (BlockInfo[])Arrays.stream(tagKeys).flatMap(tag -> {
            Optional opt = BuiltInRegistries.f_256975_.m_203431_(tag);
            if (opt.isPresent()) {
                return ((HolderSet.Named)opt.get()).m_203614_().map(Holder::get);
            }
            return Arrays.stream(new Block[]{Blocks.f_50375_});
        }).map(BlockInfo::fromBlock).toArray(BlockInfo[]::new));
        return super.buildPredicate();
    }

    @Override
    public void buildConfigurator(ConfiguratorGroup father) {
        super.buildConfigurator(father);
        ArrayConfiguratorGroup tagsConfigurator = new ArrayConfiguratorGroup("config.predicate.tags", false, () -> Arrays.stream(this.tags).toList(), (getter, setter) -> new SearchComponentConfigurator("", getter, setter, (Object)BlockTags.f_13029_.f_203868_(), true, (word, find) -> {
            ITagManager tags = ForgeRegistries.BLOCKS.tags();
            if (tags == null) {
                return;
            }
            for (ITag tag : tags) {
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                ResourceLocation tagKey = tag.getKey().f_203868_();
                if (!tagKey.toString().toLowerCase().contains(word.toLowerCase())) continue;
                find.accept(tagKey);
            }
        }, ResourceLocation::toString), true);
        tagsConfigurator.setAddDefault(() -> ((TagKey)BlockTags.f_13029_).f_203868_());
        tagsConfigurator.setOnAdd(value -> {
            this.tags = Arrays.copyOf(this.tags, this.tags.length + 1);
            this.tags[this.tags.length - 1] = value;
            this.buildPredicate();
        });
        tagsConfigurator.setOnRemove(value -> {
            this.tags = (ResourceLocation[])Arrays.stream(this.tags).filter(tag -> !tag.equals(value)).toArray(ResourceLocation[]::new);
            this.buildPredicate();
        });
        tagsConfigurator.setOnUpdate(list -> {
            this.tags = list.toArray(new ResourceLocation[0]);
            this.buildPredicate();
        });
        father.addConfigurators(new Configurator[]{tagsConfigurator});
    }

    public PredicateTags() {
    }
}

