/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.api.recipe;

import com.google.common.collect.Table;
import com.lowdragmc.mbd2.MBD2;
import com.lowdragmc.mbd2.api.capability.recipe.IO;
import com.lowdragmc.mbd2.api.capability.recipe.IRecipeCapabilityHolder;
import com.lowdragmc.mbd2.api.capability.recipe.IRecipeHandler;
import com.lowdragmc.mbd2.api.capability.recipe.RecipeCapability;
import com.lowdragmc.mbd2.api.recipe.MBDRecipeSerializer;
import com.lowdragmc.mbd2.api.recipe.MBDRecipeType;
import com.lowdragmc.mbd2.api.recipe.RecipeCondition;
import com.lowdragmc.mbd2.api.recipe.RecipeLogic;
import com.lowdragmc.mbd2.api.recipe.content.Content;
import com.lowdragmc.mbd2.api.recipe.content.ContentModifier;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class MBDRecipe
implements Recipe<Container> {
    public MBDRecipeType recipeType;
    public final ResourceLocation id;
    public final Map<RecipeCapability<?>, List<Content>> inputs;
    public final Map<RecipeCapability<?>, List<Content>> outputs;
    public final List<RecipeCondition> conditions;
    public CompoundTag data;
    public int duration;
    public int priority;
    public boolean isFuel;
    private Boolean hasTick;

    public MBDRecipe(MBDRecipeType recipeType, ResourceLocation id, Map<RecipeCapability<?>, List<Content>> inputs, Map<RecipeCapability<?>, List<Content>> outputs, List<RecipeCondition> conditions, CompoundTag data, int duration, boolean isFuel, int priority) {
        this.recipeType = recipeType;
        this.id = id;
        this.inputs = inputs;
        this.outputs = outputs;
        this.conditions = conditions;
        this.data = data;
        this.duration = duration;
        this.isFuel = isFuel;
        this.priority = priority;
    }

    public Map<RecipeCapability<?>, List<Content>> copyContents(Map<RecipeCapability<?>, List<Content>> contents, boolean deep, @Nullable ContentModifier modifier) {
        HashMap copyContents = new HashMap();
        for (Map.Entry<RecipeCapability<?>, List<Content>> entry : contents.entrySet()) {
            List<Content> contentList = entry.getValue();
            RecipeCapability<?> cap = entry.getKey();
            if (contentList == null || contentList.isEmpty()) continue;
            ArrayList<Content> contentsCopy = new ArrayList<Content>();
            for (Content content : contentList) {
                if (deep) {
                    contentsCopy.add(content.deepCopy(cap, modifier));
                    continue;
                }
                contentsCopy.add(content.copy(cap, modifier));
            }
            copyContents.put(entry.getKey(), contentsCopy);
        }
        return copyContents;
    }

    public MBDRecipe copy(ResourceLocation id) {
        return new MBDRecipe(this.recipeType, id, this.copyContents(this.inputs, false, null), this.copyContents(this.outputs, false, null), this.conditions, this.data, this.duration, this.isFuel, this.priority);
    }

    public MBDRecipe deepCopied(ResourceLocation id) {
        return new MBDRecipe(this.recipeType, id, this.copyContents(this.inputs, true, null), this.copyContents(this.outputs, true, null), this.conditions, this.data, this.duration, this.isFuel, this.priority);
    }

    public MBDRecipe copy() {
        return this.copy(this.id);
    }

    public MBDRecipe copy(ContentModifier modifier) {
        return this.copy(modifier, true);
    }

    public MBDRecipe copy(ContentModifier modifier, boolean modifyDuration) {
        return this.copy(modifier, modifyDuration, IO.BOTH);
    }

    public MBDRecipe copy(ContentModifier modifier, boolean modifyDuration, IO io) {
        MBDRecipe copied = new MBDRecipe(this.recipeType, this.id, io == IO.BOTH || io == IO.IN ? this.copyContents(this.inputs, false, modifier) : this.inputs, io == IO.BOTH || io == IO.OUT ? this.copyContents(this.outputs, false, modifier) : this.outputs, this.conditions, this.data, this.duration, this.isFuel, this.priority);
        if (modifyDuration) {
            copied.duration = modifier.apply(this.duration).intValue();
        }
        return copied;
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return MBDRecipeSerializer.SERIALIZER;
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return this.recipeType;
    }

    public boolean m_5818_(@NotNull Container pContainer, @NotNull Level pLevel) {
        return false;
    }

    public ItemStack m_5874_(Container inventory, RegistryAccess registryManager) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return false;
    }

    public ItemStack m_8043_(RegistryAccess registryManager) {
        return ItemStack.f_41583_;
    }

    public List<Content> getInputContents(RecipeCapability<?> capability) {
        return this.inputs.getOrDefault(capability, Collections.emptyList());
    }

    public List<Content> getOutputContents(RecipeCapability<?> capability) {
        return this.outputs.getOrDefault(capability, Collections.emptyList());
    }

    public ActionResult matchRecipe(IRecipeCapabilityHolder holder) {
        if (!holder.hasProxies()) {
            return ActionResult.FAIL_NO_REASON;
        }
        ActionResult result = this.matchRecipe(false, IO.IN, holder, this.inputs, false);
        if (!result.isSuccess()) {
            return result;
        }
        result = this.matchRecipe(false, IO.OUT, holder, this.outputs, false);
        if (!result.isSuccess()) {
            return result;
        }
        return ActionResult.SUCCESS;
    }

    public ActionResult matchTickRecipe(IRecipeCapabilityHolder holder) {
        if (this.hasTick()) {
            if (!holder.hasProxies()) {
                return ActionResult.FAIL_NO_REASON;
            }
            ActionResult result = this.matchRecipe(true, IO.IN, holder, this.inputs, false);
            if (!result.isSuccess()) {
                return result;
            }
            result = this.matchRecipe(true, IO.OUT, holder, this.outputs, false);
            if (!result.isSuccess()) {
                return result;
            }
        }
        return ActionResult.SUCCESS;
    }

    public ActionResult matchRecipe(boolean perTick, IO io, IRecipeCapabilityHolder holder, Map<RecipeCapability<?>, List<Content>> contents, boolean calculateExpectingRate) {
        Table<IO, RecipeCapability<?>, List<IRecipeHandler<?>>> capabilityProxies = holder.getRecipeCapabilitiesProxy();
        for (Map.Entry<RecipeCapability<?>, List<Content>> entry : contents.entrySet()) {
            Tuple<List, Map<String, List>> result;
            HashSet used = new HashSet();
            List<Object> content = new ArrayList<Object>();
            HashMap<String, List> contentSlot = new HashMap<String, List>();
            for (Content cont : entry.getValue()) {
                if (cont.perTick != perTick) continue;
                if (cont.slotName.isEmpty()) {
                    content.add(cont.content);
                    continue;
                }
                contentSlot.computeIfAbsent(cont.slotName, s -> new ArrayList()).add(cont.content);
            }
            RecipeCapability<?> capability = entry.getKey();
            if ((content = content.stream().map(capability::copyContent).toList()).isEmpty() && contentSlot.isEmpty()) continue;
            if (content.isEmpty()) {
                content = null;
            }
            if ((result = this.handlerContentsInternal(io, io, capabilityProxies, capability, used, content, contentSlot, content, contentSlot, true)).m_14418_() == null && ((Map)result.m_14419_()).isEmpty() || (result = this.handlerContentsInternal(IO.BOTH, io, capabilityProxies, capability, used, (List)result.m_14418_(), (Map)result.m_14419_(), content, contentSlot, true)).m_14418_() == null && ((Map)result.m_14419_()).isEmpty()) continue;
            float expectingRate = 0.0f;
            if (io == IO.NONE || io == IO.BOTH) {
                return ActionResult.FAIL_NO_REASON;
            }
            Tuple<List, Map<String, List>> finalResult = result;
            return ActionResult.fail(() -> {
                MutableComponent reason = Component.m_237115_((String)(io == IO.IN ? "mbd2.recipe_logic.insufficient_in" : "mbd2.recipe_logic.insufficient_out"));
                if (perTick) {
                    reason.m_130946_("/t : ");
                } else {
                    reason.m_130946_(": ");
                }
                reason.m_7220_(capability.getTraslateComponent());
                if (finalResult.m_14418_() != null) {
                    reason.m_130946_("| miss: ");
                    reason.m_7220_(capability.getLeftErrorInfo((List)finalResult.m_14418_()));
                }
                if (!((Map)finalResult.m_14419_()).isEmpty()) {
                    for (Map.Entry tuple : ((Map)finalResult.m_14419_()).entrySet()) {
                        reason.m_130946_("| slot (%s) miss: ".formatted(tuple.getKey()));
                        reason.m_7220_(capability.getLeftErrorInfo((List)tuple.getValue()));
                    }
                }
                return reason;
            }, expectingRate);
        }
        return ActionResult.SUCCESS;
    }

    public boolean handleTickRecipeIO(IO io, IRecipeCapabilityHolder holder) {
        if (!holder.hasProxies() || io == IO.BOTH) {
            return false;
        }
        return this.handleRecipe(true, io, holder, io == IO.IN ? this.inputs : this.outputs);
    }

    public boolean handleRecipeIO(IO io, IRecipeCapabilityHolder holder) {
        if (!holder.hasProxies() || io == IO.BOTH) {
            return false;
        }
        return this.handleRecipe(false, io, holder, io == IO.IN ? this.inputs : this.outputs);
    }

    public boolean handleRecipe(boolean perTick, IO io, IRecipeCapabilityHolder holder, Map<RecipeCapability<?>, List<Content>> contents) {
        Table<IO, RecipeCapability<?>, List<IRecipeHandler<?>>> capabilityProxies = holder.getRecipeCapabilitiesProxy();
        for (Map.Entry<RecipeCapability<?>, List<Content>> entry : contents.entrySet()) {
            Tuple<List, Map<String, List>> result;
            HashSet used = new HashSet();
            List<Object> content = new ArrayList();
            HashMap<String, List> contentSlot = new HashMap<String, List>();
            ArrayList<Object> contentSearch = new ArrayList<Object>();
            HashMap<String, List> contentSlotSearch = new HashMap<String, List>();
            for (Content cont : entry.getValue()) {
                if (cont.perTick != perTick) continue;
                if (cont.slotName.isEmpty()) {
                    contentSearch.add(cont.content);
                } else {
                    contentSlotSearch.computeIfAbsent(cont.slotName, s -> new ArrayList()).add(cont.content);
                }
                if (!(cont.chance >= 1.0f) && !(MBD2.RND.nextFloat() < cont.chance + (float)holder.getChanceTier() * cont.tierChanceBoost)) continue;
                if (cont.slotName.isEmpty()) {
                    content.add(cont.content);
                    continue;
                }
                contentSlot.computeIfAbsent(cont.slotName, s -> new ArrayList()).add(cont.content);
            }
            RecipeCapability<?> capability = entry.getKey();
            if ((content = content.stream().map(capability::copyContent).toList()).isEmpty() && contentSlot.isEmpty()) continue;
            if (content.isEmpty()) {
                content = null;
            }
            if ((result = this.handlerContentsInternal(io, io, capabilityProxies, capability, used, content, contentSlot, contentSearch, contentSlotSearch, false)).m_14418_() == null && ((Map)result.m_14419_()).isEmpty() || (result = this.handlerContentsInternal(IO.BOTH, io, capabilityProxies, capability, used, (List)result.m_14418_(), (Map)result.m_14419_(), contentSearch, contentSlotSearch, false)).m_14418_() == null && ((Map)result.m_14419_()).isEmpty()) continue;
            MBD2.LOGGER.warn("io error while handling a recipe {} outputs. holder: {}", (Object)this.id, (Object)holder);
            return false;
        }
        return true;
    }

    private Tuple<List, Map<String, List>> handlerContentsInternal(IO capIO, IO io, Table<IO, RecipeCapability<?>, List<IRecipeHandler<?>>> capabilityProxies, RecipeCapability<?> capability, Set<IRecipeHandler<?>> used, List content, Map<String, List> contentSlot, List contentSearch, Map<String, List> contentSlotSearch, boolean simulate) {
        if (capabilityProxies.contains((Object)capIO, capability)) {
            Set<String> slotNames;
            List handlers = (List)capabilityProxies.get((Object)capIO, capability);
            for (IRecipeHandler handler : handlers) {
                if (!handler.isDistinct()) continue;
                slotNames = handler.getSlotNames();
                List result = handler.handleRecipe(io, this, contentSearch, null, true);
                if (result == null) {
                    if (slotNames.containsAll(contentSlotSearch.keySet())) {
                        boolean success = true;
                        for (Map.Entry<String, List> entry : contentSlotSearch.entrySet()) {
                            List left = handler.handleRecipe(io, this, entry.getValue(), entry.getKey(), true);
                            if (left == null) continue;
                            success = false;
                            break;
                        }
                        if (success) {
                            if (!simulate) {
                                for (Map.Entry<String, List> entry : contentSlot.entrySet()) {
                                    handler.handleRecipe(io, this, entry.getValue(), entry.getKey(), false);
                                }
                            }
                            contentSlot.clear();
                        }
                    }
                    if (contentSlot.isEmpty()) {
                        if (!simulate) {
                            handler.handleRecipe(io, this, content, null, false);
                        }
                        content = null;
                    }
                }
                if (content != null || !contentSlot.isEmpty()) continue;
                break;
            }
            if (content != null || !contentSlot.isEmpty()) {
                for (IRecipeHandler proxy : handlers) {
                    if (used.contains(proxy) || proxy.isDistinct()) continue;
                    used.add(proxy);
                    if (content != null) {
                        content = proxy.handleRecipe(io, this, content, null, simulate);
                    }
                    if (!(slotNames = proxy.getSlotNames()).isEmpty()) {
                        Iterator<String> iterator = contentSlot.keySet().iterator();
                        while (iterator.hasNext()) {
                            List left;
                            String key = iterator.next();
                            if (!slotNames.contains(key) || (left = proxy.handleRecipe(io, this, contentSlot.get(key), key, simulate)) != null) continue;
                            iterator.remove();
                        }
                    }
                    if (content != null || !contentSlot.isEmpty()) continue;
                    break;
                }
            }
        }
        return new Tuple((Object)content, contentSlot);
    }

    public boolean hasTick() {
        if (this.hasTick == null) {
            for (List<Content> contents : this.inputs.values()) {
                for (Content content : contents) {
                    if (!content.perTick) continue;
                    this.hasTick = true;
                    return true;
                }
            }
            for (List<Content> contents : this.outputs.values()) {
                for (Content content : contents) {
                    if (!content.perTick) continue;
                    this.hasTick = true;
                    return true;
                }
            }
            this.hasTick = false;
        }
        return this.hasTick;
    }

    public void preWorking(IRecipeCapabilityHolder holder) {
        this.handlePre(this.inputs, holder, IO.IN);
        this.handlePre(this.outputs, holder, IO.OUT);
    }

    public void postWorking(IRecipeCapabilityHolder holder) {
        this.handlePost(this.inputs, holder, IO.IN);
        this.handlePost(this.outputs, holder, IO.OUT);
    }

    public void handlePre(Map<RecipeCapability<?>, List<Content>> contents, IRecipeCapabilityHolder holder, IO io) {
        contents.forEach((capability, tuples) -> {
            block3: {
                block2: {
                    if (!holder.getRecipeCapabilitiesProxy().contains((Object)io, capability)) break block2;
                    for (IRecipeHandler capabilityProxy : (List)holder.getRecipeCapabilitiesProxy().get((Object)io, capability)) {
                        capabilityProxy.preWorking(holder, io, this);
                    }
                    break block3;
                }
                if (!holder.getRecipeCapabilitiesProxy().contains((Object)IO.BOTH, capability)) break block3;
                for (IRecipeHandler capabilityProxy : (List)holder.getRecipeCapabilitiesProxy().get((Object)IO.BOTH, capability)) {
                    capabilityProxy.preWorking(holder, io, this);
                }
            }
        });
    }

    public void handlePost(Map<RecipeCapability<?>, List<Content>> contents, IRecipeCapabilityHolder holder, IO io) {
        contents.forEach((capability, tuples) -> {
            block3: {
                block2: {
                    if (!holder.getRecipeCapabilitiesProxy().contains((Object)io, capability)) break block2;
                    for (IRecipeHandler capabilityProxy : (List)holder.getRecipeCapabilitiesProxy().get((Object)io, capability)) {
                        capabilityProxy.postWorking(holder, io, this);
                    }
                    break block3;
                }
                if (!holder.getRecipeCapabilitiesProxy().contains((Object)IO.BOTH, capability)) break block3;
                for (IRecipeHandler capabilityProxy : (List)holder.getRecipeCapabilitiesProxy().get((Object)IO.BOTH, capability)) {
                    capabilityProxy.postWorking(holder, io, this);
                }
            }
        });
    }

    public ActionResult checkConditions(@Nonnull RecipeLogic recipeLogic) {
        if (this.conditions.isEmpty()) {
            return ActionResult.SUCCESS;
        }
        HashMap<String, List> or = new HashMap<String, List>();
        for (RecipeCondition condition2 : this.conditions) {
            if (condition2.isOr()) {
                or.computeIfAbsent(condition2.getType(), type -> new ArrayList()).add(condition2);
                continue;
            }
            if (condition2.test(this, recipeLogic) != condition2.isReverse()) continue;
            return ActionResult.fail(() -> Component.m_237115_((String)"mbd2.recipe_logic.condition_fails").m_130946_(": ").m_7220_(condition2.getTooltips()));
        }
        for (List conditions : or.values()) {
            if (!conditions.stream().allMatch(condition -> condition.test(this, recipeLogic) == condition.isReverse())) continue;
            return ActionResult.fail(() -> Component.m_237115_((String)"mbd2.recipe_logic.condition_fails"));
        }
        return ActionResult.SUCCESS;
    }

    public static Pair<MBDRecipe, Integer> accurateParallel(IRecipeCapabilityHolder recipeCapabilityHolder, @Nonnull MBDRecipe recipe, int maxParallel, boolean modifyDuration) {
        if (maxParallel == 1) {
            return Pair.of((Object)recipe, (Object)1);
        }
        Pair parallel = MBDRecipe.tryParallel(recipeCapabilityHolder, recipe, 1, maxParallel, modifyDuration);
        return parallel == null ? Pair.of((Object)recipe, (Object)1) : parallel;
    }

    @Nullable
    private static Pair<MBDRecipe, Integer> tryParallel(IRecipeCapabilityHolder recipeCapabilityHolder, MBDRecipe original, int min, int max, boolean modifyDuration) {
        if (min > max) {
            return null;
        }
        int mid = (min + max) / 2;
        MBDRecipe copied = original.copy(ContentModifier.multiplier(mid), modifyDuration);
        if (!copied.matchRecipe(recipeCapabilityHolder).isSuccess() || !copied.matchTickRecipe(recipeCapabilityHolder).isSuccess()) {
            return MBDRecipe.tryParallel(recipeCapabilityHolder, original, min, mid - 1, modifyDuration);
        }
        if (mid == max) {
            return Pair.of((Object)copied, (Object)mid);
        }
        Pair tryMore = MBDRecipe.tryParallel(recipeCapabilityHolder, original, mid + 1, max, modifyDuration);
        return tryMore != null ? tryMore : Pair.of((Object)copied, (Object)mid);
    }

    public boolean isFuel() {
        return this.isFuel;
    }

    public record ActionResult(boolean isSuccess, @Nullable Supplier<Component> reason, float expectingRate) {
        public static final ActionResult SUCCESS = new ActionResult(true, null, 0.0f);
        public static final ActionResult FAIL_NO_REASON = new ActionResult(true, null, 0.0f);

        public static ActionResult fail(@Nullable Supplier<Component> component) {
            return new ActionResult(false, component, 0.0f);
        }

        public static ActionResult fail(@Nullable Supplier<Component> component, float expectingRate) {
            return new ActionResult(false, component, expectingRate);
        }
    }
}

