/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.api.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.lowdragmc.lowdraglib.utils.NBTToJsonConverter;
import com.lowdragmc.mbd2.api.capability.recipe.RecipeCapability;
import com.lowdragmc.mbd2.api.recipe.MBDRecipe;
import com.lowdragmc.mbd2.api.recipe.MBDRecipeType;
import com.lowdragmc.mbd2.api.recipe.RecipeCondition;
import com.lowdragmc.mbd2.api.recipe.content.Content;
import com.lowdragmc.mbd2.api.registry.MBDRegistries;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.common.crafting.CraftingHelper;
import org.jetbrains.annotations.NotNull;

public class MBDRecipeSerializer
implements RecipeSerializer<MBDRecipe> {
    public static final MBDRecipeSerializer SERIALIZER = new MBDRecipeSerializer();

    public Map<RecipeCapability<?>, List<Content>> capabilitiesFromJson(JsonObject json) {
        HashMap capabilities = new HashMap();
        for (String key : json.keySet()) {
            JsonArray contentsJson = json.getAsJsonArray(key);
            RecipeCapability capability = (RecipeCapability)MBDRegistries.RECIPE_CAPABILITIES.get(key);
            if (capability == null) continue;
            ArrayList<Content> contents = new ArrayList<Content>();
            for (JsonElement contentJson : contentsJson) {
                contents.add(capability.serializer.fromJsonContent(contentJson));
            }
            capabilities.put(capability, contents);
        }
        return capabilities;
    }

    @NotNull
    public MBDRecipe fromJson(@NotNull ResourceLocation id, @NotNull JsonObject json) {
        String recipeType = GsonHelper.m_13906_((JsonObject)json, (String)"type");
        int duration = json.has("duration") ? GsonHelper.m_13927_((JsonObject)json, (String)"duration") : 100;
        CompoundTag data = new CompoundTag();
        if (json.has("data")) {
            data = CraftingHelper.getNBT((JsonElement)json.get("data"));
        }
        Map<RecipeCapability<?>, List<Content>> inputs = this.capabilitiesFromJson(json.has("inputs") ? json.getAsJsonObject("inputs") : new JsonObject());
        Map<RecipeCapability<?>, List<Content>> outputs = this.capabilitiesFromJson(json.has("outputs") ? json.getAsJsonObject("outputs") : new JsonObject());
        ArrayList<RecipeCondition> conditions = new ArrayList<RecipeCondition>();
        JsonArray conditionsJson = json.has("recipeConditions") ? json.getAsJsonArray("recipeConditions") : new JsonArray();
        for (JsonElement jsonElement : conditionsJson) {
            RecipeCondition condition;
            JsonObject jsonObject;
            String conditionKey;
            Class clazz;
            if (!(jsonElement instanceof JsonObject) || (clazz = (Class)MBDRegistries.RECIPE_CONDITIONS.get(conditionKey = GsonHelper.m_13851_((JsonObject)(jsonObject = (JsonObject)jsonElement), (String)"type", (String)""))) == null || (condition = RecipeCondition.create(clazz)) == null) continue;
            conditions.add(condition.deserialize(GsonHelper.m_13841_((JsonObject)jsonObject, (String)"data", (JsonObject)new JsonObject())));
        }
        boolean isFuel = GsonHelper.m_13855_((JsonObject)json, (String)"isFuel", (boolean)false);
        int priority = GsonHelper.m_13824_((JsonObject)json, (String)"priority", (int)0);
        return new MBDRecipe((MBDRecipeType)BuiltInRegistries.f_256990_.m_7745_(new ResourceLocation(recipeType)), id, inputs, outputs, conditions, data, duration, isFuel, priority);
    }

    public JsonObject capabilitiesToJson(Map<RecipeCapability<?>, List<Content>> contents) {
        JsonObject jsonObject = new JsonObject();
        contents.forEach((cap, list) -> {
            JsonArray contentsJson = new JsonArray();
            for (Content content : list) {
                contentsJson.add(cap.serializer.toJsonContent(content));
            }
            jsonObject.add((String)MBDRegistries.RECIPE_CAPABILITIES.getKey((RecipeCapability<?>)cap), (JsonElement)contentsJson);
        });
        return jsonObject;
    }

    public JsonObject toJson(@NotNull MBDRecipe recipe) {
        JsonObject json = new JsonObject();
        json.addProperty("type", recipe.recipeType.getRegistryName().toString());
        json.addProperty("duration", (Number)Math.abs(recipe.duration));
        if (recipe.data != null && !recipe.data.m_128456_()) {
            json.add("data", NBTToJsonConverter.getObject((Tag)recipe.data));
        }
        json.add("inputs", (JsonElement)this.capabilitiesToJson(recipe.inputs));
        json.add("outputs", (JsonElement)this.capabilitiesToJson(recipe.outputs));
        if (!recipe.conditions.isEmpty()) {
            JsonArray array = new JsonArray();
            for (RecipeCondition condition : recipe.conditions) {
                JsonObject cond = new JsonObject();
                cond.addProperty("type", (String)MBDRegistries.RECIPE_CONDITIONS.getKey(condition.getClass()));
                cond.add("data", (JsonElement)condition.serialize());
                array.add((JsonElement)cond);
            }
            json.add("recipeConditions", (JsonElement)array);
        }
        if (recipe.isFuel) {
            json.addProperty("isFuel", Boolean.valueOf(true));
        }
        if (recipe.priority != 0) {
            json.addProperty("priority", (Number)recipe.priority);
        }
        return json;
    }

    public static Tuple<RecipeCapability<?>, List<Content>> entryReader(FriendlyByteBuf buf) {
        RecipeCapability capability = (RecipeCapability)MBDRegistries.RECIPE_CAPABILITIES.get(buf.m_130277_());
        List contents = buf.m_236845_(capability.serializer::fromNetworkContent);
        return new Tuple((Object)capability, (Object)contents);
    }

    public static void entryWriter(FriendlyByteBuf buf, Map.Entry<RecipeCapability<?>, ? extends List<Content>> entry) {
        RecipeCapability<?> capability = entry.getKey();
        List<Content> contents = entry.getValue();
        buf.m_130070_((String)MBDRegistries.RECIPE_CAPABILITIES.getKey(capability));
        buf.m_236828_(contents, capability.serializer::toNetworkContent);
    }

    public static RecipeCondition conditionReader(FriendlyByteBuf buf) {
        RecipeCondition condition = RecipeCondition.create((Class)MBDRegistries.RECIPE_CONDITIONS.get(buf.m_130277_()));
        return condition.fromNetwork(buf);
    }

    public static void conditionWriter(FriendlyByteBuf buf, RecipeCondition condition) {
        buf.m_130070_((String)MBDRegistries.RECIPE_CONDITIONS.getKey(condition.getClass()));
        condition.toNetwork(buf);
    }

    public static Map<RecipeCapability<?>, List<Content>> tuplesToMap(List<Tuple<RecipeCapability<?>, List<Content>>> entries) {
        HashMap map = new HashMap();
        entries.forEach(entry -> map.put((RecipeCapability)entry.m_14418_(), (List)entry.m_14419_()));
        return map;
    }

    @NotNull
    public MBDRecipe fromNetwork(@NotNull ResourceLocation id, @NotNull FriendlyByteBuf buf) {
        String recipeType = buf.m_130277_();
        int duration = buf.m_130242_();
        Map<RecipeCapability<?>, List<Content>> inputs = MBDRecipeSerializer.tuplesToMap((List)buf.m_236838_(c -> new ArrayList(), MBDRecipeSerializer::entryReader));
        Map<RecipeCapability<?>, List<Content>> outputs = MBDRecipeSerializer.tuplesToMap((List)buf.m_236838_(c -> new ArrayList(), MBDRecipeSerializer::entryReader));
        List conditions = (List)buf.m_236838_(c -> new ArrayList(), MBDRecipeSerializer::conditionReader);
        CompoundTag data = buf.m_130260_();
        boolean isFuel = buf.readBoolean();
        int priority = buf.m_130242_();
        return new MBDRecipe((MBDRecipeType)BuiltInRegistries.f_256990_.m_7745_(new ResourceLocation(recipeType)), id, inputs, outputs, conditions, data, duration, isFuel, priority);
    }

    public void toNetwork(FriendlyByteBuf buf, MBDRecipe recipe) {
        buf.m_130070_(recipe.recipeType == null ? "dummy" : recipe.recipeType.toString());
        buf.m_130130_(recipe.duration);
        buf.m_236828_(recipe.inputs.entrySet(), MBDRecipeSerializer::entryWriter);
        buf.m_236828_(recipe.outputs.entrySet(), MBDRecipeSerializer::entryWriter);
        buf.m_236828_(recipe.conditions, MBDRecipeSerializer::conditionWriter);
        buf.m_130079_(recipe.data);
        buf.writeBoolean(recipe.isFuel);
        buf.m_130130_(recipe.priority);
    }

    public Map<RecipeCapability<?>, List<Content>> capabilitiesFromNBT(CompoundTag nbt) {
        HashMap capabilities = new HashMap();
        for (String key : nbt.m_128431_()) {
            ArrayList<Content> contents = new ArrayList<Content>();
            RecipeCapability capability = (RecipeCapability)MBDRegistries.RECIPE_CAPABILITIES.get(key);
            if (capability == null) continue;
            for (Tag tag : nbt.m_128437_(key, 10)) {
                contents.add(capability.serializer.fromNBT((CompoundTag)tag));
            }
            capabilities.put(capability, contents);
        }
        return capabilities;
    }

    public MBDRecipe fromNBT(@NotNull ResourceLocation id, @NotNull CompoundTag nbt) {
        String recipeType = nbt.m_128461_("type");
        int duration = nbt.m_128451_("duration");
        Map<RecipeCapability<?>, List<Content>> inputs = this.capabilitiesFromNBT(nbt.m_128469_("inputs"));
        Map<RecipeCapability<?>, List<Content>> outputs = this.capabilitiesFromNBT(nbt.m_128469_("outputs"));
        ArrayList<RecipeCondition> conditions = new ArrayList<RecipeCondition>();
        for (Tag tag : nbt.m_128437_("recipeConditions", 10)) {
            CompoundTag conditionTag = (CompoundTag)tag;
            RecipeCondition condition = RecipeCondition.create((Class)MBDRegistries.RECIPE_CONDITIONS.get(conditionTag.m_128461_("type")));
            if (condition == null) continue;
            conditions.add(condition.fromNBT(conditionTag.m_128469_("data")));
        }
        CompoundTag data = nbt.m_128469_("data");
        boolean isFuel = nbt.m_128471_("isFuel");
        int priority = nbt.m_128451_("priority");
        return new MBDRecipe((MBDRecipeType)BuiltInRegistries.f_256990_.m_7745_(new ResourceLocation(recipeType)), id, inputs, outputs, conditions, data, duration, isFuel, priority);
    }

    public CompoundTag capabilitiesToNBT(Map<RecipeCapability<?>, List<Content>> contents) {
        CompoundTag tag = new CompoundTag();
        contents.forEach((cap, list) -> {
            ListTag contentsTag = new ListTag();
            for (Content content : list) {
                contentsTag.add((Object)cap.serializer.toNBT(content));
            }
            tag.m_128365_(cap.name, (Tag)contentsTag);
        });
        return tag;
    }

    public CompoundTag toNBT(@NotNull MBDRecipe recipe) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("type", recipe.recipeType.toString());
        nbt.m_128405_("duration", recipe.duration);
        nbt.m_128365_("inputs", (Tag)this.capabilitiesToNBT(recipe.inputs));
        nbt.m_128365_("outputs", (Tag)this.capabilitiesToNBT(recipe.outputs));
        ListTag conditions = new ListTag();
        for (RecipeCondition condition : recipe.conditions) {
            CompoundTag conditionTag = new CompoundTag();
            conditionTag.m_128359_("type", (String)MBDRegistries.RECIPE_CONDITIONS.getKey(condition.getClass()));
            conditionTag.m_128365_("data", (Tag)condition.toNBT());
            conditions.add((Object)conditionTag);
        }
        nbt.m_128365_("recipeConditions", (Tag)conditions);
        nbt.m_128365_("data", (Tag)recipe.data);
        nbt.m_128379_("isFuel", recipe.isFuel);
        nbt.m_128405_("priority", recipe.priority);
        return nbt;
    }
}

