/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.api.recipe;

import com.lowdragmc.lowdraglib.Platform;
import com.lowdragmc.lowdraglib.syncdata.IEnhancedManaged;
import com.lowdragmc.lowdraglib.syncdata.IManaged;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.annotation.RequireRerender;
import com.lowdragmc.lowdraglib.syncdata.field.FieldManagedStorage;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import com.lowdragmc.mbd2.api.capability.recipe.IO;
import com.lowdragmc.mbd2.api.machine.IMachine;
import com.lowdragmc.mbd2.api.recipe.MBDRecipe;
import com.lowdragmc.mbd2.config.ConfigHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.crafting.RecipeManager;
import org.jetbrains.annotations.VisibleForTesting;

public class RecipeLogic
implements IEnhancedManaged {
    private final FieldManagedStorage syncStorage = new FieldManagedStorage((IManaged)this);
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(RecipeLogic.class);
    public final IMachine machine;
    public List<MBDRecipe> lastFailedMatches;
    @Persisted
    @DescSynced
    @RequireRerender
    private Status status = Status.IDLE;
    @Nullable
    @Persisted
    @DescSynced
    private Component waitingReason = null;
    @Nullable
    @Persisted
    protected MBDRecipe lastRecipe;
    @Nullable
    @Persisted
    protected MBDRecipe lastOriginRecipe;
    @Persisted
    protected int progress;
    @Persisted
    protected int duration;
    @Persisted
    protected int fuelTime;
    @Nullable
    @Persisted
    protected MBDRecipe lastFuelRecipe;
    @Persisted
    protected int fuelMaxTime;
    protected boolean recipeDirty;
    @Persisted
    protected long totalContinuousRunningTime;
    @Nullable
    protected CompletableFuture<List<MBDRecipe>> completableFuture = null;

    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    public void onChanged() {
        this.machine.markDirty();
    }

    public void scheduleRenderUpdate() {
        this.machine.scheduleRenderUpdate();
    }

    public RecipeLogic(IMachine machine) {
        this.machine = machine;
    }

    public void resetRecipeLogic() {
        this.interruptRecipe();
        this.recipeDirty = false;
        this.lastRecipe = null;
        this.lastOriginRecipe = null;
        this.progress = 0;
        this.duration = 0;
        this.fuelTime = 0;
        this.lastFailedMatches = null;
        this.setStatus(Status.IDLE);
    }

    public double getProgressPercent() {
        return this.duration == 0 ? 0.0 : (double)this.progress / ((double)this.duration * 1.0);
    }

    public double getFuelProgressPercent() {
        return this.fuelMaxTime == 0 ? 0.0 : (double)this.fuelTime / ((double)this.fuelMaxTime * 1.0);
    }

    public boolean needFuel() {
        return this.machine.getRecipeType().isRequireFuelForWorking();
    }

    public RecipeManager getRecipeManager() {
        return Platform.getMinecraftServer().m_129894_();
    }

    public void serverTick() {
        if (!this.isSuspend()) {
            if (!this.isIdle() && this.lastRecipe != null) {
                if (this.progress < this.duration) {
                    this.handleRecipeWorking();
                }
                if (!this.isIdle() && this.duration != 0 && this.progress >= this.duration) {
                    this.onRecipeFinish();
                }
            } else if (this.lastRecipe != null) {
                this.findAndHandleRecipe();
            } else if (this.getMachine().getOffsetTimer() % 5L == 0L) {
                this.findAndHandleRecipe();
                if (this.lastFailedMatches != null) {
                    for (MBDRecipe match : this.lastFailedMatches) {
                        if (this.checkMatchedRecipeAvailable(match)) break;
                    }
                }
            }
        }
        if (this.fuelTime > 0) {
            --this.fuelTime;
            if (this.fuelTime == 0) {
                this.getMachine().onFuelBurningFinish(this.lastFuelRecipe);
            }
        } else if (this.isSuspend() && this.completableFuture != null) {
            this.completableFuture.cancel(true);
            this.completableFuture = null;
        }
    }

    protected boolean checkMatchedRecipeAvailable(MBDRecipe match) {
        MBDRecipe modified = this.machine.doModifyRecipe(match);
        if (modified != null) {
            if (modified.checkConditions(this).isSuccess() && modified.matchRecipe(this.machine).isSuccess() && modified.matchTickRecipe(this.machine).isSuccess()) {
                this.setupRecipe(modified);
            }
            if (this.lastRecipe != null && this.getStatus() == Status.WORKING) {
                this.lastOriginRecipe = match;
                this.lastFailedMatches = null;
                return true;
            }
        }
        return false;
    }

    public void handleRecipeWorking() {
        Status last = this.status;
        assert (this.lastRecipe != null);
        MBDRecipe.ActionResult result = this.lastRecipe.checkConditions(this);
        if (result.isSuccess()) {
            if (this.handleFuelRecipe()) {
                result = this.handleTickRecipe(this.lastRecipe);
                if (result.isSuccess()) {
                    this.setStatus(Status.WORKING);
                    if (this.machine.onWorking()) {
                        this.interruptRecipe();
                        return;
                    }
                    ++this.progress;
                    ++this.totalContinuousRunningTime;
                } else {
                    this.setWaiting(result.reason().get());
                }
            } else {
                this.setWaiting((Component)Component.m_237115_((String)"mbd2.recipe_logic.insufficient_fuel"));
            }
        } else {
            this.setWaiting(result.reason().get());
        }
        if (this.isWaiting()) {
            this.doDamping();
        }
        if (last == Status.WORKING && this.getStatus() != Status.WORKING) {
            this.lastRecipe.postWorking(this.machine);
        } else if (last != Status.WORKING && this.getStatus() == Status.WORKING) {
            this.lastRecipe.preWorking(this.machine);
        }
    }

    protected void doDamping() {
        if (this.progress > 0 && this.machine.dampingWhenWaiting()) {
            this.progress = Math.max(0, this.progress - this.getMachine().getRecipeDampingValue());
        }
    }

    protected List<MBDRecipe> searchRecipe() {
        return this.machine.getRecipeType().searchRecipe(this.getRecipeManager(), this.machine);
    }

    public void findAndHandleRecipe() {
        this.lastFailedMatches = null;
        if (!this.recipeDirty && this.lastRecipe != null && this.lastRecipe.matchRecipe(this.machine).isSuccess() && this.lastRecipe.matchTickRecipe(this.machine).isSuccess() && this.lastRecipe.checkConditions(this).isSuccess()) {
            MBDRecipe recipe = this.lastRecipe;
            this.lastRecipe = null;
            this.lastOriginRecipe = null;
            this.setupRecipe(recipe);
        } else {
            this.lastRecipe = null;
            this.lastOriginRecipe = null;
            if (this.completableFuture == null) {
                if (ConfigHolder.asyncRecipeSearching) {
                    this.completableFuture = this.supplyAsyncSearchingTask();
                } else {
                    this.handleSearchingRecipes(this.searchRecipe());
                }
            } else if (this.completableFuture.isDone()) {
                CompletableFuture<List<MBDRecipe>> lastFuture = this.completableFuture;
                this.completableFuture = null;
                if (!lastFuture.isCancelled()) {
                    try {
                        List<MBDRecipe> matches = lastFuture.join().stream().filter(match -> match.matchRecipe(this.machine).isSuccess()).toList();
                        if (!matches.isEmpty()) {
                            this.handleSearchingRecipes(matches);
                        }
                    }
                    catch (Throwable throwable) {
                        this.completableFuture = this.supplyAsyncSearchingTask();
                    }
                } else {
                    this.handleSearchingRecipes(this.searchRecipe());
                }
            }
        }
        this.recipeDirty = false;
    }

    private CompletableFuture<List<MBDRecipe>> supplyAsyncSearchingTask() {
        return CompletableFuture.supplyAsync(Util.m_183946_((String)"Searching recipes", this::searchRecipe), Util.m_183991_());
    }

    private void handleSearchingRecipes(List<MBDRecipe> matches) {
        for (MBDRecipe match : matches) {
            if (this.checkMatchedRecipeAvailable(match)) break;
            if (this.lastFailedMatches == null) {
                this.lastFailedMatches = new ArrayList<MBDRecipe>();
            }
            this.lastFailedMatches.add(match);
        }
    }

    public boolean handleFuelRecipe() {
        if (!this.needFuel() || this.fuelTime > 0) {
            return true;
        }
        this.lastFuelRecipe = null;
        for (MBDRecipe recipe : this.machine.getRecipeType().searchFuelRecipe(this.getRecipeManager(), this.machine)) {
            recipe = this.getMachine().modifyFuelRecipe(recipe);
            if (recipe.checkConditions(this).isSuccess() && recipe.handleRecipeIO(IO.IN, this.machine)) {
                this.fuelTime = this.fuelMaxTime = recipe.duration;
                this.lastFuelRecipe = recipe;
            }
            if (this.fuelTime <= 0) continue;
            return true;
        }
        return false;
    }

    public MBDRecipe.ActionResult handleTickRecipe(MBDRecipe recipe) {
        if (recipe.hasTick()) {
            MBDRecipe.ActionResult result = recipe.matchTickRecipe(this.machine);
            if (result.isSuccess()) {
                recipe.handleTickRecipeIO(IO.IN, this.machine);
                recipe.handleTickRecipeIO(IO.OUT, this.machine);
            } else {
                return result;
            }
        }
        return MBDRecipe.ActionResult.SUCCESS;
    }

    public void setupRecipe(MBDRecipe recipe) {
        if (this.handleFuelRecipe()) {
            if (this.machine.beforeWorking(recipe)) {
                this.setStatus(Status.IDLE);
                this.progress = 0;
                this.duration = 0;
                return;
            }
            recipe.preWorking(this.machine);
            if (recipe.handleRecipeIO(IO.IN, this.machine)) {
                this.recipeDirty = false;
                this.lastRecipe = recipe;
                this.setStatus(Status.WORKING);
                this.progress = 0;
                this.duration = recipe.duration;
            }
        }
    }

    public void setStatus(Status status) {
        if (this.status != status) {
            if (this.status == Status.WORKING) {
                this.totalContinuousRunningTime = 0L;
            }
            this.machine.notifyRecipeStatusChanged(this.status, status);
            this.status = status;
            if (this.status != Status.WAITING) {
                this.waitingReason = null;
            }
        }
    }

    public void setWaiting(@Nullable Component reason) {
        this.setStatus(Status.WAITING);
        this.waitingReason = reason;
        this.machine.onWaiting();
    }

    public void markLastRecipeDirty() {
        this.recipeDirty = true;
    }

    public boolean isWorking() {
        return this.status == Status.WORKING;
    }

    public boolean isIdle() {
        return this.status == Status.IDLE;
    }

    public boolean isWaiting() {
        return this.status == Status.WAITING;
    }

    public boolean isSuspend() {
        return this.status == Status.SUSPEND;
    }

    public void setWorkingEnabled(boolean isWorkingAllowed) {
        if (!isWorkingAllowed) {
            this.setStatus(Status.SUSPEND);
        } else if (this.lastRecipe != null && this.duration > 0) {
            this.setStatus(Status.WORKING);
        } else {
            this.setStatus(Status.IDLE);
        }
    }

    public int getMaxProgress() {
        return this.duration;
    }

    public boolean isActive() {
        return this.isWorking() || this.isWaiting() || this.isSuspend() && this.lastRecipe != null && this.duration > 0;
    }

    @Deprecated
    public boolean isHasNotEnoughEnergy() {
        return this.isWaiting();
    }

    public void onRecipeFinish() {
        this.machine.afterWorking();
        if (this.lastRecipe != null) {
            this.lastRecipe.postWorking(this.machine);
            this.lastRecipe.handleRecipeIO(IO.OUT, this.machine);
            if (this.machine.alwaysReSearchRecipe()) {
                this.markLastRecipeDirty();
            }
            if (!this.recipeDirty && this.machine.alwaysTryModifyRecipe()) {
                if (this.lastOriginRecipe != null) {
                    MBDRecipe modified = this.machine.doModifyRecipe(this.lastOriginRecipe);
                    if (modified == null) {
                        this.markLastRecipeDirty();
                    } else {
                        this.lastRecipe = modified;
                    }
                } else {
                    this.markLastRecipeDirty();
                }
            }
            if (!this.recipeDirty && this.lastRecipe.matchRecipe(this.machine).isSuccess() && this.lastRecipe.matchTickRecipe(this.machine).isSuccess() && this.lastRecipe.checkConditions(this).isSuccess()) {
                this.setupRecipe(this.lastRecipe);
            } else {
                this.setStatus(Status.IDLE);
                this.progress = 0;
                this.duration = 0;
            }
        }
    }

    public void interruptRecipe() {
        this.machine.afterWorking();
        if (this.lastRecipe != null) {
            this.lastRecipe.postWorking(this.machine);
            this.setStatus(Status.IDLE);
            this.progress = 0;
            this.duration = 0;
        }
    }

    public void inValid() {
        if (this.lastRecipe != null && this.isWorking()) {
            this.lastRecipe.postWorking(this.machine);
        }
    }

    public FieldManagedStorage getSyncStorage() {
        return this.syncStorage;
    }

    public IMachine getMachine() {
        return this.machine;
    }

    public Status getStatus() {
        return this.status;
    }

    @Nullable
    public Component getWaitingReason() {
        return this.waitingReason;
    }

    @Nullable
    public MBDRecipe getLastRecipe() {
        return this.lastRecipe;
    }

    public void setLastRecipe(@Nullable MBDRecipe lastRecipe) {
        this.lastRecipe = lastRecipe;
    }

    @Nullable
    public MBDRecipe getLastOriginRecipe() {
        return this.lastOriginRecipe;
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public int getFuelTime() {
        return this.fuelTime;
    }

    public void setFuelTime(int fuelTime) {
        this.fuelTime = fuelTime;
    }

    @Nullable
    public MBDRecipe getLastFuelRecipe() {
        return this.lastFuelRecipe;
    }

    public void setLastFuelRecipe(@Nullable MBDRecipe lastFuelRecipe) {
        this.lastFuelRecipe = lastFuelRecipe;
    }

    public int getFuelMaxTime() {
        return this.fuelMaxTime;
    }

    public void setFuelMaxTime(int fuelMaxTime) {
        this.fuelMaxTime = fuelMaxTime;
    }

    @VisibleForTesting
    public boolean isRecipeDirty() {
        return this.recipeDirty;
    }

    public long getTotalContinuousRunningTime() {
        return this.totalContinuousRunningTime;
    }

    public void setTotalContinuousRunningTime(long totalContinuousRunningTime) {
        this.totalContinuousRunningTime = totalContinuousRunningTime;
    }

    public static enum Status {
        IDLE,
        WORKING,
        WAITING,
        SUSPEND;

    }
}

