/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.api.recipe.content;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.lowdragmc.mbd2.api.recipe.content.ContentModifier;
import com.lowdragmc.mbd2.api.recipe.content.IContentSerializer;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import org.apache.commons.lang3.math.NumberUtils;

public class SerializerFloat
implements IContentSerializer<Float> {
    public static SerializerFloat INSTANCE = new SerializerFloat();

    private SerializerFloat() {
    }

    @Override
    public void toNetwork(FriendlyByteBuf buf, Float content) {
        buf.writeFloat(content.floatValue());
    }

    @Override
    public Float fromNetwork(FriendlyByteBuf buf) {
        return Float.valueOf(buf.readFloat());
    }

    @Override
    public Tag toNBT(Float content) {
        return FloatTag.m_128566_((float)content.floatValue());
    }

    @Override
    public Float fromNBT(Tag nbt) {
        if (nbt instanceof FloatTag) {
            FloatTag floatTag = (FloatTag)nbt;
            return Float.valueOf(floatTag.m_7057_());
        }
        return Float.valueOf(0.0f);
    }

    @Override
    public Float fromJson(JsonElement json) {
        return Float.valueOf(json.getAsFloat());
    }

    @Override
    public JsonElement toJson(Float content) {
        return new JsonPrimitive((Number)content);
    }

    @Override
    public Float of(Object o) {
        if (o instanceof Float) {
            return (Float)o;
        }
        if (o instanceof Number) {
            return Float.valueOf(((Number)o).floatValue());
        }
        if (o instanceof CharSequence) {
            return Float.valueOf(NumberUtils.toFloat((String)o.toString(), (float)1.0f));
        }
        return Float.valueOf(0.0f);
    }

    @Override
    public Float copyWithModifier(Float content, ContentModifier modifier) {
        return Float.valueOf(modifier.apply(content).floatValue());
    }

    @Override
    public Float copyInner(Float content) {
        return content;
    }
}

