/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.api.recipe.content;

import com.google.gson.JsonElement;
import com.lowdragmc.mbd2.api.recipe.content.ContentModifier;
import com.lowdragmc.mbd2.api.recipe.content.IContentSerializer;
import com.lowdragmc.mbd2.api.recipe.ingredient.SizedIngredient;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class SerializerIngredient
implements IContentSerializer<Ingredient> {
    public static SerializerIngredient INSTANCE = new SerializerIngredient();

    private SerializerIngredient() {
    }

    @Override
    public void toNetwork(FriendlyByteBuf buf, Ingredient content) {
        content.m_43923_(buf);
    }

    @Override
    public Ingredient fromNetwork(FriendlyByteBuf buf) {
        return Ingredient.m_43940_((FriendlyByteBuf)buf);
    }

    @Override
    public Ingredient fromJson(JsonElement json) {
        return Ingredient.m_43917_((JsonElement)json);
    }

    @Override
    public JsonElement toJson(Ingredient content) {
        return content.m_43942_();
    }

    @Override
    public Ingredient of(Object o) {
        if (o instanceof Ingredient) {
            Ingredient ingredient = (Ingredient)o;
            return ingredient;
        }
        if (o instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)o;
            return SizedIngredient.create(itemStack);
        }
        if (o instanceof ItemLike) {
            ItemLike itemLike = (ItemLike)o;
            return Ingredient.m_43929_((ItemLike[])new ItemLike[]{itemLike});
        }
        if (o instanceof TagKey) {
            TagKey tag = (TagKey)o;
            return Ingredient.m_204132_((TagKey)tag);
        }
        return Ingredient.f_43901_;
    }

    @Override
    public Ingredient copyInner(Ingredient content) {
        return SizedIngredient.copy(content);
    }

    @Override
    public Ingredient copyWithModifier(Ingredient content, ContentModifier modifier) {
        SizedIngredient sizedIngredient;
        if (content instanceof SizedIngredient) {
            SizedIngredient sizedIngredient2 = (SizedIngredient)content;
            sizedIngredient = SizedIngredient.create(sizedIngredient2.getInner(), modifier.apply(sizedIngredient2.getAmount()).intValue());
        } else {
            sizedIngredient = SizedIngredient.create(content, modifier.apply(1).intValue());
        }
        return sizedIngredient;
    }
}

