/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.api.recipe.ingredient;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.mbd2.MBD2;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Arrays;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.common.crafting.StrictNBTIngredient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SizedIngredient
extends Ingredient {
    public static final ResourceLocation TYPE = MBD2.id("sized");
    protected final int amount;
    protected Ingredient inner;
    protected ItemStack[] itemStacks = null;
    public static final IIngredientSerializer<SizedIngredient> SERIALIZER = new IIngredientSerializer<SizedIngredient>(){

        @NotNull
        public SizedIngredient parse(FriendlyByteBuf buffer) {
            int amount = buffer.m_130242_();
            return new SizedIngredient(Ingredient.m_43940_((FriendlyByteBuf)buffer), amount);
        }

        @NotNull
        public SizedIngredient parse(JsonObject json) {
            Ingredient inner;
            int amount = json.get("count").getAsInt();
            try {
                inner = Ingredient.m_43917_((JsonElement)json.get("ingredient"));
            }
            catch (Exception e) {
                LDLib.LOGGER.error("Failed to parse ingredient from json: " + String.valueOf(json), (Throwable)e);
                inner = Ingredient.f_43901_;
            }
            return new SizedIngredient(inner, amount);
        }

        public void write(FriendlyByteBuf buffer, SizedIngredient ingredient) {
            buffer.m_130130_(ingredient.getAmount());
            ingredient.inner.m_43923_(buffer);
        }
    };

    protected SizedIngredient(Ingredient inner, int amount) {
        super(Stream.empty());
        this.amount = amount;
        this.inner = inner;
    }

    protected SizedIngredient(@NotNull TagKey<Item> tag, int amount) {
        this(Ingredient.m_204132_(tag), amount);
    }

    protected SizedIngredient(ItemStack itemStack) {
        this((Ingredient)(itemStack.m_41782_() || itemStack.m_41773_() > 0 ? StrictNBTIngredient.of((ItemStack)itemStack) : Ingredient.m_43927_((ItemStack[])new ItemStack[]{itemStack})), itemStack.m_41613_());
    }

    public static SizedIngredient create(ItemStack inner) {
        return new SizedIngredient(inner);
    }

    public static SizedIngredient create(Ingredient inner, int amount) {
        return new SizedIngredient(inner, amount);
    }

    public static SizedIngredient create(Ingredient inner) {
        return new SizedIngredient(inner, 1);
    }

    public static SizedIngredient create(TagKey<Item> tag, int amount) {
        return new SizedIngredient(tag, amount);
    }

    public static SizedIngredient copy(Ingredient ingredient) {
        if (ingredient instanceof SizedIngredient) {
            SizedIngredient sizedIngredient = (SizedIngredient)ingredient;
            SizedIngredient copied = SizedIngredient.create(sizedIngredient.inner, sizedIngredient.amount);
            if (sizedIngredient.itemStacks != null) {
                copied.itemStacks = (ItemStack[])Arrays.stream(sizedIngredient.itemStacks).map(ItemStack::m_41777_).toArray(ItemStack[]::new);
            }
            return copied;
        }
        return SizedIngredient.create(ingredient);
    }

    public void updateInnerIngredient(@Nonnull Ingredient inner) {
        this.inner = inner;
        this.itemStacks = null;
    }

    @Nonnull
    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return SERIALIZER;
    }

    public static SizedIngredient fromJson(JsonObject json) {
        return (SizedIngredient)SERIALIZER.parse(json);
    }

    @NotNull
    public JsonElement m_43942_() {
        JsonObject json = new JsonObject();
        json.addProperty("type", TYPE.toString());
        json.addProperty("count", (Number)this.amount);
        json.add("ingredient", this.inner.m_43942_());
        return json;
    }

    public boolean test(@Nullable ItemStack stack) {
        return this.inner.test(stack);
    }

    public ItemStack @NotNull [] m_43908_() {
        if (this.itemStacks == null) {
            this.itemStacks = (ItemStack[])Arrays.stream(this.inner.m_43908_()).map(i -> {
                ItemStack ic = i.m_41777_();
                ic.m_41764_(this.amount);
                return ic;
            }).toArray(ItemStack[]::new);
        }
        return this.itemStacks;
    }

    @NotNull
    public IntList m_43931_() {
        return this.inner.m_43931_();
    }

    public boolean m_43947_() {
        return this.inner.m_43947_();
    }

    public int getAmount() {
        return this.amount;
    }

    public Ingredient getInner() {
        return this.inner;
    }
}

