/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common.block;

import com.lowdragmc.lowdraglib.client.model.ModelFactory;
import com.lowdragmc.lowdraglib.client.renderer.IBlockRendererProvider;
import com.lowdragmc.lowdraglib.client.renderer.IRenderer;
import com.lowdragmc.mbd2.api.block.RotationState;
import com.lowdragmc.mbd2.api.machine.IMachine;
import com.lowdragmc.mbd2.common.machine.MBDMachine;
import com.lowdragmc.mbd2.common.machine.definition.MBDMachineDefinition;
import java.util.List;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class MBDMachineBlock
extends Block
implements EntityBlock,
IBlockRendererProvider,
SimpleWaterloggedBlock {
    private final MBDMachineDefinition definition;
    private final RotationState rotationState;

    public MBDMachineBlock(BlockBehaviour.Properties properties, MBDMachineDefinition definition) {
        super(properties);
        this.definition = definition;
        this.rotationState = definition.blockProperties().rotationState();
        this.rotationState.property.ifPresent(property -> this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)property, (Comparable)this.rotationState.defaultDirection)));
        if (definition.blockProperties().canBeWaterlogged()) {
            this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
        }
    }

    public Optional<Direction> getFrontFacing(BlockState state) {
        return this.rotationState.property.map(arg_0 -> ((BlockState)state).m_61143_(arg_0));
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return this.getDefinition().blockEntityType().m_155264_(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        if (blockEntityType == this.getDefinition().blockEntityType()) {
            return (world, pos, state1, blockEntity) -> IMachine.ofMachine(blockEntity).filter(MBDMachine.class::isInstance).map(MBDMachine.class::cast).ifPresent(machine -> {
                if (world.f_46443_) {
                    machine.clientTick();
                } else {
                    machine.serverTick();
                }
            });
        }
        return null;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        RotationState rotationState = MBDMachineDefinition.get().blockProperties().rotationState();
        rotationState.property.ifPresent(xva$0 -> builder.m_61104_(new Property[]{xva$0}));
        if (MBDMachineDefinition.get().blockProperties().canBeWaterlogged()) {
            builder.m_61104_(new Property[]{BlockStateProperties.f_61362_});
        }
    }

    @Nullable
    public IRenderer getRenderer(BlockState state) {
        return this.definition.blockRenderer();
    }

    @OnlyIn(value=Dist.CLIENT)
    public ModelState getModelState(BlockAndTintGetter world, BlockPos pos, BlockState state) {
        return ModelFactory.getRotation((Direction)this.getRotationState().property.map(arg_0 -> ((BlockState)state).m_61143_(arg_0)).orElse(Direction.NORTH));
    }

    public Optional<MBDMachine> getMachine(BlockGetter level, BlockPos pos) {
        return IMachine.ofMachine(level, pos).filter(MBDMachine.class::isInstance).map(MBDMachine.class::cast);
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return this.getMachine(pLevel, pPos).map(machine -> machine.getShape(pContext)).orElse(Shapes.m_83144_());
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        super.m_214162_(state, level, pos, random);
        this.getMachine((BlockGetter)level, pos).ifPresent(machine -> machine.animateTick(random));
    }

    public boolean m_180643_(BlockState state, BlockGetter level, BlockPos pos) {
        return false;
    }

    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, @Nullable LivingEntity player, ItemStack pStack) {
        if (!pLevel.f_46443_) {
            this.getMachine((BlockGetter)pLevel, pPos).ifPresent(machine -> machine.onMachinePlaced(player, pStack));
        }
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        RotationState rotationState = this.getRotationState();
        Player player = context.m_43723_();
        BlockPos blockPos = context.m_8083_();
        BlockState state = this.getDefinition().blockProperties().canBeWaterlogged() ? (BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_)) : this.m_49966_();
        return player == null ? state : rotationState.property.map(property -> {
            Vec3 pos = player.m_20182_();
            if (Math.abs(pos.f_82479_ - (double)((float)blockPos.m_123341_() + 0.5f)) < 2.0 && Math.abs(pos.f_82481_ - (double)((float)blockPos.m_123343_() + 0.5f)) < 2.0) {
                double d0 = pos.f_82480_ + (double)player.m_20192_();
                if (d0 - (double)blockPos.m_123342_() > 2.0 && rotationState.test(Direction.UP)) {
                    return (BlockState)state.m_61124_((Property)property, (Comparable)Direction.UP);
                }
                if ((double)blockPos.m_123342_() - d0 > 0.0 && rotationState.test(Direction.DOWN)) {
                    return (BlockState)state.m_61124_((Property)property, (Comparable)Direction.DOWN);
                }
            }
            if (rotationState == RotationState.Y_AXIS) {
                return (BlockState)state.m_61124_((Property)property, (Comparable)Direction.UP);
            }
            return (BlockState)state.m_61124_((Property)property, (Comparable)player.m_6350_().m_122424_());
        }).orElse(state);
    }

    public boolean m_6044_(BlockGetter pLevel, BlockPos pPos, BlockState pState, Fluid pFluid) {
        if (this.getDefinition().blockProperties().canBeWaterlogged()) {
            return super.m_6044_(pLevel, pPos, pState, pFluid);
        }
        return false;
    }

    public boolean m_7361_(LevelAccessor levelAccessor, BlockPos blockPos, BlockState blockState, FluidState fluidState) {
        if (this.getDefinition().blockProperties().canBeWaterlogged()) {
            return super.m_7361_(levelAccessor, blockPos, blockState, fluidState);
        }
        return false;
    }

    public ItemStack m_142598_(LevelAccessor levelAccessor, BlockPos blockPos, BlockState blockState) {
        if (this.getDefinition().blockProperties().canBeWaterlogged()) {
            return super.m_142598_(levelAccessor, blockPos, blockState);
        }
        return ItemStack.f_41583_;
    }

    public Optional<SoundEvent> m_142298_() {
        if (this.getDefinition().blockProperties().canBeWaterlogged()) {
            return super.m_142298_();
        }
        return Optional.empty();
    }

    public FluidState m_5888_(BlockState state) {
        return state.m_61145_((Property)BlockStateProperties.f_61362_).orElse(false) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    @Deprecated
    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos pos, BlockPos facingPos) {
        if (state.m_61145_((Property)BlockStateProperties.f_61362_).orElse(false).booleanValue()) {
            world.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        return state;
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        this.definition.appendHoverText(stack, tooltip);
    }

    public boolean m_8133_(BlockState pState, Level pLevel, BlockPos pPos, int pId, int pParam) {
        BlockEntity tile = pLevel.m_7702_(pPos);
        if (tile != null) {
            return tile.m_7531_(pId, pParam);
        }
        return false;
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return this.rotationState.property.map(property -> (BlockState)state.m_61124_((Property)property, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)property)))).orElse(state);
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        LootParams context = builder.m_287286_(LootContextParams.f_81461_, (Object)state).m_287235_(LootContextParamSets.f_81421_);
        Entity entity = (Entity)context.m_287267_(LootContextParams.f_81455_);
        BlockEntity tileEntity = (BlockEntity)context.m_287267_(LootContextParams.f_81462_);
        List drops = super.m_49635_(state, builder);
        IMachine.ofMachine(tileEntity).filter(MBDMachine.class::isInstance).map(MBDMachine.class::cast).ifPresent(machine -> machine.onDrops(entity, drops));
        return drops;
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        if (pState.m_155947_()) {
            if (!pState.m_60713_(pNewState.m_60734_())) {
                this.getMachine((BlockGetter)pLevel, pPos).ifPresent(MBDMachine::onMachineRemoved);
                pLevel.m_46717_(pPos, (Block)this);
                pLevel.m_46747_(pPos);
            } else if (this.rotationState.property.isPresent()) {
                Direction oldFacing = (Direction)pState.m_61143_((Property)this.rotationState.property.get());
                Direction newFacing = (Direction)pNewState.m_61143_((Property)this.rotationState.property.get());
                if (newFacing != oldFacing) {
                    this.getMachine((BlockGetter)pLevel, pPos).ifPresent(machine -> machine.onRotated(oldFacing, newFacing));
                }
            }
        }
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        return this.getMachine(level, pos).map(machine -> machine.getMachineState().getLightLevel()).orElse(0);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        MBDMachine machine = this.getMachine((BlockGetter)world, pos).orElse(null);
        if (machine == null) {
            return InteractionResult.PASS;
        }
        InteractionResult result = machine.onUse(state, world, pos, player, hand, hit);
        if (result != InteractionResult.PASS) {
            return result;
        }
        if (machine.shouldOpenUI(hand, hit)) {
            return machine.openUI(player);
        }
        return InteractionResult.PASS;
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter level, BlockPos pos, @Nullable Direction direction) {
        MBDMachine machine = this.getMachine(level, pos).orElse(null);
        if (machine == null || direction == null) {
            return super.canConnectRedstone(state, level, pos, direction);
        }
        return machine.canConnectRedstone(direction);
    }

    public int m_6378_(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        MBDMachine machine = this.getMachine(level, pos).orElse(null);
        if (machine == null) {
            return super.m_6378_(state, level, pos, direction);
        }
        return machine.getOutputSignal(direction.m_122424_());
    }

    public int m_6376_(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        MBDMachine machine = this.getMachine(level, pos).orElse(null);
        if (machine == null) {
            return super.m_6376_(state, level, pos, direction);
        }
        return machine.getOutputDirectSignal(direction);
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        MBDMachine machine = this.getMachine((BlockGetter)level, pos).orElse(null);
        if (machine == null) {
            return super.m_6782_(state, level, pos);
        }
        return machine.getAnalogOutputSignal();
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        super.m_6861_(state, level, pos, block, fromPos, isMoving);
        this.getMachine((BlockGetter)level, pos).ifPresent(machine -> machine.onNeighborChanged(block, fromPos, isMoving));
    }

    public BlockState getAppearance(BlockState state, BlockAndTintGetter level, BlockPos pos, Direction side, @Nullable BlockState queryState, @Nullable BlockPos queryPos) {
        return this.getMachine((BlockGetter)level, pos).map(machine -> machine.getAppearance(state, side, queryState, queryPos)).orElse(state);
    }

    public boolean m_7420_(BlockState state, BlockGetter level, BlockPos pos) {
        return this.getDefinition().blockProperties().transparent() || state.m_61145_((Property)BlockStateProperties.f_61362_).orElse(false) == false;
    }

    @Deprecated
    public VoxelShape m_5909_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return this.getDefinition().blockProperties().transparent() ? Shapes.m_83040_() : super.m_5909_(state, level, pos, ctx);
    }

    @Deprecated
    public float m_7749_(BlockState state, BlockGetter level, BlockPos pos) {
        return this.getDefinition().blockProperties().transparent() ? 1.0f : super.m_7749_(state, level, pos);
    }

    @Deprecated
    public boolean m_6104_(BlockState state, BlockState state2, Direction direction) {
        return this.getDefinition().blockProperties().transparent() ? state2.m_60713_((Block)this) || super.m_6104_(state, state2, direction) : super.m_6104_(state, state2, direction);
    }

    public int getLightMap(BlockAndTintGetter world, BlockState state, BlockPos pos) {
        int k;
        if (state.m_60788_((BlockGetter)world, pos)) {
            return 0xF000F0;
        }
        int i = world.m_45517_(LightLayer.SKY, pos);
        int j = world.m_45517_(LightLayer.BLOCK, pos);
        if (j < (k = state.getLightEmission((BlockGetter)world, pos))) {
            j = k;
        }
        return i << 20 | j << 4;
    }

    public MBDMachineDefinition getDefinition() {
        return this.definition;
    }

    public RotationState getRotationState() {
        return this.rotationState;
    }
}

