/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common.capability.recipe;

import com.lowdragmc.lowdraglib.gui.editor.accessors.CompoundTagAccessor;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ArrayConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.configurator.Configurator;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorSelectorConfigurator;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ItemConfigurator;
import com.lowdragmc.lowdraglib.gui.editor.configurator.NumberConfigurator;
import com.lowdragmc.lowdraglib.gui.editor.configurator.SearchComponentConfigurator;
import com.lowdragmc.lowdraglib.gui.editor.configurator.WrapperConfigurator;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.SlotWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.jei.IngredientIO;
import com.lowdragmc.lowdraglib.misc.ItemStackTransfer;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import com.lowdragmc.lowdraglib.utils.CycleItemStackHandler;
import com.lowdragmc.lowdraglib.utils.TagOrCycleItemStackTransfer;
import com.lowdragmc.mbd2.api.capability.recipe.RecipeCapability;
import com.lowdragmc.mbd2.api.recipe.content.Content;
import com.lowdragmc.mbd2.api.recipe.content.SerializerIngredient;
import com.lowdragmc.mbd2.api.recipe.ingredient.SizedIngredient;
import com.lowdragmc.mbd2.core.mixins.IngredientAccessor;
import com.lowdragmc.mbd2.core.mixins.ItemValueAccessor;
import com.lowdragmc.mbd2.core.mixins.StrictNBTIngredientAccessor;
import com.lowdragmc.mbd2.core.mixins.TagValueAccessor;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.StrictNBTIngredient;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITag;
import net.minecraftforge.registries.tags.ITagManager;

public class ItemRecipeCapability
extends RecipeCapability<Ingredient> {
    public static final String VANILLA_TYPE = "recipe.capability.item.ingredient.type.vanilla";
    public static final String NBT_TYPE = "recipe.capability.item.ingredient.type.nbt";
    public static final String ITEM_TYPE = "recipe.capability.item.ingredient.values.item";
    public static final String TAG_TYPE = "recipe.capability.item.ingredient.values.tag";
    public static final ItemRecipeCapability CAP = new ItemRecipeCapability();

    protected ItemRecipeCapability() {
        super("item", SerializerIngredient.INSTANCE);
    }

    @Override
    public Ingredient createDefaultContent() {
        return SizedIngredient.create(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42416_}));
    }

    @Override
    public Widget createPreviewWidget(Ingredient content) {
        CycleItemStackHandler transfer = new CycleItemStackHandler(List.of(List.of(content.m_43908_())));
        return new SlotWidget((IItemTransfer)transfer, 0, 0, 0, false, false).setDrawHoverOverlay(false).setBackgroundTexture(null);
    }

    @Override
    public Widget createXEITemplate() {
        SlotWidget slotWidget = new SlotWidget();
        slotWidget.initTemplate();
        return slotWidget;
    }

    @Override
    public void bindXEIWidget(Widget widget, Content content, IngredientIO ingredientIO) {
        if (widget instanceof SlotWidget) {
            int amount;
            Ingredient ingredient;
            SlotWidget slotWidget = (SlotWidget)widget;
            Ingredient innerIngredient = ingredient = (Ingredient)this.of(content.content);
            if (ingredient instanceof SizedIngredient) {
                SizedIngredient sizedIngredient = (SizedIngredient)ingredient;
                amount = sizedIngredient.getAmount();
                innerIngredient = sizedIngredient.getInner();
            } else {
                amount = 1;
            }
            Either either = null;
            if (innerIngredient.isVanilla() && innerIngredient instanceof IngredientAccessor) {
                IngredientAccessor vanillaIngredient = (IngredientAccessor)innerIngredient;
                if (Arrays.stream(vanillaIngredient.getValues()).allMatch(Ingredient.TagValue.class::isInstance)) {
                    either = Either.left(Arrays.stream(vanillaIngredient.getValues()).map(Ingredient.TagValue.class::cast).map(TagValueAccessor.class::cast).map(TagValueAccessor::getTag).map(tagValue -> new Pair(tagValue, (Object)amount)).toList());
                }
            }
            if (either == null) {
                either = Either.right(List.of(ingredient.m_43908_()));
            }
            if (slotWidget.getOverlay() == null || slotWidget.getOverlay() == IGuiTexture.EMPTY) {
                slotWidget.setOverlay(content.createOverlay());
            } else {
                GuiTextureGroup groupTexture = new GuiTextureGroup(new IGuiTexture[]{slotWidget.getOverlay(), content.createOverlay()});
                slotWidget.setOverlay((IGuiTexture)groupTexture);
            }
            slotWidget.setHandlerSlot((IItemTransfer)new TagOrCycleItemStackTransfer(List.of(either)), 0);
            slotWidget.setIngredientIO(ingredientIO);
            slotWidget.setCanTakeItems(false);
            slotWidget.setCanPutItems(false);
            slotWidget.setXEIChance(content.chance);
        }
    }

    @Override
    public void createContentConfigurator(ConfiguratorGroup father, Supplier<Ingredient> supplier, Consumer<Ingredient> onUpdate) {
        father.addConfigurators(new Configurator[]{new NumberConfigurator("recipe.capability.item.ingredient.count", () -> {
            Integer n;
            Object patt5647$temp = supplier.get();
            if (patt5647$temp instanceof SizedIngredient) {
                SizedIngredient sizedIngredient = (SizedIngredient)((Object)((Object)patt5647$temp));
                n = sizedIngredient.getAmount();
            } else {
                n = 1;
            }
            return n;
        }, number -> {
            int amount = number.intValue();
            Ingredient ingredient = (Ingredient)supplier.get();
            if (ingredient instanceof SizedIngredient) {
                SizedIngredient sizedIngredient = (SizedIngredient)ingredient;
                onUpdate.accept(SizedIngredient.create(sizedIngredient.getInner(), amount));
            } else {
                onUpdate.accept(SizedIngredient.create(ingredient, amount));
            }
        }, (Number)1, true).setRange((Number)1, (Number)Integer.MAX_VALUE)});
        father.addConfigurators(new Configurator[]{new ConfiguratorSelectorConfigurator("recipe.capability.item.ingredient.type", false, () -> {
            Ingredient ingredient = (Ingredient)supplier.get();
            if (ingredient instanceof SizedIngredient) {
                SizedIngredient sizedIngredient = (SizedIngredient)ingredient;
                return sizedIngredient.getInner();
            }
            return Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42416_});
        }, ingredient -> {
            Ingredient current = (Ingredient)supplier.get();
            if (current instanceof SizedIngredient) {
                SizedIngredient sizedIngredient = (SizedIngredient)current;
                sizedIngredient.updateInnerIngredient((Ingredient)ingredient);
            } else {
                onUpdate.accept(SizedIngredient.create(ingredient, 1));
            }
        }, (Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42416_}), true, List.of(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42416_}), StrictNBTIngredient.of((ItemStack)PotionUtils.m_43549_((ItemStack)Items.f_42589_.m_7968_(), (Potion)Potions.f_43610_))), ingredient -> {
            if (ingredient.isVanilla() && ingredient instanceof IngredientAccessor) {
                return VANILLA_TYPE;
            }
            if (ingredient instanceof StrictNBTIngredient) {
                return NBT_TYPE;
            }
            return VANILLA_TYPE;
        }, (ingredient, group) -> {
            if (ingredient.isVanilla() && ingredient instanceof IngredientAccessor) {
                IngredientAccessor vanillaIngredient = (IngredientAccessor)ingredient;
                ArrayConfiguratorGroup valuesGroup = new ArrayConfiguratorGroup("recipe.capability.item.ingredient.candidates", false, () -> {
                    Ingredient.Value[] values = vanillaIngredient.getValues();
                    return Arrays.stream(values).collect(Collectors.toList());
                }, (getter, setter) -> new ConfiguratorSelectorConfigurator("recipe.capability.item.ingredient.values.type", false, getter, setter, (Object)new Ingredient.ItemValue(Items.f_42416_.m_7968_()), true, List.of(new Ingredient.ItemValue(Items.f_42416_.m_7968_()), new Ingredient.TagValue(ItemTags.f_13160_)), value -> {
                    if (value instanceof Ingredient.ItemValue) {
                        return ITEM_TYPE;
                    }
                    if (value instanceof Ingredient.TagValue) {
                        return TAG_TYPE;
                    }
                    return ITEM_TYPE;
                }, (value, valueGroup) -> {
                    CycleItemStackHandler itemHandler = new CycleItemStackHandler(List.of(value.m_6223_().stream().toList()));
                    SlotWidget slot = new SlotWidget((IItemTransfer)itemHandler, 0, 0, 0, false, false);
                    slot.setClientSideWidget();
                    if (value instanceof ItemValueAccessor) {
                        ItemValueAccessor itemValue = (ItemValueAccessor)value;
                        valueGroup.addConfigurators(new Configurator[]{new ItemConfigurator(ITEM_TYPE, () -> itemValue.getItem().m_41720_(), item -> {
                            itemValue.setItem(item.m_7968_());
                            itemHandler.updateStacks(List.of(value.m_6223_().stream().toList()));
                            setter.accept(value);
                        }, Items.f_42416_, true)});
                    } else if (value instanceof TagValueAccessor) {
                        TagValueAccessor tagValue = (TagValueAccessor)value;
                        valueGroup.addConfigurators(new Configurator[]{new SearchComponentConfigurator(TAG_TYPE, () -> tagValue.getTag().f_203868_(), tagKey -> {
                            tagValue.setTag((TagKey<Item>)ItemTags.create((ResourceLocation)tagKey));
                            itemHandler.updateStacks(List.of(value.m_6223_().stream().toList()));
                            setter.accept(value);
                        }, (Object)ItemTags.f_13160_.f_203868_(), true, (word, find) -> {
                            ITagManager tags = ForgeRegistries.ITEMS.tags();
                            if (tags == null) {
                                return;
                            }
                            for (ITag tag : tags) {
                                if (Thread.currentThread().isInterrupted()) {
                                    return;
                                }
                                ResourceLocation tagKey = tag.getKey().f_203868_();
                                if (!tagKey.toString().toLowerCase().contains(word.toLowerCase())) continue;
                                find.accept(tagKey);
                            }
                        }, ResourceLocation::toString)});
                    }
                    valueGroup.addConfigurators(new Configurator[]{new WrapperConfigurator("ldlib.gui.editor.group.preview", (Widget)slot)});
                }), true);
                valuesGroup.setAddDefault(() -> new Ingredient.ItemValue(Items.f_42416_.m_7968_()));
                valuesGroup.setOnAdd(arg_0 -> ItemRecipeCapability.lambda$createContentConfigurator$16(vanillaIngredient, (Supplier)supplier, ingredient, arg_0));
                valuesGroup.setOnRemove(arg_0 -> ItemRecipeCapability.lambda$createContentConfigurator$19(vanillaIngredient, (Supplier)supplier, ingredient, arg_0));
                valuesGroup.setOnUpdate(arg_0 -> ItemRecipeCapability.lambda$createContentConfigurator$21(vanillaIngredient, (Supplier)supplier, ingredient, arg_0));
                group.addConfigurators(new Configurator[]{valuesGroup});
            } else if (ingredient instanceof StrictNBTIngredientAccessor) {
                StrictNBTIngredientAccessor accessor = (StrictNBTIngredientAccessor)ingredient;
                ItemStackTransfer itemHandler = new ItemStackTransfer(accessor.getStack());
                SlotWidget slot = new SlotWidget((IItemTransfer)itemHandler, 0, 0, 0, false, false);
                slot.setClientSideWidget();
                Consumer<ItemStack> updateStack = arg_0 -> ItemRecipeCapability.lambda$createContentConfigurator$22(accessor, itemHandler, (Supplier)supplier, ingredient, arg_0);
                group.addConfigurators(new Configurator[]{new ItemConfigurator("id", () -> accessor.getStack().m_41720_(), item -> {
                    ItemStack last = accessor.getStack();
                    CompoundTag tag = last.m_41783_();
                    int count = last.m_41613_();
                    ItemStack newStack = new ItemStack((ItemLike)item, Math.max(count, 1));
                    newStack.m_41751_(tag);
                    updateStack.accept(newStack);
                }, Items.f_41852_, true)});
                try {
                    group.addConfigurators(new Configurator[]{new CompoundTagAccessor().create("ldlib.gui.editor.configurator.nbt", () -> accessor.getStack().m_41782_() ? accessor.getStack().m_41783_() : new CompoundTag(), tag -> {
                        ItemStack last = accessor.getStack();
                        Item item = last.m_41720_();
                        int count = last.m_41613_();
                        ItemStack newStack = new ItemStack((ItemLike)item, Math.max(count, 1));
                        if (tag.m_128456_()) {
                            newStack.m_41751_(null);
                        } else {
                            newStack.m_41751_(tag);
                        }
                        updateStack.accept(newStack);
                    }, false, RecipeCapability.class.getField("name"))});
                }
                catch (Exception exception) {
                    // empty catch block
                }
                group.addConfigurators(new Configurator[]{new WrapperConfigurator("ldlib.gui.editor.group.preview", (Widget)slot)});
            }
        })});
    }

    @Override
    public Component getLeftErrorInfo(List<Ingredient> left) {
        MutableComponent result = Component.m_237119_();
        for (int i = 0; i < left.size(); ++i) {
            Ingredient ingredient = left.get(i);
            int amount = 1;
            if (ingredient instanceof SizedIngredient) {
                SizedIngredient sizedIngredient = (SizedIngredient)ingredient;
                amount = sizedIngredient.getAmount();
                ingredient = sizedIngredient.getInner();
            }
            result.m_130946_(amount + "x ");
            ItemStack[] stacks = ingredient.m_43908_();
            if (stacks.length > 0) {
                result.m_7220_(stacks[0].m_41611_());
            } else {
                result.m_130946_("Unknown");
            }
            if (ingredient instanceof StrictNBTIngredient) {
                result.m_130946_(" with NBT");
            }
            if (i >= left.size() - 1) continue;
            result.m_130946_(", ");
        }
        return result;
    }

    private static /* synthetic */ void lambda$createContentConfigurator$22(StrictNBTIngredientAccessor accessor, ItemStackTransfer itemHandler, Supplier supplier, Ingredient ingredient, ItemStack stack) {
        accessor.setStack(stack);
        itemHandler.setStackInSlot(0, stack);
        ((IngredientAccessor)((Object)accessor)).setItemStacks(null);
        Object patt13688$temp = supplier.get();
        if (patt13688$temp instanceof SizedIngredient) {
            SizedIngredient sizedIngredient = (SizedIngredient)((Object)patt13688$temp);
            sizedIngredient.updateInnerIngredient(ingredient);
        }
    }

    private static /* synthetic */ void lambda$createContentConfigurator$21(IngredientAccessor vanillaIngredient, Supplier supplier, Ingredient ingredient, List values) {
        vanillaIngredient.setValues((Ingredient.Value[])values.toArray(Ingredient.Value[]::new));
        vanillaIngredient.setItemStacks(null);
        Object patt12876$temp = supplier.get();
        if (patt12876$temp instanceof SizedIngredient) {
            SizedIngredient sizedIngredient = (SizedIngredient)((Object)patt12876$temp);
            sizedIngredient.updateInnerIngredient(ingredient);
        }
    }

    private static /* synthetic */ void lambda$createContentConfigurator$19(IngredientAccessor vanillaIngredient, Supplier supplier, Ingredient ingredient, Ingredient.Value value) {
        Ingredient.Value[] values = vanillaIngredient.getValues();
        Ingredient.Value[] newValues = (Ingredient.Value[])Arrays.stream(values).filter(v -> v != value).toArray(Ingredient.Value[]::new);
        vanillaIngredient.setValues(newValues);
        vanillaIngredient.setItemStacks(null);
        Object patt12473$temp = supplier.get();
        if (patt12473$temp instanceof SizedIngredient) {
            SizedIngredient sizedIngredient = (SizedIngredient)((Object)patt12473$temp);
            sizedIngredient.updateInnerIngredient(ingredient);
        }
    }

    private static /* synthetic */ void lambda$createContentConfigurator$16(IngredientAccessor vanillaIngredient, Supplier supplier, Ingredient ingredient, Ingredient.Value value) {
        Ingredient.Value[] values = vanillaIngredient.getValues();
        Ingredient.Value[] newValues = Arrays.copyOf(values, values.length + 1);
        newValues[values.length] = value;
        vanillaIngredient.setValues(newValues);
        vanillaIngredient.setItemStacks(null);
        Object patt11921$temp = supplier.get();
        if (patt11921$temp instanceof SizedIngredient) {
            SizedIngredient sizedIngredient = (SizedIngredient)((Object)patt11921$temp);
            sizedIngredient.updateInnerIngredient(ingredient);
        }
    }
}

