/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common.data;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.runtime.AnnotationDetector;
import com.lowdragmc.mbd2.MBD2;
import com.lowdragmc.mbd2.api.registry.MBDRegistries;
import com.lowdragmc.mbd2.common.event.MBDRegistryEvent;
import com.lowdragmc.mbd2.common.trait.TraitDefinition;
import com.lowdragmc.mbd2.common.trait.entity.EntityHandlerTraitDefinition;
import com.lowdragmc.mbd2.common.trait.fluid.FluidTankCapabilityTraitDefinition;
import com.lowdragmc.mbd2.common.trait.forgeenergy.ForgeEnergyCapabilityTraitDefinition;
import com.lowdragmc.mbd2.common.trait.item.ItemSlotCapabilityTraitDefinition;
import com.lowdragmc.mbd2.integration.botania.trait.BotaniaManaCapabilityTraitDefinition;
import com.lowdragmc.mbd2.integration.embers.trait.EmbersEmberCapabilityTraitDefinition;
import com.lowdragmc.mbd2.integration.gtm.trait.GTMEnergyCapabilityTraitDefinition;
import com.lowdragmc.mbd2.integration.mekanism.trait.chemical.ChemicalTankCapabilityTraitDefinition;
import com.lowdragmc.mbd2.integration.mekanism.trait.heat.MekHeatCapabilityTraitDefinition;
import com.lowdragmc.mbd2.integration.naturesaura.trait.AuraHandlerTraitDefinition;
import com.lowdragmc.mbd2.integration.pneumaticcraft.trait.heat.PNCHeatExchangerTraitDefinition;
import com.lowdragmc.mbd2.integration.pneumaticcraft.trait.pressure.PNCPressureAirHandlerTraitDefinition;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModLoader;

public class MBDTraitDefinitionTypes {
    public static void init() {
        MBDRegistries.TRAIT_DEFINITION_TYPES.unfreeze();
        MBDTraitDefinitionTypes.register(ItemSlotCapabilityTraitDefinition.class);
        MBDTraitDefinitionTypes.register(FluidTankCapabilityTraitDefinition.class);
        MBDTraitDefinitionTypes.register(ForgeEnergyCapabilityTraitDefinition.class);
        MBDTraitDefinitionTypes.register(EntityHandlerTraitDefinition.class);
        if (MBD2.isBotaniaLoaded()) {
            MBDTraitDefinitionTypes.register(BotaniaManaCapabilityTraitDefinition.class);
        }
        if (MBD2.isGTMLoaded()) {
            MBDTraitDefinitionTypes.register(GTMEnergyCapabilityTraitDefinition.class);
        }
        if (MBD2.isMekanismLoaded()) {
            MBDTraitDefinitionTypes.register(ChemicalTankCapabilityTraitDefinition.Gas.class);
            MBDTraitDefinitionTypes.register(ChemicalTankCapabilityTraitDefinition.Infuse.class);
            MBDTraitDefinitionTypes.register(ChemicalTankCapabilityTraitDefinition.Pigment.class);
            MBDTraitDefinitionTypes.register(ChemicalTankCapabilityTraitDefinition.Slurry.class);
            MBDTraitDefinitionTypes.register(MekHeatCapabilityTraitDefinition.class);
        }
        if (MBD2.isNaturesAuraLoaded()) {
            MBDTraitDefinitionTypes.register(AuraHandlerTraitDefinition.class);
        }
        if (MBD2.isPneumaticCraftLoaded()) {
            MBDTraitDefinitionTypes.register(PNCPressureAirHandlerTraitDefinition.class);
            MBDTraitDefinitionTypes.register(PNCHeatExchangerTraitDefinition.class);
        }
        if (MBD2.isEmbersLoaded()) {
            MBDTraitDefinitionTypes.register(EmbersEmberCapabilityTraitDefinition.class);
        }
        ModLoader.get().postEvent((Event)new MBDRegistryEvent.TraitType());
        MBDRegistries.TRAIT_DEFINITION_TYPES.freeze();
    }

    public static void register(Class<? extends TraitDefinition> clazz) {
        if (clazz.isAnnotationPresent(LDLRegister.class)) {
            LDLRegister annotation = clazz.getAnnotation(LDLRegister.class);
            if (!annotation.modID().isEmpty() && !LDLib.isModLoaded((String)annotation.modID())) {
                MBD2.LOGGER.info("Skipping registration of trait definition: " + clazz.getName() + " - Mod not loaded: " + annotation.modID());
                return;
            }
            try {
                Constructor<? extends TraitDefinition> constructor = clazz.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                MBDRegistries.TRAIT_DEFINITION_TYPES.register(clazz.getAnnotation(LDLRegister.class).name(), new AnnotationDetector.Wrapper((Annotation)annotation, clazz, () -> {
                    try {
                        return (TraitDefinition)constructor.newInstance(new Object[0]);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }));
            }
            catch (NoSuchMethodException e) {
                MBD2.LOGGER.error("Failed to register trait definition: " + clazz.getName() + " - No default constructor found");
            }
        } else {
            MBD2.LOGGER.error("Failed to register trait definition: " + clazz.getName() + " - No annotation found");
        }
    }
}

