/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common.graphprocessor.node;

import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberRange;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.runtime.ConfiguratorParser;
import com.lowdragmc.lowdraglib.gui.graphprocessor.annotation.InputPort;
import com.lowdragmc.lowdraglib.gui.graphprocessor.annotation.OutputPort;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.BaseNode;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.NodePort;
import com.lowdragmc.mbd2.api.recipe.content.ContentModifier;
import java.lang.reflect.Field;
import java.util.HashMap;

@LDLRegister(name="recipe modifier", group="graph_processor.node.mbd2.machine.recipe")
public class RecipeModifierNode
extends BaseNode {
    @InputPort
    public Float multiplier;
    @InputPort
    public Float addition;
    @OutputPort
    public ContentModifier modifier;
    @Configurable(name="multiplier")
    @NumberRange(range={0.0, 3.4028234663852886E38})
    public float internalMul = 1.0f;
    @Configurable(name="addition")
    @NumberRange(range={-3.4028234663852886E38, 3.4028234663852886E38})
    public float internalAdd = 0.0f;

    protected void process() {
        float mul = this.multiplier == null ? this.internalMul : this.multiplier.floatValue();
        float add = this.addition == null ? this.internalAdd : this.addition.floatValue();
        this.modifier = ContentModifier.of(mul, add);
    }

    public void buildConfigurator(ConfiguratorGroup father) {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        for (NodePort port : this.getInputPorts()) {
            if (port.fieldName.equals("multiplier")) {
                if (!port.getEdges().isEmpty()) continue;
                try {
                    ConfiguratorParser.createFieldConfigurator((Field)clazz.getField("internalMul"), (ConfiguratorGroup)father, clazz, new HashMap(), (Object)((Object)this));
                    continue;
                }
                catch (NoSuchFieldException e) {
                    throw new RuntimeException(e);
                }
            }
            if (!port.fieldName.equals("addition") || !port.getEdges().isEmpty()) continue;
            try {
                ConfiguratorParser.createFieldConfigurator((Field)clazz.getField("internalAdd"), (ConfiguratorGroup)father, clazz, new HashMap(), (Object)((Object)this));
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

