/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common.gui.editor.machine;

import com.lowdragmc.lowdraglib.gui.animation.Transform;
import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurable;
import com.lowdragmc.lowdraglib.gui.editor.data.IProject;
import com.lowdragmc.lowdraglib.gui.util.DrawerHelper;
import com.lowdragmc.lowdraglib.gui.widget.DraggableScrollableWidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import com.lowdragmc.mbd2.common.gui.editor.MachineEditor;
import com.lowdragmc.mbd2.common.gui.editor.MachineProject;
import com.lowdragmc.mbd2.common.gui.editor.machine.MachineScenePanel;
import com.lowdragmc.mbd2.common.gui.editor.machine.widget.MachineStatePreview;
import com.lowdragmc.mbd2.common.machine.definition.MBDMachineDefinition;
import com.lowdragmc.mbd2.common.machine.definition.config.MachineState;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import org.jetbrains.annotations.NotNull;

public class MachineConfigPanel
extends MachineScenePanel {
    protected final FloatView floatView;

    public MachineConfigPanel(MachineEditor editor) {
        super(editor);
        this.setDrawShapeFrameLines(true);
        this.setDrawRenderingBoxFrameLines(true);
        this.floatView = new FloatView();
        this.addWidget((Widget)this.floatView);
        this.floatView.setDraggable(true);
        this.loadMachineState();
    }

    public void onPanelSelected() {
        IProject iProject = this.editor.getCurrentProject();
        if (iProject instanceof MachineProject) {
            MachineProject project = (MachineProject)iProject;
            this.editor.getConfigPanel().openConfigurator(MachineEditor.BASIC, (IConfigurable)project.getDefinition());
        }
    }

    public void loadMachineState() {
        IProject iProject = this.editor.getCurrentProject();
        if (iProject instanceof MachineProject) {
            MachineProject project = (MachineProject)iProject;
            MBDMachineDefinition definition = project.getDefinition();
            this.loadMachineStateRecursive((MachineState)definition.stateMachine().getRootState(), (List<Integer>)new ArrayList<Integer>(), 0);
        }
    }

    private void loadMachineStateRecursive(MachineState state, List<Integer> depthCount, int depth) {
        if (depthCount.size() <= depth) {
            depthCount.add(0);
        }
        Integer count = depthCount.get(depth);
        depthCount.set(depth, count + 1);
        MachineStatePreview preview = new MachineStatePreview(this, state);
        preview.setSelfPosition(new Position(50 + count * 200, 50 + depth * 120));
        preview.collapse();
        this.floatView.addWidget((Widget)preview);
        for (MachineState child : state.children()) {
            this.loadMachineStateRecursive(child, depthCount, depth + 1);
        }
    }

    public void onStateAdded(MachineState newState) {
        MachineStatePreview preview = new MachineStatePreview(this, newState);
        preview.setSelfPosition(new Position((this.getSize().width - preview.getSize().width) / 2, (this.getSize().height - preview.getSize().height) / 2));
        this.floatView.addWidgetAnima((Widget)preview, new Transform().duration(200L).scale(0.2f));
    }

    public void onStateRemoved(MachineState state) {
        for (Widget widget : this.floatView.widgets) {
            MachineStatePreview preview;
            if (!(widget instanceof MachineStatePreview) || (preview = (MachineStatePreview)widget).getState() != state) continue;
            this.floatView.removeWidgetAnima((Widget)preview, new Transform().duration(200L).scale(0.2f));
            break;
        }
        state.children().forEach(this::onStateRemoved);
        this.editor.getConfigPanel().clearAllConfigurators(MachineEditor.SECOND);
        if (this.previewMachine != null) {
            this.previewMachine.setMachineState("base");
        }
    }

    public void onStateSelected(MachineState state) {
        this.editor.getConfigPanel().openConfigurator(MachineEditor.SECOND, (IConfigurable)state);
        if (this.previewMachine != null) {
            this.previewMachine.setMachineState(state.name());
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.buttonGroup.isMouseOverElement(mouseX, mouseY)) {
            this.buttonGroup.mouseClicked(mouseX, mouseY, button);
        }
        if (this.getHoverElement(mouseX, mouseY) == this.floatView) {
            this.scene.mouseClicked(mouseX, mouseY, button);
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.scene.mouseReleased(mouseX, mouseY, button);
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        this.scene.mouseDragged(mouseX, mouseY, button, dragX, dragY);
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean mouseWheelMove(double mouseX, double mouseY, double wheelDelta) {
        if (this.getHoverElement(mouseX, mouseY) == this.floatView) {
            this.scene.mouseWheelMove(mouseX, mouseY, wheelDelta);
        }
        return super.mouseWheelMove(mouseX, mouseY, wheelDelta);
    }

    public FloatView getFloatView() {
        return this.floatView;
    }

    public class FloatView
    extends DraggableScrollableWidgetGroup {
        private FloatView() {
            super(0, 0, MachineConfigPanel.super.getSize().width, MachineConfigPanel.super.getSize().height);
        }

        protected boolean hookDrawInBackground(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
            for (Widget widget : this.widgets) {
                MachineStatePreview preview;
                MachineState parent;
                if (!(widget instanceof MachineStatePreview) || (parent = (preview = (MachineStatePreview)widget).getState().parent()) == null) continue;
                this.widgets.stream().filter(w -> {
                    MachineStatePreview p;
                    return w instanceof MachineStatePreview && (p = (MachineStatePreview)((Object)w)).getState() == parent;
                }).findFirst().ifPresent(p -> {
                    Position pPos = p.getPosition().add(new Size(p.getSize().width / 2, p.getSize().height / 2));
                    Position pos = preview.getPosition().add(new Size(preview.getSize().width / 2, preview.getSize().height / 2));
                    DrawerHelper.drawRoundLine((GuiGraphics)graphics, (Position)pPos, (Position)pos, (int)1, (int)ColorPattern.GRAY.color, (int)ColorPattern.GRAY.color);
                });
            }
            return false;
        }
    }
}

