/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common.gui.editor.machine;

import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurable;
import com.lowdragmc.lowdraglib.gui.editor.data.IProject;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.BaseGraph;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.mbd2.common.graphprocessor.MachineEventGraphView;
import com.lowdragmc.mbd2.common.gui.editor.MachineEditor;
import com.lowdragmc.mbd2.common.gui.editor.MachineProject;
import javax.annotation.Nullable;

public class MachineEventsPanel
extends WidgetGroup {
    private final MachineEditor editor;
    @Nullable
    private BaseGraph currentGraph;

    public MachineEventsPanel(MachineEditor editor) {
        super(0, 32, editor.getSize().getWidth() - 252, editor.getSize().height - 16 - 16);
        this.editor = editor;
    }

    public void openEventGraphEditor(BaseGraph graph) {
        this.clearAllWidgets();
        this.currentGraph = graph;
        this.addWidget((Widget)new MachineEventGraphView(graph, 0, 0, this.getSizeWidth(), this.getSizeHeight()));
        this.editor.getResourcePanel().hide();
    }

    public void closeEventGraphEditor() {
        this.clearAllWidgets();
        this.currentGraph = null;
    }

    public void onPanelSelected() {
        IProject iProject = this.editor.getCurrentProject();
        if (iProject instanceof MachineProject) {
            MachineProject project = (MachineProject)iProject;
            this.editor.getConfigPanel().openConfigurator(MachineEditor.BASIC, (IConfigurable)project.getDefinition().machineEvents());
        }
    }

    public void onPanelDeselected() {
        this.editor.getConfigPanel().clearAllConfigurators();
    }

    @Nullable
    public BaseGraph getCurrentGraph() {
        return this.currentGraph;
    }

    public MachineEditor getEditor() {
        return this.editor;
    }
}

