/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common.gui.editor.machine.widget;

import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.Icons;
import com.lowdragmc.lowdraglib.gui.editor.data.IProject;
import com.lowdragmc.lowdraglib.gui.editor.ui.view.FloatViewWidget;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ItemStackTexture;
import com.lowdragmc.lowdraglib.gui.texture.ProgressTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceBorderTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.DraggableScrollableWidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.ProgressWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.mbd2.common.gui.editor.MachineEditor;
import com.lowdragmc.mbd2.common.gui.editor.MachineProject;
import com.lowdragmc.mbd2.common.trait.IUIProviderTrait;
import com.lowdragmc.mbd2.utils.WidgetUtils;
import java.util.function.Supplier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;

public class TraitUIFloatView
extends FloatViewWidget {
    protected final DraggableScrollableWidgetGroup traitList = new DraggableScrollableWidgetGroup(5, 5, 196, 110);

    public TraitUIFloatView() {
        super(200, 200, 206, 120, false);
        this.traitList.setYScrollBarWidth(2).setYBarStyle(null, (IGuiTexture)ColorPattern.T_WHITE.rectTexture().setRadius(1.0f).transform(-0.5f, 0.0f));
    }

    public String name() {
        return "trait_ui_view";
    }

    public String group() {
        return "editor.machine";
    }

    public IGuiTexture getIcon() {
        return new ItemStackTexture(new Item[]{Items.f_42447_, Items.f_42009_});
    }

    public IGuiTexture getHoverIcon() {
        return Icons.REMOVE;
    }

    public MachineEditor getEditor() {
        return (MachineEditor)this.editor;
    }

    public void initWidget() {
        super.initWidget();
        this.content.addWidget((Widget)this.traitList);
        this.reloadTrait();
    }

    public void reloadTrait() {
        this.traitList.clearAllWidgets();
        IProject iProject = this.getEditor().getCurrentProject();
        if (iProject instanceof MachineProject) {
            MachineProject project = (MachineProject)iProject;
            this.addButton((Widget)new ImageWidget(0, 0, 18, 18, (IGuiTexture)new ProgressTexture((IGuiTexture)new ResourceTexture("mbd2:textures/gui/arrow_bar.png").getSubTexture(0.0, 0.0, 1.0, 0.5), (IGuiTexture)new ResourceTexture("mbd2:textures/gui/arrow_bar.png").getSubTexture(0.0, 0.5, 1.0, 0.5))), () -> "editor.machine.recipe_type_ui_view.progress", () -> {
                ProgressWidget progress = new ProgressWidget(ProgressWidget.JEIProgress, 5, 5, 18, 18, new ProgressTexture((IGuiTexture)new ResourceTexture("mbd2:textures/gui/arrow_bar.png").getSubTexture(0.0, 0.0, 1.0, 0.5), (IGuiTexture)new ResourceTexture("mbd2:textures/gui/arrow_bar.png").getSubTexture(0.0, 0.5, 1.0, 0.5)));
                progress.setId("ui:progress_bar");
                project.getUi().addWidget((Widget)progress);
            }, new String[0]);
            this.addButton((Widget)new ImageWidget(0, 0, 18, 18, (IGuiTexture)new ProgressTexture()), () -> "editor.machine.recipe_type_ui_view.fuel_progress", () -> {
                if (WidgetUtils.getFirstWidgetById(project.getUi(), "^ui:fuel_bar$") == null) {
                    ProgressWidget progress = new ProgressWidget(ProgressWidget.JEIProgress, 5, 5, 18, 18, new ProgressTexture());
                    progress.setId("ui:fuel_bar");
                    project.getUi().addWidget((Widget)progress);
                }
            }, new String[0]);
            this.addButton((Widget)new ButtonWidget(0, 0, 18, 18, (IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{ResourceBorderTexture.BUTTON_COMMON, new TextTexture("XEI").scale(0.8f)}), null), () -> "editor.machine.recipe_type_ui_view.xei_lookup", () -> {
                if (WidgetUtils.getFirstWidgetById(project.getUi(), "^ui:xei_lookup$") == null) {
                    ButtonWidget button = new ButtonWidget(5, 5, 18, 18, (IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{ResourceBorderTexture.BUTTON_COMMON, new TextTexture("XEI").scale(0.8f)}), null);
                    button.setId("ui:xei_lookup");
                    button.setHoverTooltips(new String[]{"editor.machine.recipe_type_ui_view.xei_lookup.hover"});
                    project.getUi().addWidget((Widget)button);
                }
            }, new String[0]);
            project.getDefinition().machineSettings().traitDefinitions().stream().filter(IUIProviderTrait.class::isInstance).map(IUIProviderTrait.class::cast).forEach(this::addUITrait);
        }
    }

    public void addUITrait(IUIProviderTrait provider) {
        this.addButton((Widget)new ImageWidget(0, 0, 18, 18, provider.getDefinition().getIcon()), provider.getDefinition()::getName, () -> {
            IProject patt4560$temp = this.getEditor().getCurrentProject();
            if (patt4560$temp instanceof MachineProject) {
                MachineProject project = (MachineProject)patt4560$temp;
                provider.createTraitUITemplate(project.getUi());
            }
        }, "config.definition.trait.ui.generate.tooltip", "config.definition.trait.%s.ui.tooltip".formatted(provider.getDefinition().getTranslateKey()));
    }

    public void addButton(Widget icon, Supplier<String> value, Runnable onClick, String ... hoverTooltips) {
        int yOffset = 3 + this.traitList.getAllWidgetSize() * 20;
        WidgetGroup widgetGroup = new WidgetGroup(0, yOffset, 90, 18);
        icon.setSelfPosition(1, 0);
        widgetGroup.addWidget(icon);
        widgetGroup.addWidget((Widget)new ImageWidget(20, 1, 120, 18, (IGuiTexture)new TextTexture().setSupplier(value).setType(TextTexture.TextType.ROLL_ALWAYS).setWidth(120)));
        widgetGroup.addWidget(new ButtonWidget(145, 2, 45, 14, (IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{ColorPattern.T_RED.rectTexture().setRadius(7.0f), ColorPattern.WHITE.borderTexture(-1).setRadius(7.0f), new TextTexture("editor.machine.recipe_type_ui_view.add")}), cd -> onClick.run()).setHoverTexture(new IGuiTexture[]{new GuiTextureGroup(new IGuiTexture[]{ColorPattern.T_RED.rectTexture().setRadius(7.0f), ColorPattern.GREEN.borderTexture(-1).setRadius(7.0f), new TextTexture("editor.machine.recipe_type_ui_view.add")})}).setHoverTooltips(hoverTooltips));
        this.traitList.addWidget((Widget)widgetGroup);
    }
}

