/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common.gui.editor.multiblock;

import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurable;
import com.lowdragmc.lowdraglib.syncdata.ITagSerializable;
import com.lowdragmc.mbd2.common.gui.editor.PredicateResource;
import com.mojang.datafixers.util.Either;
import java.io.File;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class BlockPlaceholder
implements IConfigurable,
ITagSerializable<CompoundTag> {
    protected final PredicateResource predicateResource;
    protected Set<Either<String, File>> predicates = new LinkedHashSet<Either<String, File>>(){

        @Override
        public boolean remove(Object o) {
            return super.remove(o);
        }

        @Override
        public void clear() {
            super.clear();
        }
    };
    protected boolean isController;
    protected Direction facing = Direction.NORTH;

    protected BlockPlaceholder(PredicateResource predicateResource) {
        this.predicateResource = predicateResource;
    }

    @SafeVarargs
    public static BlockPlaceholder create(PredicateResource predicateResource, Either<String, File> ... predicates) {
        BlockPlaceholder holder = new BlockPlaceholder(predicateResource);
        holder.predicates.addAll(Arrays.asList(predicates));
        return holder;
    }

    @SafeVarargs
    public static BlockPlaceholder controller(PredicateResource predicateResource, Either<String, File> ... predicates) {
        BlockPlaceholder holder = BlockPlaceholder.create(predicateResource, predicates);
        holder.isController = true;
        return holder;
    }

    public static BlockPlaceholder fromTag(PredicateResource predicateResource, CompoundTag tag) {
        BlockPlaceholder holder = new BlockPlaceholder(predicateResource);
        holder.deserializeNBT(tag);
        return holder;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        ListTag predicatesTag = new ListTag();
        for (Either<String, File> predicate : this.predicates) {
            predicatesTag.add((Object)((Tag)predicate.map(l -> {
                CompoundTag key = new CompoundTag();
                key.m_128359_("key", l);
                key.m_128359_("type", "builtin");
                return key;
            }, r -> {
                CompoundTag key = new CompoundTag();
                key.m_128359_("key", r.getPath());
                key.m_128359_("type", "project");
                return key;
            })));
        }
        tag.m_128365_("predicates", (Tag)predicatesTag);
        tag.m_128379_("isController", this.isController);
        tag.m_128405_("facing", this.facing.m_122411_());
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.predicates.clear();
        ListTag predicatesTag = nbt.m_128437_("predicates", 8);
        if (predicatesTag.isEmpty()) {
            predicatesTag = nbt.m_128437_("predicates", 10);
            for (Tag tag : predicatesTag) {
                CompoundTag compoundTag = (CompoundTag)tag;
                String key = compoundTag.m_128461_("key");
                String type = compoundTag.m_128461_("type");
                if ("builtin".equals(type)) {
                    this.predicates.add((Either<String, File>)Either.left((Object)key));
                    continue;
                }
                if (!"project".equals(type)) continue;
                this.predicates.add((Either<String, File>)Either.right((Object)new File(key)));
            }
        } else {
            for (Tag tag : predicatesTag) {
                this.predicates.add((Either<String, File>)Either.left((Object)tag.m_7916_()));
            }
        }
        this.isController = nbt.m_128471_("isController");
        this.facing = Direction.m_122376_((int)nbt.m_128451_("facing"));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BlockPlaceholder)) {
            return false;
        }
        BlockPlaceholder other = (BlockPlaceholder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isController() != other.isController()) {
            return false;
        }
        Set<Either<String, File>> this$predicates = this.getPredicates();
        Set<Either<String, File>> other$predicates = other.getPredicates();
        if (this$predicates == null ? other$predicates != null : !((Object)this$predicates).equals(other$predicates)) {
            return false;
        }
        Direction this$facing = this.getFacing();
        Direction other$facing = other.getFacing();
        return !(this$facing == null ? other$facing != null : !this$facing.equals(other$facing));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BlockPlaceholder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isController() ? 79 : 97);
        Set<Either<String, File>> $predicates = this.getPredicates();
        result = result * 59 + ($predicates == null ? 43 : ((Object)$predicates).hashCode());
        Direction $facing = this.getFacing();
        result = result * 59 + ($facing == null ? 43 : $facing.hashCode());
        return result;
    }

    public PredicateResource getPredicateResource() {
        return this.predicateResource;
    }

    public Set<Either<String, File>> getPredicates() {
        return this.predicates;
    }

    public boolean isController() {
        return this.isController;
    }

    public BlockPlaceholder setController(boolean isController) {
        this.isController = isController;
        return this;
    }

    public Direction getFacing() {
        return this.facing;
    }

    public BlockPlaceholder setFacing(Direction facing) {
        this.facing = facing;
        return this;
    }
}

