/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common.gui.editor.multiblock;

import com.lowdragmc.lowdraglib.client.utils.RenderBufferUtils;
import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.Icons;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ArrayConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.configurator.Configurator;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurable;
import com.lowdragmc.lowdraglib.gui.editor.configurator.WrapperConfigurator;
import com.lowdragmc.lowdraglib.gui.editor.ui.Editor;
import com.lowdragmc.lowdraglib.gui.editor.ui.sceneeditor.SceneEditorWidget;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.util.TreeBuilder;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.SceneWidget;
import com.lowdragmc.lowdraglib.gui.widget.SelectorWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.utils.BlockInfo;
import com.lowdragmc.lowdraglib.utils.BlockPosFace;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import com.lowdragmc.lowdraglib.utils.TrackedDummyWorld;
import com.lowdragmc.mbd2.api.pattern.predicates.SimplePredicate;
import com.lowdragmc.mbd2.api.registry.MBDRegistries;
import com.lowdragmc.mbd2.common.blockentity.MachineBlockEntity;
import com.lowdragmc.mbd2.common.gui.editor.MachineEditor;
import com.lowdragmc.mbd2.common.gui.editor.MultiblockMachineProject;
import com.lowdragmc.mbd2.common.gui.editor.PredicateResource;
import com.lowdragmc.mbd2.common.gui.editor.multiblock.BlockPlaceholder;
import com.lowdragmc.mbd2.common.gui.editor.multiblock.widget.PatternLayerList;
import com.lowdragmc.mbd2.common.machine.MBDMultiblockMachine;
import com.lowdragmc.mbd2.common.trait.ITrait;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.datafixers.util.Either;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3i;

public class MultiblockPatternPanel
extends WidgetGroup {
    public static String COPY_TAG = "mb_predicates";
    protected final MachineEditor editor;
    protected final MultiblockMachineProject project;
    protected final TrackedDummyWorld level;
    protected final SceneEditorWidget scene;
    protected final WidgetGroup buttonGroup;
    private long lastClickTime;
    private BlockPosFace clickedPosFace;
    private boolean isSelected;
    private int visibleLayer = -1;
    private final Set<Vector3i> selectedBlocks = new HashSet<Vector3i>();

    public MultiblockPatternPanel(MachineEditor editor, MultiblockMachineProject project) {
        super(0, 32, Editor.INSTANCE.getSize().getWidth() - 252, Editor.INSTANCE.getSize().height - 16 - 16);
        this.editor = editor;
        this.project = project;
        this.scene = new SceneEditorWidget(0, 0, this.getSize().width, this.getSize().height, null);
        this.addWidget((Widget)this.scene);
        this.buttonGroup = new WidgetGroup(0, 0, this.getSize().width, this.getSize().height);
        this.addWidget((Widget)this.buttonGroup);
        this.scene.disableTransformGizmo();
        this.scene.setRenderFacing(false);
        this.scene.setRenderSelect(false);
        this.level = new TrackedDummyWorld();
        this.scene.createScene((Level)this.level);
        this.scene.setAfterWorldRender(this::renderAfterWorld);
        this.scene.useCacheBuffer();
        this.reloadScene(true, false);
        this.prepareButtonGroup();
        this.buttonGroup.setSize(new Size(Math.max(0, this.buttonGroup.widgets.size() * 25 - 5), 20));
        this.buttonGroup.setSelfPosition(new Position(this.getSize().width - this.buttonGroup.getSize().width - 25, 25));
    }

    public void onPanelSelected() {
        this.editor.getConfigPanel().clearAllConfigurators();
        this.editor.getToolPanel().clearAllWidgets();
        this.editor.getToolPanel().setTitle("editor.machine.multiblock.multiblock_pattern.layer");
        this.editor.getToolPanel().addNewToolBox("editor.machine.multiblock.multiblock_pattern.layer", Icons.WIDGET_CUSTOM, size -> new PatternLayerList(this, (Size)size));
        if (this.editor.getToolPanel().inAnimate()) {
            this.editor.getToolPanel().getAnimation().appendOnFinish(() -> this.editor.getToolPanel().show());
        } else {
            this.editor.getToolPanel().show();
        }
        this.isSelected = true;
    }

    public void onPanelDeselected() {
        this.isSelected = false;
        this.editor.getToolPanel().setTitle("ldlib.gui.editor.group.tool_box");
        this.editor.getToolPanel().hide();
        this.editor.getToolPanel().clearAllWidgets();
        this.editor.getConfigPanel().clearAllConfigurators();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void reloadScene(boolean clearSelected, boolean keepZoom) {
        BlockPlaceholder holder;
        int z;
        int y;
        this.level.clear();
        if (clearSelected) {
            this.clearSelectedBlocks();
        }
        BlockPlaceholder[][][] holders = this.project.getBlockPlaceholders();
        HashSet<BlockPos> positions = new HashSet<BlockPos>();
        Direction controllerFace = Direction.NORTH;
        int x = 0;
        while (true) {
            if (x >= holders.length) break;
            for (y = 0; y < holders[x].length; ++y) {
                for (z = 0; z < holders[x][y].length; ++z) {
                    holder = holders[x][y][z];
                    if (holder == null || !holder.isController()) continue;
                    controllerFace = holder.getFacing();
                }
            }
            ++x;
        }
        x = 0;
        block8: while (true) {
            if (x >= holders.length) {
                float previousZoom = this.scene.getZoom();
                this.scene.setRenderedCore(positions, null);
                if (keepZoom) {
                    this.scene.setZoom(previousZoom);
                }
                return;
            }
            y = 0;
            while (true) {
                if (y < holders[x].length) {
                } else {
                    ++x;
                    continue block8;
                }
                block10: for (z = 0; z < holders[x][y].length; ++z) {
                    holder = holders[x][y][z];
                    if (holder == null) continue;
                    BlockPos pos = new BlockPos(x, y, z);
                    positions.add(pos);
                    if (this.visibleLayer >= 0) {
                        switch (this.project.getLayerAxis()) {
                            case X: {
                                if (x == this.visibleLayer) break;
                                continue block10;
                            }
                            case Y: {
                                if (y == this.visibleLayer) break;
                                continue block10;
                            }
                            case Z: {
                                if (z != this.visibleLayer) continue block10;
                            }
                        }
                    }
                    if (holder.isController()) {
                        MBDRegistries.FAKE_MACHINE().blockProperties().rotationState().property.ifPresent(property -> this.level.addBlock(pos, BlockInfo.fromBlockState((BlockState)((BlockState)MBDRegistries.FAKE_MACHINE().block().m_49966_().m_61124_((Property)property, (Comparable)holder.getFacing())))));
                        Optional.ofNullable(this.level.m_7702_(pos)).ifPresent(blockEntity -> {
                            if (blockEntity instanceof MachineBlockEntity) {
                                MachineBlockEntity machineBlockEntity = (MachineBlockEntity)blockEntity;
                                MBDMultiblockMachine controllerMachine = this.project.getDefinition().createMachine(machineBlockEntity);
                                machineBlockEntity.setMachine(controllerMachine);
                                controllerMachine.loadAdditionalTraits();
                                controllerMachine.getAdditionalTraits().forEach(ITrait::onLoadingTraitInPreview);
                            }
                        });
                        continue;
                    }
                    Direction finalControllerFace = controllerFace;
                    holder.getPredicates().stream().map(arg_0 -> ((PredicateResource)holder.predicateResource).getResource(arg_0)).filter(Objects::nonNull).filter(predicate -> !predicate.controllerFront.isEnable() || predicate.controllerFront.getValue() == finalControllerFace).findAny().ifPresent(predicate -> {
                        if (predicate.candidates == null) {
                            return;
                        }
                        Optional<BlockInfo> blockInfo = Arrays.stream(predicate.candidates.get()).findAny();
                        blockInfo.ifPresent(info -> this.level.addBlock(pos, info));
                    });
                }
                ++y;
            }
            break;
        }
    }

    private void reloadPredicateConfigurator() {
        this.editor.getConfigPanel().openConfigurator(MachineEditor.BASIC, (IConfigurable)new PredicateConfigurator());
    }

    public void setVisibleLayer(int visibleLayer) {
        if (this.visibleLayer == visibleLayer) {
            return;
        }
        this.visibleLayer = visibleLayer;
        this.reloadScene(false, true);
    }

    public boolean isBlockSelected(Vector3i pos) {
        return this.selectedBlocks.contains(pos);
    }

    public void clearSelectedBlocks() {
        this.selectedBlocks.clear();
        if (this.isSelected) {
            this.editor.getConfigPanel().clearAllConfigurators(MachineEditor.BASIC);
        }
    }

    public void addSelectedBlock(Vector3i pos) {
        this.addSelectedBlock(pos, false);
        this.reloadPredicateConfigurator();
    }

    public void addSelectedBlock(Vector3i pos, boolean clear) {
        if (clear) {
            this.selectedBlocks.clear();
        }
        this.selectedBlocks.add(pos);
        this.reloadPredicateConfigurator();
    }

    public void addSelectedBlocks(Collection<Vector3i> positions, boolean clear) {
        if (clear) {
            this.selectedBlocks.clear();
        }
        this.selectedBlocks.addAll(positions);
        this.reloadPredicateConfigurator();
    }

    public void removeSelectedBlock(Vector3i pos) {
        this.selectedBlocks.remove(pos);
        if (this.selectedBlocks.isEmpty()) {
            this.editor.getConfigPanel().clearAllConfigurators(MachineEditor.BASIC);
        } else {
            this.reloadPredicateConfigurator();
        }
    }

    protected void prepareButtonGroup() {
    }

    private void renderAfterWorld(SceneWidget sceneWidget) {
        Either key;
        Object pos2;
        PoseStack poseStack = new PoseStack();
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        RenderSystem.defaultBlendFunc();
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        RenderSystem.enableCull();
        RenderSystem.setShader(GameRenderer::m_172811_);
        buffer.m_166779_(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.f_85815_);
        for (Object pos2 : this.selectedBlocks) {
            RenderBufferUtils.drawCubeFace((PoseStack)poseStack, (VertexConsumer)buffer, (float)((float)pos2.x - 0.001f), (float)((float)pos2.y - 0.001f), (float)((float)pos2.z - 0.001f), (float)((float)pos2.x + 1.001f), (float)((float)pos2.y + 1.001f), (float)((float)pos2.z + 1.001f), (float)0.1f, (float)0.7f, (float)0.1f, (float)0.5f, (boolean)false);
        }
        if (this.scene.getHoverPosFace() != null && (pos2 = this.gui.getModularUIGui().getDraggingElement()) instanceof Either && ((Boolean)(key = (Either)pos2).map(l -> {
            boolean bl;
            if (l instanceof String) {
                String s = (String)l;
                if (this.project.getPredicateResource().hasBuiltinResource(s)) {
                    bl = true;
                    return bl;
                }
            }
            bl = false;
            return bl;
        }, r -> {
            boolean bl;
            if (r instanceof File) {
                File f = (File)r;
                if (this.project.getPredicateResource().hasStaticResource(f)) {
                    bl = true;
                    return bl;
                }
            }
            bl = false;
            return bl;
        })).booleanValue()) {
            pos2 = this.scene.getHoverPosFace().pos;
            RenderBufferUtils.drawCubeFace((PoseStack)poseStack, (VertexConsumer)buffer, (float)((float)pos2.m_123341_() - 0.002f), (float)((float)pos2.m_123342_() - 0.002f), (float)((float)pos2.m_123343_() - 0.002f), (float)((float)pos2.m_123341_() + 1.002f), (float)((float)pos2.m_123342_() + 1.002f), (float)((float)pos2.m_123343_() + 1.002f), (float)0.1f, (float)0.7f, (float)0.7f, (float)0.5f, (boolean)false);
        }
        tessellator.m_85914_();
    }

    public void onBlockPlaceholdersChanged() {
        this.reloadScene(true, false);
        this.editor.getToolPanel().getToolBoxes().stream().filter(PatternLayerList.class::isInstance).map(PatternLayerList.class::cast).findAny().ifPresent(PatternLayerList::reloadLayers);
    }

    public void openMenu(double mouseX, double mouseY) {
        if (!this.selectedBlocks.isEmpty()) {
            TreeBuilder.Menu menu = TreeBuilder.Menu.start();
            menu.leaf((IGuiTexture)Icons.COPY, "ldlib.gui.editor.menu.copy", () -> {
                List<BlockPlaceholder> placeholders = this.selectedBlocks.stream().map(pos -> this.project.getBlockPlaceholders()[pos.x][pos.y][pos.z]).toList();
                ArrayList<Either<String, File>> intersection = new ArrayList<Either<String, File>>(placeholders.get(0).getPredicates());
                for (BlockPlaceholder placeholder : placeholders) {
                    intersection.retainAll(placeholder.getPredicates());
                }
                this.editor.setCopy(COPY_TAG, intersection);
            });
            if (COPY_TAG.equals(this.editor.getCopyType()) && this.editor.getCopied() instanceof List) {
                menu.leaf((IGuiTexture)Icons.PASTE, "ldlib.gui.editor.menu.paste", () -> {
                    List predicates = (List)this.editor.getCopied();
                    this.selectedBlocks.forEach(pos -> {
                        BlockPlaceholder holder = this.project.getBlockPlaceholders()[pos.x][pos.y][pos.z];
                        holder.getPredicates().clear();
                        holder.getPredicates().addAll(predicates);
                    });
                    this.reloadScene(false, true);
                    this.reloadPredicateConfigurator();
                });
            }
            if (this.selectedBlocks.size() == 1) {
                menu.crossLine();
                menu.branch("editor.machine.multiblock.multiblock_pattern.set_as_controller", m -> {
                    for (Direction facing : Direction.values()) {
                        m.leaf(facing.m_122433_(), () -> {
                            Arrays.stream(this.project.getBlockPlaceholders()).flatMap(Arrays::stream).flatMap(Arrays::stream).filter(BlockPlaceholder::isController).forEach(holder -> holder.setController(false));
                            this.selectedBlocks.stream().map(pos -> this.project.getBlockPlaceholders()[pos.x][pos.y][pos.z]).forEach(holder -> {
                                holder.setController(true);
                                holder.setFacing(facing);
                            });
                            this.reloadScene(false, true);
                        });
                    }
                });
            }
            this.editor.openMenu(mouseX, mouseY, menu);
        }
    }

    public void drawInBackground(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.drawInBackground(graphics, mouseX, mouseY, partialTicks);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isMouseOverElement(mouseX, mouseY)) {
            this.clickedPosFace = this.scene.getHoverPosFace();
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.isMouseOverElement(mouseX, mouseY)) {
            Either key;
            Object clickTime2;
            BlockPosFace hoverPosFace = this.scene.getHoverPosFace();
            BlockPosFace clickPosFace = this.scene.getClickPosFace();
            if (hoverPosFace != null && hoverPosFace.equals((Object)clickPosFace) && button == 0 && this.gui != null) {
                Vector3i pos = new Vector3i(hoverPosFace.pos.m_123341_(), hoverPosFace.pos.m_123342_(), hoverPosFace.pos.m_123343_());
                if (MultiblockPatternPanel.isCtrlDown() || MultiblockPatternPanel.isShiftDown()) {
                    if (this.isBlockSelected(pos)) {
                        this.removeSelectedBlock(pos);
                    } else {
                        this.addSelectedBlock(pos);
                    }
                } else {
                    long clickTime2 = this.gui.getTickCount();
                    if (clickTime2 - this.lastClickTime < 10L) {
                        ArrayList<Vector3i> blocks = new ArrayList<Vector3i>();
                        blocks.add(pos);
                        BlockPlaceholder holder = this.project.getBlockPlaceholders()[pos.x()][pos.y()][pos.z()];
                        Set<Either<String, File>> predicates = holder.getPredicates();
                        for (int x = 0; x < this.project.getBlockPlaceholders().length; ++x) {
                            for (int y = 0; y < this.project.getBlockPlaceholders()[x].length; ++y) {
                                for (int z = 0; z < this.project.getBlockPlaceholders()[x][y].length; ++z) {
                                    BlockPlaceholder holder2 = this.project.getBlockPlaceholders()[x][y][z];
                                    if (!holder2.getPredicates().equals(predicates)) continue;
                                    blocks.add(new Vector3i(x, y, z));
                                }
                            }
                        }
                        this.addSelectedBlocks(blocks, true);
                    } else {
                        this.addSelectedBlock(pos, true);
                    }
                    this.lastClickTime = this.gui.getTickCount();
                }
            }
            if (hoverPosFace != null && hoverPosFace.equals((Object)this.clickedPosFace) && button == 1) {
                this.openMenu(mouseX, mouseY);
            }
            if (hoverPosFace != null && button == 0 && this.gui != null && (clickTime2 = this.gui.getModularUIGui().getDraggingElement()) instanceof Either && ((Boolean)(key = (Either)clickTime2).map(l -> {
                boolean bl;
                if (l instanceof String) {
                    String s = (String)l;
                    if (this.project.getPredicateResource().hasBuiltinResource(s)) {
                        bl = true;
                        return bl;
                    }
                }
                bl = false;
                return bl;
            }, r -> {
                boolean bl;
                if (r instanceof File) {
                    File f = (File)r;
                    if (this.project.getPredicateResource().hasStaticResource(f)) {
                        bl = true;
                        return bl;
                    }
                }
                bl = false;
                return bl;
            })).booleanValue()) {
                BlockPos pos = this.scene.getHoverPosFace().pos;
                BlockPlaceholder holder = this.project.getBlockPlaceholders()[pos.m_123341_()][pos.m_123342_()][pos.m_123343_()];
                holder.getPredicates().clear();
                holder.getPredicates().add((Either<String, File>)key);
                this.reloadScene(false, true);
            }
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public MachineEditor getEditor() {
        return this.editor;
    }

    public MultiblockMachineProject getProject() {
        return this.project;
    }

    public TrackedDummyWorld getLevel() {
        return this.level;
    }

    public SceneEditorWidget getScene() {
        return this.scene;
    }

    public int getVisibleLayer() {
        return this.visibleLayer;
    }

    private class PredicateConfigurator
    implements IConfigurable {
        private PredicateConfigurator() {
        }

        public String mapName(Either<String, File> key) {
            return (String)key.map(l -> l, r -> String.valueOf(ChatFormatting.YELLOW) + MultiblockPatternPanel.this.project.getPredicateResource().getStaticResourceName((File)r) + String.valueOf(ChatFormatting.RESET));
        }

        public Either<String, File> mapKey(String name) {
            if (name.startsWith(ChatFormatting.YELLOW.toString()) && name.endsWith(ChatFormatting.RESET.toString())) {
                String realName = name.substring(ChatFormatting.YELLOW.toString().length(), name.length() - ChatFormatting.RESET.toString().length());
                return Either.right((Object)MultiblockPatternPanel.this.project.getPredicateResource().getStaticResourceFile(realName));
            }
            return Either.left((Object)name);
        }

        public void buildConfigurator(ConfiguratorGroup father) {
            List<BlockPlaceholder> placeholders = MultiblockPatternPanel.this.selectedBlocks.stream().map(pos -> MultiblockPatternPanel.this.project.getBlockPlaceholders()[pos.x][pos.y][pos.z]).toList();
            LinkedList<Either<String, File>> intersection = new LinkedList<Either<String, File>>(placeholders.get(0).getPredicates());
            Runnable notifyUpdate = () -> placeholders.forEach(holder -> {
                Set<Either<String, File>> predicates = holder.getPredicates();
                predicates.clear();
                predicates.addAll(intersection);
                MultiblockPatternPanel.this.reloadScene(false, true);
            });
            for (BlockPlaceholder placeholder : placeholders) {
                intersection.retainAll(placeholder.getPredicates());
            }
            ArrayConfiguratorGroup predicatesConfigurator = new ArrayConfiguratorGroup("mbd2.gui.editor.group.predicate", false, () -> intersection, (getter, setter) -> {
                WidgetGroup group = new WidgetGroup(0, 0, 180, 100);
                ImageWidget preview = new ImageWidget(50, 0, 80, 80, () -> this.lambda$buildConfigurator$6((Supplier)getter)).setBorder(2, ColorPattern.T_WHITE.color);
                preview.setDraggingConsumer(o -> {
                    Either key;
                    return o instanceof Either && (Boolean)(key = (Either)o).map(l -> {
                        boolean bl;
                        if (l instanceof String) {
                            String s = (String)l;
                            if (MultiblockPatternPanel.this.project.getPredicateResource().hasBuiltinResource(s)) {
                                bl = true;
                                return bl;
                            }
                        }
                        bl = false;
                        return bl;
                    }, r -> {
                        boolean bl;
                        if (r instanceof File) {
                            File f = (File)r;
                            if (MultiblockPatternPanel.this.project.getPredicateResource().hasStaticResource(f)) {
                                bl = true;
                                return bl;
                            }
                        }
                        bl = false;
                        return bl;
                    }) != false;
                }, o -> preview.setBorder(2, ColorPattern.GREEN.color), o -> preview.setBorder(2, ColorPattern.T_WHITE.color), o -> {
                    Either key;
                    if (o instanceof Either && ((Boolean)(key = (Either)o).map(l -> {
                        boolean bl;
                        if (l instanceof String) {
                            String s = (String)l;
                            if (MultiblockPatternPanel.this.project.getPredicateResource().hasBuiltinResource(s)) {
                                bl = true;
                                return bl;
                            }
                        }
                        bl = false;
                        return bl;
                    }, r -> {
                        boolean bl;
                        if (r instanceof File) {
                            File f = (File)r;
                            if (MultiblockPatternPanel.this.project.getPredicateResource().hasStaticResource(f)) {
                                bl = true;
                                return bl;
                            }
                        }
                        bl = false;
                        return bl;
                    })).booleanValue()) {
                        setter.accept(key);
                    }
                });
                PredicateResource resource = MultiblockPatternPanel.this.project.getPredicateResource();
                SelectorWidget selector = new SelectorWidget(0, 85, 180, 10, resource.allResources().map(Map.Entry::getKey).map(this::mapName).toList(), -1).setCandidatesSupplier(() -> resource.allResources().map(Map.Entry::getKey).map(this::mapName).toList()).setSupplier(() -> this.lambda$buildConfigurator$16((Supplier)getter)).setOnChanged(name -> setter.accept(this.mapKey((String)name))).setMaxCount(5).setIsUp(true).setButtonBackground(new IGuiTexture[]{ColorPattern.T_GRAY.rectTexture().setRadius(5.0f)}).setBackground((IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{ColorPattern.BLACK.rectTexture(), ColorPattern.GRAY.borderTexture(1)})).setValue(this.mapName((Either<String, File>)((Either)getter.get())));
                group.addWidget((Widget)preview);
                group.addWidget((Widget)selector);
                return new WrapperConfigurator("", (Widget)group);
            }, true);
            predicatesConfigurator.setAddDefault(() -> Either.left((Object)"any"));
            predicatesConfigurator.setOnAdd(value -> {
                intersection.add((Either<String, File>)value);
                notifyUpdate.run();
            });
            predicatesConfigurator.setOnRemove(value -> {
                intersection.remove(value);
                notifyUpdate.run();
            });
            predicatesConfigurator.setOnUpdate(values -> {
                intersection.clear();
                intersection.addAll((Collection<Either<String, File>>)values);
                notifyUpdate.run();
            });
            predicatesConfigurator.setOnReorder((index, value) -> {});
            father.addConfigurators(new Configurator[]{predicatesConfigurator});
        }

        private /* synthetic */ String lambda$buildConfigurator$16(Supplier getter) {
            return this.mapName((Either<String, File>)((Either)getter.get()));
        }

        private /* synthetic */ IGuiTexture lambda$buildConfigurator$6(Supplier getter) {
            SimplePredicate resource = (SimplePredicate)MultiblockPatternPanel.this.project.getPredicateResource().getResource((Either)getter.get());
            if (resource == null) {
                return IGuiTexture.EMPTY;
            }
            return resource.getPreviewTexture();
        }
    }
}

