/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common.gui.editor.recipe;

import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.Icons;
import com.lowdragmc.lowdraglib.gui.editor.configurator.NumberConfigurator;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ProgressTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.util.TreeBuilder;
import com.lowdragmc.lowdraglib.gui.widget.DialogWidget;
import com.lowdragmc.lowdraglib.gui.widget.DraggableScrollableWidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.ProgressWidget;
import com.lowdragmc.lowdraglib.gui.widget.SelectableWidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.TabButton;
import com.lowdragmc.lowdraglib.gui.widget.TabContainer;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.utils.Size;
import com.lowdragmc.mbd2.api.capability.recipe.IO;
import com.lowdragmc.mbd2.api.capability.recipe.RecipeCapability;
import com.lowdragmc.mbd2.api.recipe.MBDRecipe;
import com.lowdragmc.mbd2.api.recipe.content.Content;
import com.lowdragmc.mbd2.api.recipe.content.ContentWidget;
import com.lowdragmc.mbd2.common.gui.editor.MachineEditor;
import com.lowdragmc.mbd2.common.gui.editor.recipe.ConditionContainer;
import com.lowdragmc.mbd2.common.gui.editor.recipe.ContentContainer;
import com.lowdragmc.mbd2.common.gui.editor.recipe.RecipeTypePanel;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class RecipeList
extends DraggableScrollableWidgetGroup {
    private final RecipeTypePanel recipeTypePanel;
    private final boolean isFuel;
    @Nullable
    private MBDRecipe selected;
    @Nullable
    private Runnable onSelected;

    public RecipeList(RecipeTypePanel recipeTypePanel, Size size, boolean isFuel) {
        super(0, 0, size.width, size.height);
        this.recipeTypePanel = recipeTypePanel;
        this.isFuel = isFuel;
        this.setYScrollBarWidth(4).setYBarStyle(null, (IGuiTexture)ColorPattern.T_WHITE.rectTexture().setRadius(2.0f).transform(-0.5f, 0.0f));
        this.recipeTypePanel.recipeType.getBuiltinRecipes().values().stream().filter(recipe -> recipe.isFuel() == isFuel).forEach(this::addRecipe);
    }

    public void addRecipe(MBDRecipe recipe) {
        int yOffset = 3 + this.widgets.size() * 32;
        SelectableWidgetGroup selectableWidgetGroup = new SelectableWidgetGroup(0, yOffset, this.getSizeWidth() - 2, 30);
        selectableWidgetGroup.setPrefab((Object)recipe);
        selectableWidgetGroup.addWidget((Widget)new ImageWidget(1, 0, this.getSizeWidth() - 2, 10, (IGuiTexture)new TextTexture().setSupplier(() -> recipe.m_6423_().toString()).setType(TextTexture.TextType.LEFT_HIDE).setWidth(this.getSizeWidth() - 2)));
        selectableWidgetGroup.addWidget((Widget)new ProgressWidget(ProgressWidget.JEIProgress, (this.getSizeWidth() - 2) / 2 - 9, 11, 18, 18, this.isFuel ? new ProgressTexture() : new ProgressTexture((IGuiTexture)new ResourceTexture("mbd2:textures/gui/arrow_bar.png").getSubTexture(0.0, 0.0, 1.0, 0.5), (IGuiTexture)new ResourceTexture("mbd2:textures/gui/arrow_bar.png").getSubTexture(0.0, 0.5, 1.0, 0.5))));
        AtomicReference<WidgetGroup> inputs = new AtomicReference<WidgetGroup>();
        inputs.set(this.createContents(recipe.inputs, 0, 20));
        selectableWidgetGroup.addWidget((Widget)inputs.get());
        AtomicReference<WidgetGroup> outputs = new AtomicReference<WidgetGroup>();
        if (!this.isFuel) {
            outputs.set(this.createContents(recipe.outputs, this.getSizeWidth() - 24, -20));
            selectableWidgetGroup.addWidget((Widget)outputs.get());
        }
        selectableWidgetGroup.setSelectedTexture((IGuiTexture)ColorPattern.T_GRAY.rectTexture());
        selectableWidgetGroup.setOnSelected(group -> {
            this.selected = recipe;
            if (this.onSelected != null) {
                this.onSelected.run();
            }
            this.recipeTypePanel.contentGroup.clearAllWidgets();
            int w = this.recipeTypePanel.contentGroup.getSizeWidth();
            int h = this.recipeTypePanel.contentGroup.getSizeHeight() - 20;
            TabContainer tabContainer = new TabContainer(0, 15, w, h);
            this.recipeTypePanel.contentGroup.addWidget((Widget)tabContainer);
            ContentContainer inputsContainer = new ContentContainer(0, 10, w, h / 2 - 18, recipe.inputs, () -> {
                selectableWidgetGroup.removeWidget((Widget)inputs.get());
                inputs.set(this.createContents(recipe.inputs, 0, 20));
                selectableWidgetGroup.addWidget((Widget)inputs.get());
            });
            WidgetGroup container = new WidgetGroup(0, 0, w, h).addWidget((Widget)new ImageWidget(0, 0, w, 10, (IGuiTexture)new TextTexture(IO.IN.getTooltip()).setWidth(w))).addWidget((Widget)inputsContainer);
            NumberConfigurator durationWidget = new NumberConfigurator("recipe.duration", () -> recipe.duration, v -> {
                recipe.duration = v.intValue();
            }, (Number)100, true);
            durationWidget.setRange((Number)1, (Number)Integer.MAX_VALUE);
            durationWidget.setTips(new String[]{this.isFuel ? "recipe.duration.fuel.tooltip" : "recipe.duration.common.tooltip"});
            durationWidget.init(100);
            durationWidget.setSelfPosition((w - 200) / 2, h / 2 - 7);
            container.addWidget((Widget)durationWidget);
            NumberConfigurator priorityWidget = new NumberConfigurator("recipe.priority", () -> recipe.priority, v -> {
                recipe.priority = v.intValue();
            }, (Number)0, true);
            priorityWidget.setRange((Number)Integer.MIN_VALUE, (Number)Integer.MAX_VALUE);
            priorityWidget.setTips(new String[]{"recipe.priority.tooltip"});
            priorityWidget.init(100);
            priorityWidget.setSelfPosition((w - 200) / 2 + 100, h / 2 - 7);
            container.addWidget((Widget)priorityWidget);
            if (!this.isFuel) {
                ContentContainer outputsContainer = new ContentContainer(0, h / 2 + 18, w, h / 2 - 18, recipe.outputs, () -> {
                    selectableWidgetGroup.removeWidget((Widget)outputs.get());
                    outputs.set(this.createContents(recipe.outputs, this.getSizeWidth() - 24, -20));
                    selectableWidgetGroup.addWidget((Widget)outputs.get());
                });
                container.addWidget((Widget)new ImageWidget(0, h / 2 + 8, w, 10, (IGuiTexture)new TextTexture(IO.OUT.getTooltip()).setWidth(w))).addWidget((Widget)outputsContainer);
                inputsContainer.setOnSelected(outputsContainer::clearSelected);
                outputsContainer.setOnSelected(inputsContainer::clearSelected);
            }
            this.recipeTypePanel.getFloatView().loadRecipe(this.isFuel, this.selected);
            tabContainer.addTab(this.createTabButton(0, "editor.machine.recipe_list.contents"), container);
            tabContainer.addTab(this.createTabButton(1, "editor.machine.recipe_list.conditions"), new WidgetGroup(0, 0, w, h).addWidget((Widget)new ImageWidget(0, 0, w, 10, (IGuiTexture)new TextTexture("recipe.condition.name").setWidth(w))).addWidget((Widget)new ConditionContainer(0, 10, w, h - 10, recipe.conditions)));
            tabContainer.addTab(this.createTabButton(2, "editor.machine.recipe_list.data"), new WidgetGroup(0, 0, w, h));
        });
        selectableWidgetGroup.setOnUnSelected(group -> {
            this.selected = null;
            this.recipeTypePanel.contentGroup.clearAllWidgets();
            this.recipeTypePanel.editor.getConfigPanel().clearAllConfigurators(MachineEditor.SECOND);
            this.recipeTypePanel.getFloatView().clearRecipe();
        });
        this.addWidget((Widget)selectableWidgetGroup);
    }

    private TabButton createTabButton(int index, String name) {
        return new TabButton(index * 100, -16, 80, 11).setTexture((IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{ColorPattern.T_GRAY.rectTexture().setRadius(7.5f), new TextTexture(name).setWidth(80).setDropShadow(false).setType(TextTexture.TextType.ROLL)}), (IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{ColorPattern.T_GREEN.rectTexture().setRadius(7.5f), new TextTexture(name).setWidth(80).setDropShadow(false).setType(TextTexture.TextType.ROLL)})).setHoverTexture(new IGuiTexture[]{new GuiTextureGroup(new IGuiTexture[]{ColorPattern.T_WHITE.rectTexture().setRadius(7.5f), new TextTexture(name).setWidth(80).setDropShadow(false).setType(TextTexture.TextType.ROLL)})});
    }

    private WidgetGroup createContents(Map<RecipeCapability<?>, List<Content>> recipeContents, int x, int offset) {
        WidgetGroup group = new WidgetGroup(0, 0, 0, 0);
        int left = (this.getSizeWidth() - 22) / 2 / 20;
        for (Map.Entry<RecipeCapability<?>, List<Content>> entry : recipeContents.entrySet()) {
            if (left > 0) {
                List<Content> contents = entry.getValue();
                for (Content content : contents) {
                    ContentWidget widget = new ContentWidget(x, 10, entry.getKey(), content);
                    group.addWidget(widget);
                    x += offset;
                    if (--left != 0) continue;
                    break;
                }
            }
            if (left != 0) continue;
            break;
        }
        return group;
    }

    public void removeRecipe(MBDRecipe recipe) {
        this.recipeTypePanel.recipeType.getBuiltinRecipes().remove(recipe.m_6423_(), recipe);
        for (Widget widget : this.widgets) {
            SelectableWidgetGroup selectableWidgetGroup;
            if (!(widget instanceof SelectableWidgetGroup) || (selectableWidgetGroup = (SelectableWidgetGroup)widget).getPrefab() != recipe) continue;
            int index = this.widgets.indexOf(selectableWidgetGroup);
            for (int i = index + 1; i < this.widgets.size(); ++i) {
                ((Widget)this.widgets.get(i)).addSelfPosition(0, -30);
            }
            this.widgets.remove(selectableWidgetGroup);
            break;
        }
        this.computeMax();
        if (this.selected == recipe) {
            this.selected = null;
            this.recipeTypePanel.contentGroup.clearAllWidgets();
            this.recipeTypePanel.editor.getConfigPanel().clearAllConfigurators(MachineEditor.SECOND);
            this.recipeTypePanel.getFloatView().clearRecipe();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isMouseOverElement(mouseX, mouseY) && button == 1) {
            TreeBuilder.Menu menu = TreeBuilder.Menu.start().leaf((IGuiTexture)Icons.ADD_FILE, "editor.machine.recipe_type.add_recipe", () -> DialogWidget.showStringEditorDialog((WidgetGroup)this.recipeTypePanel.editor, (String)"editor.machine.recipe_type.add_recipe", (String)"unique_id", s -> true, s -> {
                if (s == null || !ResourceLocation.m_135830_((String)s)) {
                    return;
                }
                ResourceLocation id = new ResourceLocation(s);
                if (this.isFuel) {
                    id = new ResourceLocation(id.m_135827_(), "fuel/" + id.m_135815_());
                }
                if (!this.recipeTypePanel.recipeType.getBuiltinRecipes().containsKey(id)) {
                    this.addRecipe(this.recipeTypePanel.recipeType.recipeBuilder(id, new Object[0]).isFuel(this.isFuel).duration(100).saveAsBuiltinRecipe());
                }
            })).leaf((IGuiTexture)Icons.ADD_FILE, "editor.machine.recipe_type.add_recipe_auto_id", () -> {
                int index = 0;
                String path = this.recipeTypePanel.recipeType.getRegistryName().m_135815_() + "/" + (this.isFuel ? "fuel/" : "") + "recipe_";
                ResourceLocation id = new ResourceLocation(this.recipeTypePanel.recipeType.getRegistryName().m_135827_(), path + index++);
                while (this.recipeTypePanel.recipeType.getBuiltinRecipes().containsKey(id)) {
                    id = new ResourceLocation(id.m_135827_(), path + index++);
                }
                this.addRecipe(this.recipeTypePanel.recipeType.recipeBuilder(id, new Object[0]).isFuel(this.isFuel).duration(100).saveAsBuiltinRecipe());
            });
            if (this.selected != null) {
                menu.crossLine();
                menu.leaf("ldlib.gui.editor.menu.rename", () -> {
                    String currentID = this.selected.m_6423_().toString();
                    DialogWidget.showStringEditorDialog((WidgetGroup)this.recipeTypePanel.editor, (String)"ldlib.gui.editor.tips.rename", (String)currentID, s -> true, s -> {
                        if (s == null || !ResourceLocation.m_135830_((String)s)) {
                            return;
                        }
                        ResourceLocation id = new ResourceLocation(s);
                        int index2 = 0;
                        while (this.recipeTypePanel.recipeType.getBuiltinRecipes().containsKey(id)) {
                            id = new ResourceLocation(id.m_135827_(), id.m_135815_() + "_" + index2++);
                        }
                        if (currentID.equals(id.toString())) {
                            return;
                        }
                        MBDRecipe copied = this.selected.deepCopied(id);
                        this.recipeTypePanel.recipeType.getBuiltinRecipes().put(id, copied);
                        this.addRecipe(copied);
                        this.removeRecipe(this.selected);
                    });
                });
                menu.leaf((IGuiTexture)Icons.COPY, "ldlib.gui.editor.menu.copy", () -> {
                    ResourceLocation copiedID = new ResourceLocation(this.selected.m_6423_().m_135827_(), this.selected.m_6423_().m_135815_() + "_copy");
                    int index = 0;
                    while (this.recipeTypePanel.recipeType.getBuiltinRecipes().containsKey(copiedID)) {
                        copiedID = new ResourceLocation(copiedID.m_135827_(), copiedID.m_135815_() + "_" + index++);
                    }
                    DialogWidget.showStringEditorDialog((WidgetGroup)this.recipeTypePanel.editor, (String)"ldlib.gui.editor.menu.copy", (String)copiedID.toString(), s -> true, s -> {
                        if (s == null || !ResourceLocation.m_135830_((String)s)) {
                            return;
                        }
                        ResourceLocation id = new ResourceLocation(s);
                        int index2 = 0;
                        while (this.recipeTypePanel.recipeType.getBuiltinRecipes().containsKey(id)) {
                            id = new ResourceLocation(id.m_135827_(), id.m_135815_() + "_" + index2++);
                        }
                        MBDRecipe copied = this.selected.deepCopied(id);
                        this.recipeTypePanel.recipeType.getBuiltinRecipes().put(id, copied);
                        this.addRecipe(copied);
                    });
                });
                menu.leaf((IGuiTexture)Icons.REMOVE_FILE, "editor.machine.recipe_type.remove_recipe", () -> this.removeRecipe(this.selected));
            }
            this.recipeTypePanel.editor.openMenu(mouseX, mouseY, menu);
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public void setOnSelected(@Nullable Runnable onSelected) {
        this.onSelected = onSelected;
    }
}

