/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common.machine;

import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.RequireRerender;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import com.lowdragmc.mbd2.api.blockentity.IMachineBlockEntity;
import com.lowdragmc.mbd2.api.capability.recipe.IO;
import com.lowdragmc.mbd2.api.capability.recipe.IRecipeHandlerTrait;
import com.lowdragmc.mbd2.api.machine.IMultiController;
import com.lowdragmc.mbd2.api.machine.IMultiPart;
import com.lowdragmc.mbd2.api.recipe.MBDRecipe;
import com.lowdragmc.mbd2.api.recipe.RecipeLogic;
import com.lowdragmc.mbd2.api.recipe.content.ContentModifier;
import com.lowdragmc.mbd2.common.machine.MBDMachine;
import com.lowdragmc.mbd2.common.machine.MBDMultiblockMachine;
import com.lowdragmc.mbd2.common.machine.definition.MBDMachineDefinition;
import com.lowdragmc.mbd2.common.machine.definition.config.ConfigPartSettings;
import com.lowdragmc.mbd2.common.trait.IAutoIOTrait;
import com.lowdragmc.mbd2.common.trait.ICapabilityProviderTrait;
import com.lowdragmc.mbd2.common.trait.ITrait;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MBDPartMachine
extends MBDMachine
implements IMultiPart {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(MBDPartMachine.class, MBDMachine.MANAGED_FIELD_HOLDER);
    @DescSynced
    @RequireRerender
    protected final Set<BlockPos> controllerPositions = new HashSet<BlockPos>();
    @DescSynced
    @RequireRerender
    protected boolean disableRendering = false;

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    public MBDPartMachine(IMachineBlockEntity machineHolder, MBDMachineDefinition definition, Object ... args) {
        super(machineHolder, definition, args);
    }

    @Override
    public boolean hasController(BlockPos controllerPos) {
        return this.controllerPositions.contains(controllerPos);
    }

    @Override
    public boolean isFormed() {
        return !this.controllerPositions.isEmpty();
    }

    @Override
    public List<IMultiController> getControllers() {
        ArrayList<IMultiController> result = new ArrayList<IMultiController>();
        for (BlockPos blockPos : this.controllerPositions) {
            IMultiController.ofController((BlockGetter)this.getLevel(), blockPos).ifPresent(result::add);
        }
        return result;
    }

    @Override
    public List<IRecipeHandlerTrait<?>> getRecipeHandlers() {
        ArrayList handlers = new ArrayList();
        for (ITrait additionalTrait : this.getAdditionalTraits()) {
            handlers.addAll(additionalTrait.getRecipeHandlerTraits());
        }
        return handlers;
    }

    @Override
    public void onUnload() {
        super.onUnload();
        Level level = this.getLevel();
        for (BlockPos pos : this.controllerPositions) {
            if (!(level instanceof ServerLevel) || !level.m_46749_(pos)) continue;
            IMultiController.ofController((BlockGetter)this.getLevel(), pos).ifPresent(IMultiController::onPartUnload);
        }
        this.controllerPositions.clear();
    }

    @Override
    public void removedFromController(IMultiController controller) {
        this.controllerPositions.remove(controller.getPos());
        this.checkDisabledRendering();
        if (!this.isFormed()) {
            this.setMachineState("base");
        }
        this.notifyBlockUpdate();
    }

    @Override
    public void addedToController(IMultiController controller) {
        this.controllerPositions.add(controller.getPos());
        this.checkDisabledRendering();
        if (this.isFormed()) {
            this.setMachineState("formed");
        }
        this.notifyBlockUpdate();
    }

    public void checkDisabledRendering() {
        boolean result = false;
        for (IMultiController controller : this.getControllers()) {
            MBDMultiblockMachine machine;
            if (!(controller instanceof MBDMultiblockMachine) || !(machine = (MBDMultiblockMachine)controller).getRenderingDisabledPositions().contains(this.getPos())) continue;
            result = true;
            break;
        }
        this.disableRendering = result;
    }

    @Override
    public boolean canShared() {
        return Optional.ofNullable(this.getDefinition().partSettings()).map(ConfigPartSettings::canShare).orElse(true);
    }

    @Override
    public void notifyControllerRecipeStatusChanged(IMultiController controller, RecipeLogic.Status oldStatus, RecipeLogic.Status newStatus) {
        IMultiPart.super.notifyControllerRecipeStatusChanged(controller, oldStatus, newStatus);
        if (this.isFormed()) {
            switch (newStatus) {
                case WORKING: {
                    this.setMachineState("working");
                    break;
                }
                case IDLE: {
                    if (this.getDefinition().stateMachine().hasState("formed")) {
                        this.setMachineState("formed");
                        break;
                    }
                    this.setMachineState("base");
                    break;
                }
                case WAITING: {
                    this.setMachineState("waiting");
                    break;
                }
                case SUSPEND: {
                    this.setMachineState("suspend");
                }
            }
        } else {
            this.setMachineState("base");
        }
    }

    @Override
    public MBDRecipe modifyControllerRecipe(@Nonnull MBDRecipe recipe, RecipeLogic controllerRecipeLogic) {
        if (this.getDefinition().partSettings() != null) {
            return this.getDefinition().partSettings().recipeModifiers().applyModifiers(controllerRecipeLogic, recipe);
        }
        return recipe;
    }

    @Override
    public ContentModifier getMaxControllerParallel(@NotNull MBDRecipe recipe, RecipeLogic controllerRecipeLogic) {
        if (this.getDefinition().partSettings() != null) {
            return this.getDefinition().partSettings().recipeModifiers().getMaxParallel(controllerRecipeLogic, recipe);
        }
        return ContentModifier.IDENTITY;
    }

    @Override
    public boolean alwaysTryModifyControllerRecipe() {
        if (this.getDefinition().partSettings() != null) {
            return !this.getDefinition().partSettings().recipeModifiers().recipeModifiers.isEmpty();
        }
        return false;
    }

    @Override
    public void internalServerTick() {
        super.internalServerTick();
        for (ConfigPartSettings.ProxyCapability proxy : Objects.requireNonNull(this.getDefinition().partSettings()).proxyControllerCapabilities()) {
            if (!proxy.autoIO().isEnable()) continue;
            Direction front = this.getFrontFacing().orElse(Direction.NORTH);
            BlockPos pos = this.getPos();
            for (IMultiController controller : this.getControllers()) {
                if (!(controller instanceof MBDMultiblockMachine)) continue;
                MBDMultiblockMachine proxyController = (MBDMultiblockMachine)controller;
                for (ITrait trait : proxyController.getAdditionalTraits()) {
                    if (!(trait instanceof IAutoIOTrait)) continue;
                    IAutoIOTrait autoIOTrait = (IAutoIOTrait)trait;
                    if (!trait.getDefinition().getName().contains(proxy.traitNameFilter())) continue;
                    for (Direction side : Direction.values()) {
                        IO io = proxy.autoIO().getIO(front, side);
                        if (io == IO.NONE) continue;
                        autoIOTrait.handleAutoIO(pos, side, io);
                    }
                }
            }
        }
    }

    @Override
    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        LazyOptional<T> result = super.getCapability(cap, side);
        if (result.isPresent() || Objects.requireNonNull(this.getDefinition().partSettings()).proxyControllerCapabilities().isEmpty()) {
            return result;
        }
        Direction front = this.getFrontFacing().orElse(Direction.NORTH);
        for (IMultiController controller : this.getControllers()) {
            if (!(controller instanceof MBDMultiblockMachine)) continue;
            MBDMultiblockMachine proxyController = (MBDMultiblockMachine)controller;
            ArrayList results = new ArrayList();
            for (ConfigPartSettings.ProxyCapability proxyControllerCapability : this.getDefinition().partSettings().proxyControllerCapabilities()) {
                IO io = proxyControllerCapability.capabilityIO().getIO(front, side);
                for (ITrait trait : proxyController.getAdditionalTraits()) {
                    if (!trait.getDefinition().getName().contains(proxyControllerCapability.traitNameFilter())) continue;
                    for (ICapabilityProviderTrait<?> capabilityProviderTrait : trait.getCapabilityProviderTraits()) {
                        if (capabilityProviderTrait.getCapability() != cap) continue;
                        results.add(capabilityProviderTrait.getCapContent(io));
                    }
                }
            }
            if (results.size() == 1) {
                return LazyOptional.of(() -> results.get(0));
            }
            if (results.size() <= 1) continue;
            for (ITrait trait : proxyController.getAdditionalTraits()) {
                for (ICapabilityProviderTrait<?> capabilityProviderTrait : trait.getCapabilityProviderTraits()) {
                    if (capabilityProviderTrait.getCapability() != cap) continue;
                    return LazyOptional.of(() -> capabilityProviderTrait.mergeContents(results));
                }
            }
            return LazyOptional.of(() -> results.get(0));
        }
        return result;
    }

    @Override
    public boolean isDisableRendering() {
        return this.disableRendering;
    }
}

