/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common.machine.definition;

import com.google.common.collect.Queues;
import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.client.renderer.IRenderer;
import com.lowdragmc.lowdraglib.client.renderer.impl.UIResourceRenderer;
import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurable;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurableWidget;
import com.lowdragmc.lowdraglib.gui.editor.data.resource.IRendererResource;
import com.lowdragmc.lowdraglib.gui.editor.data.resource.Resource;
import com.lowdragmc.lowdraglib.gui.editor.data.resource.TexturesResource;
import com.lowdragmc.lowdraglib.gui.editor.ui.Editor;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.ProgressWidget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.jei.JEIPlugin;
import com.lowdragmc.lowdraglib.syncdata.IPersistedSerializable;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.mbd2.MBD2;
import com.lowdragmc.mbd2.api.blockentity.IMachineBlockEntity;
import com.lowdragmc.mbd2.api.recipe.MBDRecipeType;
import com.lowdragmc.mbd2.client.renderer.MBDBESRenderer;
import com.lowdragmc.mbd2.client.renderer.MBDBlockRenderer;
import com.lowdragmc.mbd2.client.renderer.MBDItemRenderer;
import com.lowdragmc.mbd2.common.block.MBDMachineBlock;
import com.lowdragmc.mbd2.common.blockentity.MachineBlockEntity;
import com.lowdragmc.mbd2.common.item.MBDMachineItem;
import com.lowdragmc.mbd2.common.machine.MBDMachine;
import com.lowdragmc.mbd2.common.machine.MBDPartMachine;
import com.lowdragmc.mbd2.common.machine.definition.config.ConfigBlockProperties;
import com.lowdragmc.mbd2.common.machine.definition.config.ConfigItemProperties;
import com.lowdragmc.mbd2.common.machine.definition.config.ConfigMachineEvents;
import com.lowdragmc.mbd2.common.machine.definition.config.ConfigMachineSettings;
import com.lowdragmc.mbd2.common.machine.definition.config.ConfigPartSettings;
import com.lowdragmc.mbd2.common.machine.definition.config.ConfigRecipeLogicSettings;
import com.lowdragmc.mbd2.common.machine.definition.config.MachineState;
import com.lowdragmc.mbd2.common.machine.definition.config.StateMachine;
import com.lowdragmc.mbd2.common.trait.ITrait;
import com.lowdragmc.mbd2.common.trait.IUIProviderTrait;
import com.lowdragmc.mbd2.common.trait.TraitDefinition;
import com.lowdragmc.mbd2.integration.emi.MBDRecipeTypeEmiCategory;
import com.lowdragmc.mbd2.integration.jei.MBDRecipeTypeCategory;
import com.lowdragmc.mbd2.integration.rei.MBDRecipeTypeDisplayCategory;
import com.lowdragmc.mbd2.utils.WidgetUtils;
import dev.emi.emi.api.EmiApi;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import me.shedaniel.rei.api.client.view.ViewSearchBuilder;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;
import org.jetbrains.annotations.Nullable;

@LDLRegister(name="single_machine", group="machine_definition")
public class MBDMachineDefinition
implements IConfigurable,
IPersistedSerializable {
    static final ThreadLocal<MBDMachineDefinition> STATE = new ThreadLocal();
    @Configurable(tips={"config.definition.id.tooltip", "config.require_restart"}, forceUpdate=false)
    private ResourceLocation id;
    protected final StateMachine<?> stateMachine;
    @Configurable(name="config.definition.block_properties", subConfigurable=true, tips={"config.definition.block_properties.tooltip"}, collapse=false)
    protected final ConfigBlockProperties blockProperties;
    @Configurable(name="config.definition.item_properties", subConfigurable=true, tips={"config.definition.item_properties.tooltip"}, collapse=false)
    protected final ConfigItemProperties itemProperties;
    @Configurable(name="config.definition.machine_settings", subConfigurable=true, tips={"config.definition.machine_settings.tooltip"}, collapse=false)
    protected ConfigMachineSettings machineSettings;
    @Configurable(name="config.definition.recipe_logic_settings", subConfigurable=true, tips={"config.definition.recipe_logic_settings.tooltip.0", "config.definition.recipe_logic_settings.tooltip.1"}, collapse=false)
    protected ConfigRecipeLogicSettings recipeLogicSettings;
    @Configurable(name="config.definition.part_settings", subConfigurable=true, tips={"config.definition.part_settings.tooltip.0", "config.definition.part_settings.tooltip.1", "config.definition.part_settings.tooltip.2"})
    @Nullable
    protected ConfigPartSettings partSettings;
    @Persisted(subPersisted=true)
    protected final ConfigMachineEvents machineEvents;
    protected ConfigMachineSettingsFactory machineSettingsFactory;
    @Nullable
    protected ConfigPartSettingsFactory partSettingsFactory;
    @Nullable
    private File projectFile;
    private Block block;
    private Item item;
    private BlockEntityType<?> blockEntityType;
    private IRenderer blockRenderer;
    private IRenderer itemRenderer;
    private Function<MBDMachine, WidgetGroup> uiCreator;

    public static MBDMachineDefinition get() {
        return STATE.get();
    }

    public static void set(MBDMachineDefinition state) {
        STATE.set(state);
    }

    public static void clear() {
        STATE.remove();
    }

    protected MBDMachineDefinition(ResourceLocation id, @Nullable MachineState rootState, @Nullable ConfigBlockProperties blockProperties, @Nullable ConfigItemProperties itemProperties, @Nullable ConfigMachineSettingsFactory machineSettingsFactory, @Nullable ConfigRecipeLogicSettings recipeLogicSettings, @Nullable ConfigPartSettingsFactory partSettingsFactory) {
        this.id = id == null ? new ResourceLocation("mbd2", "undefined") : id;
        this.stateMachine = new StateMachine<MachineState>(rootState == null ? this.createDefaultRootState() : rootState);
        this.blockProperties = blockProperties == null ? ConfigBlockProperties.builder().build() : blockProperties;
        this.itemProperties = itemProperties == null ? ConfigItemProperties.builder().build() : itemProperties;
        this.machineSettingsFactory = machineSettingsFactory == null ? () -> ConfigMachineSettings.builder().build() : machineSettingsFactory;
        ConfigRecipeLogicSettings configRecipeLogicSettings = this.recipeLogicSettings = recipeLogicSettings == null ? ConfigRecipeLogicSettings.builder().build() : recipeLogicSettings;
        this.partSettingsFactory = this.allowPartSettings() ? (partSettingsFactory == null ? () -> ConfigPartSettings.builder().build() : partSettingsFactory) : null;
        this.machineEvents = this.createMachineEvents();
    }

    public boolean allowPartSettings() {
        return true;
    }

    public ConfigMachineEvents createMachineEvents() {
        return new ConfigMachineEvents().registerEventGroup("MachineEvent");
    }

    public MachineState createDefaultRootState() {
        return StateMachine.createDefault(MachineState::builder);
    }

    public void loadFactory() {
        this.machineSettings = (ConfigMachineSettings)this.machineSettingsFactory.get();
        if (this.partSettingsFactory != null) {
            this.partSettings = (ConfigPartSettings)this.partSettingsFactory.get();
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static MBDMachineDefinition createDefault() {
        return new MBDMachineDefinition(MBD2.id("dummy"), (MachineState)StateMachine.createDefault(MachineState::builder), ConfigBlockProperties.builder().build(), ConfigItemProperties.builder().build(), () -> ConfigMachineSettings.builder().build(), ConfigRecipeLogicSettings.builder().build(), () -> ConfigPartSettings.builder().build());
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = super.serializeNBT();
        tag.m_128365_("stateMachine", (Tag)this.stateMachine.serializeNBT());
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        super.deserializeNBT(tag);
        this.stateMachine.deserializeNBT(tag.m_128469_("stateMachine"));
        if (!tag.m_128441_("recipeLogicSettings")) {
            this.recipeLogicSettings.deserializeNBT(tag.m_128469_("machineSettings"));
        }
    }

    public MBDMachineDefinition loadProductiveTag(@Nullable File file, CompoundTag projectTag, Deque<Runnable> postTask) {
        this.projectFile = file;
        IRendererResource rendererResource = new IRendererResource();
        rendererResource.deserializeNBT(projectTag.m_128469_("resources").m_128469_("ldlib.gui.editor.group.renderer"));
        UIResourceRenderer.setCurrentResource((Resource)rendererResource, (boolean)false);
        CompoundTag definitionTag = projectTag.m_128469_("definition");
        this.id = new ResourceLocation(definitionTag.m_128461_("id"));
        this.blockProperties.deserializeNBT(definitionTag.m_128469_("blockProperties"));
        this.itemProperties.deserializeNBT(definitionTag.m_128469_("itemProperties"));
        this.stateMachine.deserializeNBT(definitionTag.m_128469_("stateMachine"));
        UIResourceRenderer.clearCurrentResource();
        postTask.add(() -> {
            this.machineSettings.deserializeNBT(definitionTag.m_128469_("machineSettings"));
            if (definitionTag.m_128441_("recipeLogicSettings")) {
                this.recipeLogicSettings.deserializeNBT(definitionTag.m_128469_("recipeLogicSettings"));
            } else {
                CompoundTag tag = definitionTag.m_128469_("machineSettings");
                this.recipeLogicSettings.deserializeNBT(tag);
                this.recipeLogicSettings.setEnable(tag.m_128471_("hasRecipeLogic"));
            }
            if (this.partSettings != null) {
                this.partSettings.deserializeNBT(definitionTag.m_128469_("partSettings"));
            }
            this.machineEvents.deserializeNBT(definitionTag.m_128469_("machineEvents"));
            if (this.machineSettings().hasUI()) {
                TexturesResource texturesResource = new TexturesResource();
                texturesResource.deserializeNBT(projectTag.m_128469_("resources").m_128469_("ldlib.gui.editor.group.textures"));
                CompoundTag uiTag = projectTag.m_128469_("ui");
                this.uiCreator = machine -> {
                    WidgetGroup machineUI = new WidgetGroup();
                    IConfigurableWidget.deserializeNBT((IConfigurableWidget)machineUI, (CompoundTag)uiTag, (Resource)texturesResource, (boolean)false);
                    this.bindMachineUI((MBDMachine)machine, machineUI);
                    return machineUI;
                };
            }
        });
        return this;
    }

    public boolean isCreatedFromProjectFile() {
        return this.projectFile != null;
    }

    public void reloadFromProjectFile() {
        if (this.projectFile != null) {
            try {
                CompoundTag tag = NbtIo.m_128953_((File)this.projectFile);
                if (tag != null) {
                    ArrayDeque postTask = Queues.newArrayDeque();
                    this.loadProductiveTag(this.projectFile, tag, postTask);
                    postTask.forEach(Runnable::run);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected void bindMachineUI(MBDMachine machine, WidgetGroup ui) {
        WidgetUtils.widgetByIdForEach(ui, "^ui:progress_bar$", ProgressWidget.class, progressWidget -> progressWidget.setProgressSupplier(() -> machine.getRecipeLogic().getProgressPercent()));
        WidgetUtils.widgetByIdForEach(ui, "^ui:fuel_bar$", ProgressWidget.class, progressWidget -> progressWidget.setProgressSupplier(() -> machine.getRecipeLogic().getFuelProgressPercent()));
        WidgetUtils.widgetByIdForEach(ui, "^ui:xei_lookup$", ButtonWidget.class, buttonWidget -> buttonWidget.setOnPressCallback(cd -> {
            MBDRecipeType recipeType;
            if (cd.isRemote && (LDLib.isReiLoaded() || LDLib.isJeiLoaded() || LDLib.isEmiLoaded()) && Editor.INSTANCE == null && (recipeType = machine.getRecipeType()) != MBDRecipeType.DUMMY && recipeType.isXEIVisible()) {
                if (LDLib.isReiLoaded()) {
                    ViewSearchBuilder.builder().addCategory(MBDRecipeTypeDisplayCategory.CATEGORIES.apply(recipeType)).open();
                } else if (LDLib.isJeiLoaded()) {
                    JEIPlugin.jeiRuntime.getRecipesGui().showTypes(List.of(MBDRecipeTypeCategory.TYPES.apply(recipeType)));
                } else if (LDLib.isEmiLoaded()) {
                    EmiApi.displayRecipeCategory((EmiRecipeCategory)MBDRecipeTypeEmiCategory.CATEGORIES.apply(recipeType));
                }
            }
        }));
        for (TraitDefinition traitDefinition : this.machineSettings.traitDefinitions()) {
            if (!(traitDefinition instanceof IUIProviderTrait)) continue;
            IUIProviderTrait provider = (IUIProviderTrait)((Object)traitDefinition);
            ITrait trait = machine.getTraitByDefinition(traitDefinition);
            if (trait == null) continue;
            provider.initTraitUI(trait, ui);
        }
    }

    public void onRegistry(RegisterEvent event) {
        event.register(ForgeRegistries.BLOCKS.getRegistryKey(), helper -> {
            MBDMachineDefinition.set(this);
            this.block = this.createBlock();
            helper.register(this.id, (Object)this.block);
            MBDMachineDefinition.clear();
        });
        event.register(ForgeRegistries.ITEMS.getRegistryKey(), helper -> {
            this.item = this.createItem(this.block);
            helper.register(this.id, (Object)this.item);
        });
        event.register(ForgeRegistries.BLOCK_ENTITY_TYPES.getRegistryKey(), helper -> {
            this.blockEntityType = BlockEntityType.Builder.m_155273_(this::createBlockEntity, (Block[])new Block[]{this.block}).m_58966_(null);
            helper.register(this.id, (Object)this.blockEntityType);
        });
    }

    public Block createBlock() {
        return new MBDMachineBlock(this.blockProperties.apply(this.stateMachine, BlockBehaviour.Properties.m_284310_()), this);
    }

    public Item createItem(Block block) {
        return new MBDMachineItem((MBDMachineBlock)block, this.itemProperties.apply(new Item.Properties()));
    }

    public BlockEntity createBlockEntity(BlockPos pos, BlockState state) {
        return new MachineBlockEntity(this.blockEntityType(), pos, state, this::createMachine);
    }

    public MBDMachine createMachine(IMachineBlockEntity blockEntity) {
        return this.partSettings != null ? new MBDPartMachine(blockEntity, this, new Object[0]) : new MBDMachine(blockEntity, this, new Object[0]);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initRenderer(EntityRenderersEvent.RegisterRenderers event) {
        this.blockRenderer = this.createBlockRenderer();
        this.itemRenderer = this.createItemRenderer();
        event.registerBlockEntityRenderer(this.blockEntityType, this.createBESRR());
        ItemBlockRenderTypes.setRenderLayer((Block)this.block(), renderType -> {
            if (renderType == RenderType.m_110466_()) {
                return this.blockProperties.renderTypes().translucent();
            }
            if (renderType == RenderType.m_110463_()) {
                return this.blockProperties.renderTypes().cutout();
            }
            if (renderType == RenderType.m_110457_()) {
                return this.blockProperties.renderTypes().cutoutMipped();
            }
            if (renderType == RenderType.m_110451_()) {
                return this.blockProperties.renderTypes().solid();
            }
            return false;
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public IRenderer createBlockRenderer() {
        return new MBDBlockRenderer(this.blockProperties::useAO, () -> ((MachineState)this.stateMachine.getRootState()).getRealRenderer());
    }

    @OnlyIn(value=Dist.CLIENT)
    public IRenderer createItemRenderer() {
        return new MBDItemRenderer(this.itemProperties::useBlockLight, this.itemProperties::isGui3d, () -> this.itemProperties.renderer().isEnable() ? this.itemProperties.renderer().getValue() : ((MachineState)this.stateMachine.getRootState()).getRealRenderer());
    }

    @OnlyIn(value=Dist.CLIENT)
    public BlockEntityRendererProvider<BlockEntity> createBESRR() {
        return MBDBESRenderer::getOrCreate;
    }

    public MachineState getState(String name) {
        return this.stateMachine.getState(name);
    }

    public String getDescriptionId() {
        return this.block().m_7705_();
    }

    public ItemStack asStack() {
        return new ItemStack((ItemLike)this.item());
    }

    public ItemStack asStack(int count) {
        return new ItemStack((ItemLike)this.item(), count);
    }

    public void appendHoverText(ItemStack stack, List<Component> tooltip) {
        tooltip.addAll(this.itemProperties().itemTooltips());
    }

    public ResourceLocation id() {
        return this.id;
    }

    public StateMachine<?> stateMachine() {
        return this.stateMachine;
    }

    public ConfigBlockProperties blockProperties() {
        return this.blockProperties;
    }

    public ConfigItemProperties itemProperties() {
        return this.itemProperties;
    }

    public ConfigMachineSettings machineSettings() {
        return this.machineSettings;
    }

    public ConfigRecipeLogicSettings recipeLogicSettings() {
        return this.recipeLogicSettings;
    }

    @Nullable
    public ConfigPartSettings partSettings() {
        return this.partSettings;
    }

    public ConfigMachineEvents machineEvents() {
        return this.machineEvents;
    }

    public ConfigMachineSettingsFactory machineSettingsFactory() {
        return this.machineSettingsFactory;
    }

    @Nullable
    public ConfigPartSettingsFactory partSettingsFactory() {
        return this.partSettingsFactory;
    }

    @Nullable
    public File projectFile() {
        return this.projectFile;
    }

    public Block block() {
        return this.block;
    }

    public Item item() {
        return this.item;
    }

    public BlockEntityType<?> blockEntityType() {
        return this.blockEntityType;
    }

    public IRenderer blockRenderer() {
        return this.blockRenderer;
    }

    public IRenderer itemRenderer() {
        return this.itemRenderer;
    }

    public Function<MBDMachine, WidgetGroup> uiCreator() {
        return this.uiCreator;
    }

    @FunctionalInterface
    public static interface ConfigMachineSettingsFactory
    extends Supplier<ConfigMachineSettings> {
    }

    @FunctionalInterface
    public static interface ConfigPartSettingsFactory
    extends Supplier<ConfigPartSettings> {
    }

    public static class Builder {
        protected ResourceLocation id;
        protected MachineState rootState;
        protected ConfigBlockProperties blockProperties;
        protected ConfigItemProperties itemProperties;
        protected ConfigMachineSettingsFactory machineSettings;
        protected ConfigRecipeLogicSettings recipeLogicSettings;
        @Nullable
        protected ConfigPartSettingsFactory partSettings;

        protected Builder() {
        }

        public MBDMachineDefinition build() {
            return new MBDMachineDefinition(this.id, this.rootState, this.blockProperties, this.itemProperties, this.machineSettings, this.recipeLogicSettings, this.partSettings);
        }

        public Builder id(ResourceLocation id) {
            this.id = id;
            return this;
        }

        public Builder rootState(MachineState rootState) {
            this.rootState = rootState;
            return this;
        }

        public Builder blockProperties(ConfigBlockProperties blockProperties) {
            this.blockProperties = blockProperties;
            return this;
        }

        public Builder itemProperties(ConfigItemProperties itemProperties) {
            this.itemProperties = itemProperties;
            return this;
        }

        public Builder machineSettings(ConfigMachineSettingsFactory machineSettings) {
            this.machineSettings = machineSettings;
            return this;
        }

        public Builder recipeLogicSettings(ConfigRecipeLogicSettings recipeLogicSettings) {
            this.recipeLogicSettings = recipeLogicSettings;
            return this;
        }

        public Builder partSettings(@Nullable ConfigPartSettingsFactory partSettings) {
            this.partSettings = partSettings;
            return this;
        }
    }
}

