/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common.machine.definition.config;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ArrayConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.configurator.Configurator;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurable;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IToggleConfigurable;
import com.lowdragmc.lowdraglib.gui.editor.ui.Editor;
import com.lowdragmc.lowdraglib.gui.widget.DialogWidget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.syncdata.IPersistedSerializable;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.mbd2.common.gui.editor.MachineEditor;
import com.lowdragmc.mbd2.common.gui.editor.MachineProject;
import com.lowdragmc.mbd2.common.gui.editor.machine.MachineConfigPanel;
import com.lowdragmc.mbd2.common.machine.definition.config.MachineState;
import com.lowdragmc.mbd2.common.machine.definition.config.RecipeModifier;
import com.lowdragmc.mbd2.common.trait.CapabilityIO;
import com.lowdragmc.mbd2.common.trait.ToggleAutoIO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class ConfigPartSettings
implements IToggleConfigurable,
IPersistedSerializable {
    @Persisted
    protected boolean enable;
    @Configurable(name="config.part_settings.can_share", tips={"config.part_settings.can_share.tooltip"})
    protected boolean canShare;
    protected final RecipeModifier.RecipeModifiers recipeModifiers;
    protected final List<ProxyCapability> proxyControllerCapabilities;

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        MachineProject project;
        MachineEditor machineEditor;
        Editor editor;
        if (enable && !this.enable && LDLib.isClient() && (editor = Editor.INSTANCE) instanceof MachineEditor && (editor = (machineEditor = (MachineEditor)editor).getCurrentProject()) instanceof MachineProject && !(project = (MachineProject)editor).getDefinition().stateMachine().hasState("formed")) {
            DialogWidget.showCheckBox((WidgetGroup)Editor.INSTANCE, (String)"config.part_settings.formed_tips", (String)"config.part_settings.formed_tips.info", result -> {
                if (result) {
                    Object state = project.getDefinition().stateMachine().getRootState();
                    MachineState newState = ((MachineState)state).addChild("formed");
                    machineEditor.getTabPages().tabs.values().stream().filter(MachineConfigPanel.class::isInstance).map(MachineConfigPanel.class::cast).findAny().ifPresent(panel -> panel.onStateAdded(newState));
                }
            });
        }
        this.enable = enable;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = super.serializeNBT();
        tag.m_128365_("recipeModifiers", (Tag)this.recipeModifiers.serializeNBT());
        ListTag proxyCapabilities = new ListTag();
        for (ProxyCapability proxyCapability : this.proxyControllerCapabilities) {
            proxyCapabilities.add((Object)proxyCapability.serializeNBT());
        }
        tag.m_128365_("proxyControllerCapabilities", (Tag)proxyCapabilities);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        super.deserializeNBT(tag);
        this.recipeModifiers.deserializeNBT(tag.m_128437_("recipeModifiers", 10));
        this.proxyControllerCapabilities.clear();
        ListTag proxyCapabilities = tag.m_128437_("proxyControllerCapabilities", 10);
        for (int i = 0; i < proxyCapabilities.size(); ++i) {
            ProxyCapability proxyCapability = new ProxyCapability();
            proxyCapability.deserializeNBT(proxyCapabilities.m_128728_(i));
            this.proxyControllerCapabilities.add(proxyCapability);
        }
    }

    public void buildConfigurator(ConfiguratorGroup father) {
        super.buildConfigurator(father);
        this.recipeModifiers.buildConfigurator(father);
        ArrayConfiguratorGroup proxyCapabilities = new ArrayConfiguratorGroup("config.part_settings.proxy_controller_capabilities", false, () -> this.proxyControllerCapabilities, (getter, setter) -> {
            ProxyCapability proxyCapability = (ProxyCapability)getter.get();
            ConfiguratorGroup group = new ConfiguratorGroup("config.part_settings.proxy_capability.trait_filter", false);
            proxyCapability.buildConfigurator(group);
            return group;
        }, true);
        proxyCapabilities.setTips(new String[]{"config.part_settings.proxy_controller_capabilities.tooltip"});
        proxyCapabilities.setAddDefault(ProxyCapability::new);
        proxyCapabilities.setOnAdd(this.proxyControllerCapabilities::add);
        proxyCapabilities.setOnRemove(this.proxyControllerCapabilities::remove);
        proxyCapabilities.setOnUpdate(list -> {
            this.proxyControllerCapabilities.clear();
            this.proxyControllerCapabilities.addAll((Collection<ProxyCapability>)list);
        });
        father.addConfigurators(new Configurator[]{proxyCapabilities});
    }

    private static boolean $default$canShare() {
        return true;
    }

    private static RecipeModifier.RecipeModifiers $default$recipeModifiers() {
        return new RecipeModifier.RecipeModifiers();
    }

    private static List<ProxyCapability> $default$proxyControllerCapabilities() {
        return new ArrayList<ProxyCapability>();
    }

    ConfigPartSettings(boolean enable, boolean canShare, RecipeModifier.RecipeModifiers recipeModifiers, List<ProxyCapability> proxyControllerCapabilities) {
        this.enable = enable;
        this.canShare = canShare;
        this.recipeModifiers = recipeModifiers;
        this.proxyControllerCapabilities = proxyControllerCapabilities;
    }

    public static ConfigPartSettingsBuilder builder() {
        return new ConfigPartSettingsBuilder();
    }

    public boolean canShare() {
        return this.canShare;
    }

    public RecipeModifier.RecipeModifiers recipeModifiers() {
        return this.recipeModifiers;
    }

    public List<ProxyCapability> proxyControllerCapabilities() {
        return this.proxyControllerCapabilities;
    }

    public boolean enable() {
        return this.enable;
    }

    public ConfigPartSettings enable(boolean enable) {
        this.enable = enable;
        return this;
    }

    public static class ProxyCapability
    implements IConfigurable,
    IPersistedSerializable {
        @Configurable(name="config.part_settings.proxy_capability.trait_name_filter", tips={"config.part_settings.proxy_capability.trait_name_filter.tooltip.0", "config.part_settings.proxy_capability.trait_name_filter.tooltip.1"})
        private String traitNameFilter;
        @Configurable(name="config.definition.trait.capability_io", subConfigurable=true, tips={"config.definition.trait.capability_io.tooltip.0", "config.definition.trait.capability_io.tooltip.1"})
        private final CapabilityIO capabilityIO = new CapabilityIO();
        @Configurable(name="config.definition.trait.auto_io", subConfigurable=true, tips={"config.definition.trait.auto_io.tooltip.0", "config.definition.trait.auto_io.tooltip.1"})
        private final ToggleAutoIO autoIO = new ToggleAutoIO();

        public String traitNameFilter() {
            return this.traitNameFilter;
        }

        public CapabilityIO capabilityIO() {
            return this.capabilityIO;
        }

        public ToggleAutoIO autoIO() {
            return this.autoIO;
        }
    }

    public static class ConfigPartSettingsBuilder {
        private boolean enable;
        private boolean canShare$set;
        private boolean canShare$value;
        private boolean recipeModifiers$set;
        private RecipeModifier.RecipeModifiers recipeModifiers$value;
        private boolean proxyControllerCapabilities$set;
        private List<ProxyCapability> proxyControllerCapabilities$value;

        ConfigPartSettingsBuilder() {
        }

        public ConfigPartSettingsBuilder enable(boolean enable) {
            this.enable = enable;
            return this;
        }

        public ConfigPartSettingsBuilder canShare(boolean canShare) {
            this.canShare$value = canShare;
            this.canShare$set = true;
            return this;
        }

        public ConfigPartSettingsBuilder recipeModifiers(RecipeModifier.RecipeModifiers recipeModifiers) {
            this.recipeModifiers$value = recipeModifiers;
            this.recipeModifiers$set = true;
            return this;
        }

        public ConfigPartSettingsBuilder proxyControllerCapabilities(List<ProxyCapability> proxyControllerCapabilities) {
            this.proxyControllerCapabilities$value = proxyControllerCapabilities;
            this.proxyControllerCapabilities$set = true;
            return this;
        }

        public ConfigPartSettings build() {
            boolean canShare$value = this.canShare$value;
            if (!this.canShare$set) {
                canShare$value = ConfigPartSettings.$default$canShare();
            }
            RecipeModifier.RecipeModifiers recipeModifiers$value = this.recipeModifiers$value;
            if (!this.recipeModifiers$set) {
                recipeModifiers$value = ConfigPartSettings.$default$recipeModifiers();
            }
            List<ProxyCapability> proxyControllerCapabilities$value = this.proxyControllerCapabilities$value;
            if (!this.proxyControllerCapabilities$set) {
                proxyControllerCapabilities$value = ConfigPartSettings.$default$proxyControllerCapabilities();
            }
            return new ConfigPartSettings(this.enable, canShare$value, recipeModifiers$value, proxyControllerCapabilities$value);
        }

        public String toString() {
            return "ConfigPartSettings.ConfigPartSettingsBuilder(enable=" + this.enable + ", canShare$value=" + this.canShare$value + ", recipeModifiers$value=" + String.valueOf(this.recipeModifiers$value) + ", proxyControllerCapabilities$value=" + String.valueOf(this.proxyControllerCapabilities$value) + ")";
        }
    }
}

