/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common.machine.definition.config;

import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberRange;
import com.lowdragmc.lowdraglib.gui.editor.configurator.Configurator;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IToggleConfigurable;
import com.lowdragmc.lowdraglib.gui.editor.configurator.SelectorConfigurator;
import com.lowdragmc.lowdraglib.syncdata.IPersistedSerializable;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.mbd2.MBD2;
import com.lowdragmc.mbd2.api.recipe.MBDRecipeType;
import com.lowdragmc.mbd2.api.registry.MBDRegistries;
import com.lowdragmc.mbd2.common.machine.definition.config.RecipeModifier;
import com.lowdragmc.mbd2.utils.FileUtils;
import java.io.File;
import java.util.HashSet;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;

public class ConfigRecipeLogicSettings
implements IToggleConfigurable,
IPersistedSerializable {
    private boolean enable;
    @Persisted
    private ResourceLocation recipeType;
    protected final RecipeModifier.RecipeModifiers recipeModifiers;
    @Configurable(name="config.recipe_logic_settings.recipe_damping_value", tips={"config.recipe_logic_settings.recipe_damping_value.tooltip"})
    @NumberRange(range={0.0, 2.147483647E9})
    protected int recipeDampingValue;
    @Configurable(name="config.recipe_logic_settings.always_search_recipe", tips={"config.recipe_logic_settings.always_search_recipe.tooltip.0", "config.recipe_logic_settings.always_search_recipe.tooltip.1"})
    protected boolean alwaysSearchRecipe;
    @Configurable(name="config.recipe_logic_settings.always_modify_recipe", tips={"config.recipe_logic_settings.always_modify_recipe.tooltip.0", "config.recipe_logic_settings.always_modify_recipe.tooltip.1"})
    protected boolean alwaysModifyRecipe;

    public MBDRecipeType getRecipeType() {
        return MBDRegistries.RECIPE_TYPES.getOrDefault(this.recipeType, MBDRecipeType.DUMMY);
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = super.serializeNBT();
        tag.m_128365_("recipeModifiers", (Tag)this.recipeModifiers.serializeNBT());
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        super.deserializeNBT(tag);
        this.recipeModifiers.deserializeNBT(tag.m_128437_("recipeModifiers", 10));
    }

    public void buildConfigurator(ConfiguratorGroup father) {
        super.buildConfigurator(father);
        HashSet<Object> candidates = new HashSet<Object>();
        candidates.add(MBDRecipeType.DUMMY.getRegistryName());
        candidates.addAll(MBDRegistries.RECIPE_TYPES.keys());
        File path = new File(MBD2.getLocation(), "recipe_type");
        FileUtils.loadNBTFiles(path, ".rt", (file, tag) -> {
            String recipeType = tag.m_128469_("recipe_type").m_128461_("registryName");
            if (!recipeType.isEmpty() && ResourceLocation.m_135830_((String)recipeType)) {
                candidates.add(new ResourceLocation(recipeType));
            }
        });
        father.addConfigurators(new Configurator[]{new SelectorConfigurator("editor.machine.recipe_type", () -> this.recipeType, type -> {
            this.recipeType = type;
        }, (Object)MBDRecipeType.DUMMY.getRegistryName(), true, candidates.stream().toList(), ResourceLocation::toString)});
        this.recipeModifiers.buildConfigurator(father);
    }

    private static boolean $default$enable() {
        return true;
    }

    private static ResourceLocation $default$recipeType() {
        return MBDRecipeType.DUMMY.getRegistryName();
    }

    private static RecipeModifier.RecipeModifiers $default$recipeModifiers() {
        return new RecipeModifier.RecipeModifiers();
    }

    private static int $default$recipeDampingValue() {
        return 2;
    }

    private static boolean $default$alwaysSearchRecipe() {
        return false;
    }

    private static boolean $default$alwaysModifyRecipe() {
        return false;
    }

    ConfigRecipeLogicSettings(boolean enable, ResourceLocation recipeType, RecipeModifier.RecipeModifiers recipeModifiers, int recipeDampingValue, boolean alwaysSearchRecipe, boolean alwaysModifyRecipe) {
        this.enable = enable;
        this.recipeType = recipeType;
        this.recipeModifiers = recipeModifiers;
        this.recipeDampingValue = recipeDampingValue;
        this.alwaysSearchRecipe = alwaysSearchRecipe;
        this.alwaysModifyRecipe = alwaysModifyRecipe;
    }

    public static ConfigRecipeLogicSettingsBuilder builder() {
        return new ConfigRecipeLogicSettingsBuilder();
    }

    public boolean isEnable() {
        return this.enable;
    }

    public ResourceLocation recipeType() {
        return this.recipeType;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public RecipeModifier.RecipeModifiers recipeModifiers() {
        return this.recipeModifiers;
    }

    public int recipeDampingValue() {
        return this.recipeDampingValue;
    }

    public boolean alwaysSearchRecipe() {
        return this.alwaysSearchRecipe;
    }

    public boolean alwaysModifyRecipe() {
        return this.alwaysModifyRecipe;
    }

    public static class ConfigRecipeLogicSettingsBuilder {
        private boolean enable$set;
        private boolean enable$value;
        private boolean recipeType$set;
        private ResourceLocation recipeType$value;
        private boolean recipeModifiers$set;
        private RecipeModifier.RecipeModifiers recipeModifiers$value;
        private boolean recipeDampingValue$set;
        private int recipeDampingValue$value;
        private boolean alwaysSearchRecipe$set;
        private boolean alwaysSearchRecipe$value;
        private boolean alwaysModifyRecipe$set;
        private boolean alwaysModifyRecipe$value;

        ConfigRecipeLogicSettingsBuilder() {
        }

        public ConfigRecipeLogicSettingsBuilder enable(boolean enable) {
            this.enable$value = enable;
            this.enable$set = true;
            return this;
        }

        public ConfigRecipeLogicSettingsBuilder recipeType(ResourceLocation recipeType) {
            this.recipeType$value = recipeType;
            this.recipeType$set = true;
            return this;
        }

        public ConfigRecipeLogicSettingsBuilder recipeModifiers(RecipeModifier.RecipeModifiers recipeModifiers) {
            this.recipeModifiers$value = recipeModifiers;
            this.recipeModifiers$set = true;
            return this;
        }

        public ConfigRecipeLogicSettingsBuilder recipeDampingValue(int recipeDampingValue) {
            this.recipeDampingValue$value = recipeDampingValue;
            this.recipeDampingValue$set = true;
            return this;
        }

        public ConfigRecipeLogicSettingsBuilder alwaysSearchRecipe(boolean alwaysSearchRecipe) {
            this.alwaysSearchRecipe$value = alwaysSearchRecipe;
            this.alwaysSearchRecipe$set = true;
            return this;
        }

        public ConfigRecipeLogicSettingsBuilder alwaysModifyRecipe(boolean alwaysModifyRecipe) {
            this.alwaysModifyRecipe$value = alwaysModifyRecipe;
            this.alwaysModifyRecipe$set = true;
            return this;
        }

        public ConfigRecipeLogicSettings build() {
            boolean enable$value = this.enable$value;
            if (!this.enable$set) {
                enable$value = ConfigRecipeLogicSettings.$default$enable();
            }
            ResourceLocation recipeType$value = this.recipeType$value;
            if (!this.recipeType$set) {
                recipeType$value = ConfigRecipeLogicSettings.$default$recipeType();
            }
            RecipeModifier.RecipeModifiers recipeModifiers$value = this.recipeModifiers$value;
            if (!this.recipeModifiers$set) {
                recipeModifiers$value = ConfigRecipeLogicSettings.$default$recipeModifiers();
            }
            int recipeDampingValue$value = this.recipeDampingValue$value;
            if (!this.recipeDampingValue$set) {
                recipeDampingValue$value = ConfigRecipeLogicSettings.$default$recipeDampingValue();
            }
            boolean alwaysSearchRecipe$value = this.alwaysSearchRecipe$value;
            if (!this.alwaysSearchRecipe$set) {
                alwaysSearchRecipe$value = ConfigRecipeLogicSettings.$default$alwaysSearchRecipe();
            }
            boolean alwaysModifyRecipe$value = this.alwaysModifyRecipe$value;
            if (!this.alwaysModifyRecipe$set) {
                alwaysModifyRecipe$value = ConfigRecipeLogicSettings.$default$alwaysModifyRecipe();
            }
            return new ConfigRecipeLogicSettings(enable$value, recipeType$value, recipeModifiers$value, recipeDampingValue$value, alwaysSearchRecipe$value, alwaysModifyRecipe$value);
        }

        public String toString() {
            return "ConfigRecipeLogicSettings.ConfigRecipeLogicSettingsBuilder(enable$value=" + this.enable$value + ", recipeType$value=" + String.valueOf(this.recipeType$value) + ", recipeModifiers$value=" + String.valueOf(this.recipeModifiers$value) + ", recipeDampingValue$value=" + this.recipeDampingValue$value + ", alwaysSearchRecipe$value=" + this.alwaysSearchRecipe$value + ", alwaysModifyRecipe$value=" + this.alwaysModifyRecipe$value + ")";
        }
    }
}

