/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common.recipe;

import com.google.gson.JsonObject;
import com.lowdragmc.lowdraglib.gui.editor.configurator.Configurator;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.configurator.SelectorConfigurator;
import com.lowdragmc.lowdraglib.utils.LocalizationUtils;
import com.lowdragmc.mbd2.api.recipe.MBDRecipe;
import com.lowdragmc.mbd2.api.recipe.RecipeCondition;
import com.lowdragmc.mbd2.api.recipe.RecipeLogic;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.Level;

public class BiomeCondition
extends RecipeCondition {
    public static final BiomeCondition INSTANCE = new BiomeCondition();
    private ResourceLocation biome = new ResourceLocation("dummy");

    public BiomeCondition(ResourceLocation biome) {
        this.biome = biome;
    }

    @Override
    public String getType() {
        return "biome";
    }

    @Override
    public Component getTooltips() {
        return Component.m_237110_((String)"recipe.condition.biome.tooltip", (Object[])new Object[]{LocalizationUtils.format((String)"biome.%s.%s", (Object[])new Object[]{this.biome.m_135827_(), this.biome.m_135815_()})});
    }

    @Override
    public boolean test(@Nonnull MBDRecipe recipe, @Nonnull RecipeLogic recipeLogic) {
        Level level = recipeLogic.machine.getLevel();
        if (level == null) {
            return false;
        }
        Holder biome = level.m_204166_(recipeLogic.machine.getPos());
        return biome.m_203373_(this.biome);
    }

    @Override
    @Nonnull
    public JsonObject serialize() {
        JsonObject config = super.serialize();
        config.addProperty("biome", this.biome.toString());
        return config;
    }

    @Override
    public RecipeCondition deserialize(@Nonnull JsonObject config) {
        super.deserialize(config);
        this.biome = new ResourceLocation(GsonHelper.m_13851_((JsonObject)config, (String)"biome", (String)"dummy"));
        return this;
    }

    @Override
    public RecipeCondition fromNetwork(FriendlyByteBuf buf) {
        super.fromNetwork(buf);
        this.biome = new ResourceLocation(buf.m_130277_());
        return this;
    }

    @Override
    public void toNetwork(FriendlyByteBuf buf) {
        super.toNetwork(buf);
        buf.m_130070_(this.biome.toString());
    }

    @Override
    public CompoundTag toNBT() {
        CompoundTag tag = super.toNBT();
        tag.m_128359_("biome", this.biome.toString());
        return tag;
    }

    @Override
    public RecipeCondition fromNBT(CompoundTag tag) {
        super.fromNBT(tag);
        this.biome = new ResourceLocation(tag.m_128461_("biome"));
        return this;
    }

    public void buildConfigurator(ConfiguratorGroup father) {
        super.buildConfigurator(father);
        SelectorConfigurator selector = new SelectorConfigurator(this.getTranslationKey(), () -> this.biome, b -> {
            this.biome = b;
        }, (Object)new ResourceLocation("dummy"), true, ((Registry)Minecraft.m_91087_().f_91073_.m_9598_().m_6632_(Registries.f_256952_).get()).m_6566_().stream().toList(), ResourceLocation::toString);
        selector.setUp(false);
        selector.setTips(new String[]{"config.recipe.condition.biome.tooltip"});
        father.addConfigurators(new Configurator[]{selector});
    }

    public ResourceLocation getBiome() {
        return this.biome;
    }

    public void setBiome(ResourceLocation biome) {
        this.biome = biome;
    }

    public BiomeCondition() {
    }
}

