/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common.recipe;

import com.google.gson.JsonObject;
import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ItemStackTexture;
import com.lowdragmc.mbd2.api.recipe.MBDRecipe;
import com.lowdragmc.mbd2.api.recipe.RecipeCondition;
import com.lowdragmc.mbd2.api.recipe.RecipeLogic;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;

public class DayLightCondition
extends RecipeCondition {
    public static final DayLightCondition INSTANCE = new DayLightCondition();
    @Configurable(name="config.recipe.condition.day_light.is_day")
    private boolean isDay;

    public DayLightCondition(boolean isDay) {
        this.isDay = isDay;
    }

    @Override
    public String getType() {
        return "day_light";
    }

    @Override
    public Component getTooltips() {
        return this.isDay ? Component.m_237115_((String)"recipe.condition.day_light.tooltip.true") : Component.m_237115_((String)"recipe.condition.day_light.tooltip.false");
    }

    @Override
    public IGuiTexture getIcon() {
        return new ItemStackTexture(new Item[]{Items.f_42152_});
    }

    @Override
    public boolean test(@Nonnull MBDRecipe recipe, @Nonnull RecipeLogic recipeLogic) {
        Level level = recipeLogic.machine.getLevel();
        return level != null && level.m_46461_() == this.isDay;
    }

    @Override
    @Nonnull
    public JsonObject serialize() {
        JsonObject config = super.serialize();
        config.addProperty("isDay", Boolean.valueOf(this.isDay));
        return config;
    }

    @Override
    public RecipeCondition deserialize(@Nonnull JsonObject config) {
        super.deserialize(config);
        this.isDay = GsonHelper.m_13855_((JsonObject)config, (String)"isDay", (boolean)false);
        return this;
    }

    @Override
    public RecipeCondition fromNetwork(FriendlyByteBuf buf) {
        super.fromNetwork(buf);
        this.isDay = buf.readBoolean();
        return this;
    }

    @Override
    public void toNetwork(FriendlyByteBuf buf) {
        super.toNetwork(buf);
        buf.writeBoolean(this.isDay);
    }

    @Override
    public CompoundTag toNBT() {
        CompoundTag tag = super.toNBT();
        tag.m_128379_("isDay", this.isDay);
        return tag;
    }

    @Override
    public RecipeCondition fromNBT(CompoundTag tag) {
        super.fromNBT(tag);
        this.isDay = tag.m_128471_("isDay");
        return this;
    }

    public boolean isDay() {
        return this.isDay;
    }

    public void setDay(boolean isDay) {
        this.isDay = isDay;
    }

    public DayLightCondition() {
    }
}

