/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.utils.NBTToJsonConverter;
import com.lowdragmc.mbd2.api.machine.IMachine;
import com.lowdragmc.mbd2.api.recipe.MBDRecipe;
import com.lowdragmc.mbd2.api.recipe.RecipeCondition;
import com.lowdragmc.mbd2.api.recipe.RecipeLogic;
import com.lowdragmc.mbd2.common.machine.MBDMachine;
import com.mojang.realmsclient.util.JsonUtils;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraftforge.common.crafting.CraftingHelper;

public class MachineNBTCondition
extends RecipeCondition {
    public static final MachineNBTCondition INSTANCE = new MachineNBTCondition();
    @Configurable(name="config.recipe.condition.machine_custom_data.data", tips={"config.recipe.condition.machine_custom_data.data.tips"})
    private CompoundTag data = new CompoundTag();
    @Configurable(name="config.recipe.condition.machine_custom_data.only_check_custom_data", tips={"config.recipe.condition.machine_custom_data.only_check_custom_data.tips.0", "config.recipe.condition.machine_custom_data.only_check_custom_data.tips.1"})
    private boolean onlyCheckCustomData = true;

    public MachineNBTCondition(CompoundTag data, boolean onlyCheckCustomData) {
        this.data = data;
    }

    @Override
    public String getType() {
        return "machine_custom_data";
    }

    @Override
    public Component getTooltips() {
        return Component.m_237110_((String)"recipe.condition.machine_custom_data.tooltip", (Object[])new Object[]{this.data});
    }

    @Override
    public IGuiTexture getIcon() {
        return new TextTexture("D");
    }

    @Override
    public boolean test(@Nonnull MBDRecipe recipe, @Nonnull RecipeLogic recipeLogic) {
        IMachine iMachine;
        if (!this.data.m_128456_() && (iMachine = recipeLogic.getMachine()) instanceof MBDMachine) {
            MBDMachine mbdMachine = (MBDMachine)iMachine;
            CompoundTag machineData = this.onlyCheckCustomData ? mbdMachine.getCustomData() : mbdMachine.getHolder().m_187481_();
            CompoundTag copied = machineData.m_6426_();
            copied.m_128391_(this.data);
            return copied.equals((Object)machineData);
        }
        return this.data.m_128456_();
    }

    @Override
    @Nonnull
    public JsonObject serialize() {
        JsonObject config = super.serialize();
        config.add("data", NBTToJsonConverter.getObject((Tag)this.data));
        config.addProperty("onlyCheckCustomData", Boolean.valueOf(this.onlyCheckCustomData));
        return config;
    }

    @Override
    public RecipeCondition deserialize(@Nonnull JsonObject config) {
        super.deserialize(config);
        this.data = CraftingHelper.getNBT((JsonElement)config.getAsJsonObject("data"));
        this.onlyCheckCustomData = JsonUtils.m_90165_((String)"onlyCheckCustomData", (JsonObject)config, (boolean)true);
        return this;
    }

    @Override
    public RecipeCondition fromNetwork(FriendlyByteBuf buf) {
        super.fromNetwork(buf);
        this.data = buf.m_130260_();
        this.onlyCheckCustomData = buf.readBoolean();
        return this;
    }

    @Override
    public void toNetwork(FriendlyByteBuf buf) {
        super.toNetwork(buf);
        buf.m_130079_(this.data);
        buf.writeBoolean(this.onlyCheckCustomData);
    }

    @Override
    public CompoundTag toNBT() {
        CompoundTag tag = super.toNBT();
        tag.m_128365_("data", (Tag)this.data);
        tag.m_128379_("onlyCheckCustomData", this.onlyCheckCustomData);
        return tag;
    }

    @Override
    public RecipeCondition fromNBT(CompoundTag tag) {
        super.fromNBT(tag);
        this.data = tag.m_128469_("data");
        this.onlyCheckCustomData = !tag.m_128441_("onlyCheckCustomData") || tag.m_128471_("onlyCheckCustomData");
        return this;
    }

    public CompoundTag getData() {
        return this.data;
    }

    public boolean isOnlyCheckCustomData() {
        return this.onlyCheckCustomData;
    }

    public void setData(CompoundTag data) {
        this.data = data;
    }

    public void setOnlyCheckCustomData(boolean onlyCheckCustomData) {
        this.onlyCheckCustomData = onlyCheckCustomData;
    }

    public MachineNBTCondition() {
    }
}

