/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common.recipe;

import com.google.gson.JsonObject;
import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberRange;
import com.lowdragmc.mbd2.api.recipe.MBDRecipe;
import com.lowdragmc.mbd2.api.recipe.RecipeCondition;
import com.lowdragmc.mbd2.api.recipe.RecipeLogic;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.Level;

public class RainingCondition
extends RecipeCondition {
    public static final RainingCondition INSTANCE = new RainingCondition();
    @Configurable(name="config.recipe.condition.weather.min")
    @NumberRange(range={0.0, 1.0})
    private float minLevel;
    @Configurable(name="config.recipe.condition.weather.max")
    @NumberRange(range={0.0, 1.0})
    private float maxLevel;

    public RainingCondition(float minLevel, float maxLevel) {
        this.minLevel = minLevel;
        this.maxLevel = maxLevel;
    }

    @Override
    public String getType() {
        return "rain";
    }

    @Override
    public Component getTooltips() {
        return Component.m_237110_((String)"recipe.condition.rain.tooltip", (Object[])new Object[]{Float.valueOf(this.minLevel), Float.valueOf(this.maxLevel)});
    }

    @Override
    public boolean test(@Nonnull MBDRecipe recipe, @Nonnull RecipeLogic recipeLogic) {
        Level level = recipeLogic.machine.getLevel();
        return level != null && level.m_46722_(1.0f) >= this.minLevel && level.m_46722_(1.0f) <= this.maxLevel;
    }

    @Override
    @Nonnull
    public JsonObject serialize() {
        JsonObject config = super.serialize();
        config.addProperty("minLevel", (Number)Float.valueOf(this.minLevel));
        config.addProperty("maxLevel", (Number)Float.valueOf(this.maxLevel));
        return config;
    }

    @Override
    public RecipeCondition deserialize(@Nonnull JsonObject config) {
        super.deserialize(config);
        this.minLevel = GsonHelper.m_13820_((JsonObject)config, (String)"minLevel", (float)0.0f);
        this.maxLevel = GsonHelper.m_13820_((JsonObject)config, (String)"maxLevel", (float)1.0f);
        return this;
    }

    @Override
    public RecipeCondition fromNetwork(FriendlyByteBuf buf) {
        super.fromNetwork(buf);
        this.minLevel = buf.readFloat();
        this.maxLevel = buf.readFloat();
        return this;
    }

    @Override
    public void toNetwork(FriendlyByteBuf buf) {
        super.toNetwork(buf);
        buf.writeFloat(this.minLevel);
        buf.writeFloat(this.maxLevel);
    }

    @Override
    public CompoundTag toNBT() {
        CompoundTag tag = super.toNBT();
        tag.m_128350_("minLevel", this.minLevel);
        tag.m_128350_("maxLevel", this.maxLevel);
        return tag;
    }

    @Override
    public RecipeCondition fromNBT(CompoundTag tag) {
        super.fromNBT(tag);
        this.minLevel = tag.m_128457_("minLevel");
        this.maxLevel = tag.m_128457_("maxLevel");
        return this;
    }

    public float getMinLevel() {
        return this.minLevel;
    }

    public float getMaxLevel() {
        return this.maxLevel;
    }

    public void setMinLevel(float minLevel) {
        this.minLevel = minLevel;
    }

    public void setMaxLevel(float maxLevel) {
        this.maxLevel = maxLevel;
    }

    public RainingCondition() {
    }
}

