/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common.trait.forgeenergy;

import com.lowdragmc.mbd2.api.capability.recipe.IO;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyStorageWrapper
implements IEnergyStorage {
    private final IEnergyStorage storage;
    private final IO io;
    private final int maxReceive;
    private final int maxExtract;

    public EnergyStorageWrapper(IEnergyStorage storage, IO io, int maxReceive, int maxExtract) {
        this.storage = storage;
        this.io = io;
        this.maxReceive = maxReceive;
        this.maxExtract = maxExtract;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (this.io == IO.IN || this.io == IO.BOTH) {
            return this.storage.receiveEnergy(Math.min(this.maxReceive, maxReceive), simulate);
        }
        return 0;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        if (this.io == IO.OUT || this.io == IO.BOTH) {
            return this.storage.extractEnergy(Math.min(this.maxExtract, maxExtract), simulate);
        }
        return 0;
    }

    public int getEnergyStored() {
        return this.storage.getEnergyStored();
    }

    public int getMaxEnergyStored() {
        return this.storage.getMaxEnergyStored();
    }

    public boolean canExtract() {
        return this.io == IO.OUT || this.io == IO.BOTH;
    }

    public boolean canReceive() {
        return this.io == IO.IN || this.io == IO.BOTH;
    }
}

