/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common.trait.forgeenergy;

import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import com.lowdragmc.mbd2.api.capability.recipe.IO;
import com.lowdragmc.mbd2.api.capability.recipe.IRecipeHandlerTrait;
import com.lowdragmc.mbd2.api.recipe.MBDRecipe;
import com.lowdragmc.mbd2.common.capability.recipe.ForgeEnergyRecipeCapability;
import com.lowdragmc.mbd2.common.machine.MBDMachine;
import com.lowdragmc.mbd2.common.trait.AutoIO;
import com.lowdragmc.mbd2.common.trait.IAutoIOTrait;
import com.lowdragmc.mbd2.common.trait.ICapabilityProviderTrait;
import com.lowdragmc.mbd2.common.trait.RecipeHandlerTrait;
import com.lowdragmc.mbd2.common.trait.SimpleCapabilityTrait;
import com.lowdragmc.mbd2.common.trait.forgeenergy.CopiableEnergyStorage;
import com.lowdragmc.mbd2.common.trait.forgeenergy.EnergyStorageList;
import com.lowdragmc.mbd2.common.trait.forgeenergy.EnergyStorageWrapper;
import com.lowdragmc.mbd2.common.trait.forgeenergy.ForgeEnergyCapabilityTraitDefinition;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.Nullable;

public class ForgeEnergyCapabilityTrait
extends SimpleCapabilityTrait
implements IAutoIOTrait {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(ForgeEnergyCapabilityTrait.class);
    @Persisted
    @DescSynced
    public final CopiableEnergyStorage storage;
    private final ForgeEnergyRecipeHandler recipeHandler = new ForgeEnergyRecipeHandler();
    private final EnergyStorageCap energyStorageCap = new EnergyStorageCap();

    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    public ForgeEnergyCapabilityTrait(MBDMachine machine, ForgeEnergyCapabilityTraitDefinition definition) {
        super(machine, definition);
        this.storage = this.createStorages();
        this.storage.setOnContentsChanged(this::notifyListeners);
    }

    @Override
    public ForgeEnergyCapabilityTraitDefinition getDefinition() {
        return (ForgeEnergyCapabilityTraitDefinition)super.getDefinition();
    }

    @Override
    public void onLoadingTraitInPreview() {
        this.storage.receiveEnergy(this.getDefinition().getCapacity() / 2, false);
    }

    protected CopiableEnergyStorage createStorages() {
        return new CopiableEnergyStorage(this.getDefinition().getCapacity());
    }

    @Override
    public List<IRecipeHandlerTrait<?>> getRecipeHandlerTraits() {
        return List.of(this.recipeHandler);
    }

    @Override
    public List<ICapabilityProviderTrait<?>> getCapabilityProviderTraits() {
        return List.of(this.energyStorageCap);
    }

    @Override
    @Nullable
    public AutoIO getAutoIO() {
        return this.getDefinition().getAutoIO().isEnable() ? this.getDefinition().getAutoIO() : null;
    }

    @Override
    public void handleAutoIO(BlockPos port, Direction side, IO io) {
        if (io == IO.IN) {
            Optional.ofNullable(this.getMachine().getLevel().m_7702_(port.m_121945_(side))).flatMap(be -> be.getCapability(ForgeCapabilities.ENERGY, side.m_122424_()).resolve()).ifPresent(source -> source.extractEnergy(this.storage.receiveEnergy(source.extractEnergy(this.getDefinition().getMaxReceive(), true), false), false));
        } else {
            Optional.ofNullable(this.getMachine().getLevel().m_7702_(port.m_121945_(side))).flatMap(be -> be.getCapability(ForgeCapabilities.ENERGY, side.m_122424_()).resolve()).ifPresent(target -> target.receiveEnergy(this.storage.extractEnergy(target.receiveEnergy(this.getDefinition().getMaxExtract(), true), false), false));
        }
    }

    public CopiableEnergyStorage getStorage() {
        return this.storage;
    }

    public ForgeEnergyRecipeHandler getRecipeHandler() {
        return this.recipeHandler;
    }

    public EnergyStorageCap getEnergyStorageCap() {
        return this.energyStorageCap;
    }

    public class ForgeEnergyRecipeHandler
    extends RecipeHandlerTrait<Integer> {
        protected ForgeEnergyRecipeHandler() {
            super(ForgeEnergyCapabilityTrait.this, ForgeEnergyRecipeCapability.CAP);
        }

        @Override
        public List<Integer> handleRecipeInner(IO io, MBDRecipe recipe, List<Integer> left, @Nullable String slotName, boolean simulate) {
            CopiableEnergyStorage capability;
            if (!this.compatibleWith(io)) {
                return left;
            }
            int required = left.stream().reduce(0, Integer::sum);
            CopiableEnergyStorage copiableEnergyStorage = capability = simulate ? ForgeEnergyCapabilityTrait.this.storage.copy() : ForgeEnergyCapabilityTrait.this.storage;
            if (io == IO.IN) {
                int extracted = capability.extractEnergy(required, simulate);
                required -= extracted;
            } else {
                int received = capability.receiveEnergy(required, simulate);
                required -= received;
            }
            return required > 0 ? List.of(Integer.valueOf(required)) : null;
        }
    }

    public class EnergyStorageCap
    implements ICapabilityProviderTrait<IEnergyStorage> {
        @Override
        public IO getCapabilityIO(@Nullable Direction side) {
            return ForgeEnergyCapabilityTrait.this.getCapabilityIO(side);
        }

        @Override
        public Capability<IEnergyStorage> getCapability() {
            return ForgeCapabilities.ENERGY;
        }

        @Override
        public IEnergyStorage getCapContent(IO capbilityIO) {
            return new EnergyStorageWrapper((IEnergyStorage)ForgeEnergyCapabilityTrait.this.storage, capbilityIO, ForgeEnergyCapabilityTrait.this.getDefinition().getMaxReceive(), ForgeEnergyCapabilityTrait.this.getDefinition().getMaxExtract());
        }

        @Override
        public IEnergyStorage mergeContents(List<IEnergyStorage> contents) {
            return new EnergyStorageList(contents.toArray(new IEnergyStorage[0]));
        }
    }
}

