/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common.trait.item;

import com.google.common.base.Predicates;
import com.lowdragmc.lowdraglib.misc.ItemStackTransfer;
import com.lowdragmc.lowdraglib.misc.ItemTransferList;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import com.lowdragmc.lowdraglib.side.item.forge.ItemTransferHelperImpl;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import com.lowdragmc.mbd2.api.capability.recipe.IO;
import com.lowdragmc.mbd2.api.capability.recipe.IRecipeHandlerTrait;
import com.lowdragmc.mbd2.api.recipe.MBDRecipe;
import com.lowdragmc.mbd2.common.capability.recipe.ItemDurabilityRecipeCapability;
import com.lowdragmc.mbd2.common.capability.recipe.ItemRecipeCapability;
import com.lowdragmc.mbd2.common.machine.MBDMachine;
import com.lowdragmc.mbd2.common.trait.AutoIO;
import com.lowdragmc.mbd2.common.trait.IAutoIOTrait;
import com.lowdragmc.mbd2.common.trait.ICapabilityProviderTrait;
import com.lowdragmc.mbd2.common.trait.RecipeHandlerTrait;
import com.lowdragmc.mbd2.common.trait.SimpleCapabilityTrait;
import com.lowdragmc.mbd2.common.trait.item.ItemHandlerList;
import com.lowdragmc.mbd2.common.trait.item.ItemHandlerWrapper;
import com.lowdragmc.mbd2.common.trait.item.ItemSlotCapabilityTraitDefinition;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class ItemSlotCapabilityTrait
extends SimpleCapabilityTrait
implements IAutoIOTrait {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(ItemSlotCapabilityTrait.class);
    private final Random random = new Random();
    @Persisted
    @DescSynced
    public final ItemStackTransfer storage;
    private Boolean isEmpty;
    private final ItemRecipeHandler itemRecipeHandler = new ItemRecipeHandler();
    private final ItemDurabilityRecipeHandler durabilityRecipeHandler = new ItemDurabilityRecipeHandler();
    private final ItemHandlerCap itemHandlerCap = new ItemHandlerCap();

    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    public ItemSlotCapabilityTrait(MBDMachine machine, ItemSlotCapabilityTraitDefinition definition) {
        super(machine, definition);
        this.storage = this.createStorage();
        this.storage.setOnContentsChanged(this::onContentsChanged);
    }

    @Override
    public void onMachineRemoved() {
        super.onMachineRemoved();
        Level level = this.getMachine().getLevel();
        BlockPos pos = this.getMachine().getPos();
        for (int i = 0; i < this.storage.getSlots(); ++i) {
            ItemStack stackInSlot = this.storage.getStackInSlot(i);
            if (stackInSlot.m_41619_()) continue;
            this.storage.setStackInSlot(i, ItemStack.f_41583_);
            this.storage.onContentsChanged();
            Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)stackInSlot);
        }
    }

    @Override
    public ItemSlotCapabilityTraitDefinition getDefinition() {
        return (ItemSlotCapabilityTraitDefinition)super.getDefinition();
    }

    @Override
    public void onLoadingTraitInPreview() {
        if (this.storage.getSlots() > 0) {
            this.storage.setStackInSlot(0, new ItemStack((ItemLike)Items.f_42416_, 32));
        }
    }

    protected ItemStackTransfer createStorage() {
        ItemStackTransfer transfer = new ItemStackTransfer(this.getDefinition().getSlotSize()){

            public int getSlotLimit(int slot) {
                return ItemSlotCapabilityTrait.this.getDefinition().getSlotLimit();
            }
        };
        if (this.getDefinition().getItemFilterSettings().isEnable()) {
            transfer.setFilter(this.getDefinition().getItemFilterSettings()::test);
        }
        return transfer;
    }

    public void onContentsChanged() {
        this.isEmpty = null;
        this.notifyListeners();
    }

    public boolean isEmpty() {
        if (this.isEmpty == null) {
            this.isEmpty = true;
            for (int i = 0; i < this.storage.getSlots(); ++i) {
                if (this.storage.getStackInSlot(i).m_41619_()) continue;
                this.isEmpty = false;
                break;
            }
        }
        return this.isEmpty;
    }

    @Override
    public List<IRecipeHandlerTrait<?>> getRecipeHandlerTraits() {
        return List.of(this.itemRecipeHandler, this.durabilityRecipeHandler);
    }

    @Override
    public List<ICapabilityProviderTrait<?>> getCapabilityProviderTraits() {
        return List.of(this.itemHandlerCap);
    }

    @Override
    @Nullable
    public AutoIO getAutoIO() {
        return this.getDefinition().getAutoIO().isEnable() ? this.getDefinition().getAutoIO() : null;
    }

    @Override
    public void serverTick() {
        IAutoIOTrait.super.serverTick();
        long timer = this.getMachine().getOffsetTimer();
        ItemSlotCapabilityTraitDefinition.AutoWorldIO autoInput = this.getDefinition().getAutoInput();
        ItemSlotCapabilityTraitDefinition.AutoWorldIO autoOutput = this.getDefinition().getAutoOutput();
        if (autoInput.isEnable() && timer % (long)autoInput.getInterval() == 0L) {
            List items = this.getMachine().getLevel().m_6443_(ItemEntity.class, autoInput.getRotatedRange(this.getMachine().getFrontFacing().orElse(Direction.NORTH)).m_82338_(this.getMachine().getPos()), EntitySelector.f_20402_);
            int leftCount = autoInput.getSpeed();
            for (ItemEntity itemEntity : items) {
                if (leftCount <= 0) break;
                ItemStack stored = itemEntity.m_32055_().m_41777_();
                ItemStack remaining = stored.m_255036_(Math.min(leftCount, stored.m_41613_()));
                int inserted = 0;
                for (int i = 0; i < this.storage.getSlots(); ++i) {
                    int beforeCount = remaining.m_41613_();
                    if ((remaining = this.storage.insertItem(i, remaining, false)).m_41613_() >= beforeCount) continue;
                    inserted += beforeCount - remaining.m_41613_();
                    if (remaining.m_41619_()) break;
                }
                if (inserted > 0) {
                    stored.m_41774_(inserted);
                    if (stored.m_41619_()) {
                        itemEntity.m_146870_();
                    } else {
                        itemEntity.m_32045_(stored);
                    }
                }
                leftCount -= inserted;
            }
        }
        if (autoOutput.isEnable() && timer % (long)autoOutput.getInterval() == 0L) {
            int leftCount = autoOutput.getSpeed();
            AABB range = autoOutput.getRotatedRange(this.getMachine().getFrontFacing().orElse(Direction.NORTH)).m_82338_(this.getMachine().getPos());
            for (int i = 0; i < this.storage.getSlots() && leftCount > 0; ++i) {
                ItemStack stored = this.storage.getStackInSlot(i);
                if (stored.m_41619_()) continue;
                ItemStack pop = stored.m_255036_(Math.min(leftCount, stored.m_41613_()));
                leftCount -= pop.m_41613_();
                this.storage.extractItem(i, pop.m_41613_(), false);
                Level level = this.getMachine().getLevel();
                double d0 = (double)EntityType.f_20461_.m_20679_() / 2.0;
                double x = (double)level.f_46441_.m_188501_() * range.m_82362_() + range.f_82288_;
                double y = (double)level.f_46441_.m_188501_() * range.m_82376_() + range.f_82289_ - d0;
                double z = (double)level.f_46441_.m_188501_() * range.m_82385_() + range.f_82290_;
                ItemEntity itemEntity = new ItemEntity(level, x, y, z, pop);
                itemEntity.m_32060_();
                level.m_7967_((Entity)itemEntity);
            }
        }
    }

    @Override
    public void handleAutoIO(BlockPos port, Direction side, IO io) {
        if (io == IO.IN) {
            ItemTransferHelperImpl.importToTarget((IItemTransfer)new ItemTransferList(new IItemTransfer[]{this.storage}), (int)Integer.MAX_VALUE, (Predicate)(this.getDefinition().getItemFilterSettings().isEnable() ? this.getDefinition().getItemFilterSettings() : Predicates.alwaysTrue()), (Level)this.getMachine().getLevel(), (BlockPos)port.m_121945_(side), (Direction)side.m_122424_());
        } else if (io == IO.OUT) {
            ItemTransferHelperImpl.exportToTarget((IItemTransfer)new ItemTransferList(new IItemTransfer[]{this.storage}), (int)Integer.MAX_VALUE, (Predicate)Predicates.alwaysTrue(), (Level)this.getMachine().getLevel(), (BlockPos)port.m_121945_(side), (Direction)side.m_122424_());
        }
    }

    public class ItemRecipeHandler
    extends RecipeHandlerTrait<Ingredient> {
        protected ItemRecipeHandler() {
            super(ItemSlotCapabilityTrait.this, ItemRecipeCapability.CAP);
        }

        @Override
        public List<Ingredient> handleRecipeInner(IO io, MBDRecipe recipe, List<Ingredient> left, @Nullable String slotName, boolean simulate) {
            block15: {
                Iterator<Ingredient> iterator;
                ItemStackTransfer capability;
                block14: {
                    if (!this.compatibleWith(io)) {
                        return left;
                    }
                    capability = simulate ? ItemSlotCapabilityTrait.this.storage.copy() : ItemSlotCapabilityTrait.this.storage;
                    iterator = left.iterator();
                    if (io != IO.IN) break block14;
                    block0: while (iterator.hasNext()) {
                        Ingredient ingredient = iterator.next();
                        for (int i = 0; i < capability.getSlots(); ++i) {
                            ItemStack[] ingredientStacks;
                            ItemStack itemStack = capability.getStackInSlot(i);
                            if (!ingredient.test(itemStack)) continue;
                            for (ItemStack ingredientStack : ingredientStacks = ingredient.m_43908_()) {
                                if (!ingredientStack.m_150930_(itemStack.m_41720_())) continue;
                                ItemStack extracted = capability.extractItem(i, ingredientStack.m_41613_(), false);
                                ingredientStack.m_41764_(ingredientStack.m_41613_() - extracted.m_41613_());
                                if (!ingredientStack.m_41619_()) continue;
                                iterator.remove();
                                continue block0;
                            }
                        }
                    }
                    break block15;
                }
                if (io != IO.OUT) break block15;
                while (iterator.hasNext()) {
                    Ingredient ingredient = iterator.next();
                    ItemStack[] items = ingredient.m_43908_();
                    if (items.length == 0) {
                        iterator.remove();
                        continue;
                    }
                    if (items.length == 1) {
                        ItemStack output = items[0];
                        if (!output.m_41619_()) {
                            for (int i = 0; i < capability.getSlots(); ++i) {
                                ItemStack leftStack = capability.insertItem(i, output.m_41777_(), false);
                                output.m_41764_(leftStack.m_41613_());
                                if (output.m_41619_()) break;
                            }
                        }
                        if (!output.m_41619_()) continue;
                        iterator.remove();
                        continue;
                    }
                    List<ItemStack> shuffledItems = Arrays.asList(Arrays.copyOf(items, items.length));
                    ItemSlotCapabilityTrait.this.random.setSeed(ItemSlotCapabilityTrait.this.getMachine().getOffsetTimer());
                    Collections.shuffle(shuffledItems, ItemSlotCapabilityTrait.this.random);
                    int index = -1;
                    for (int i = 0; i < shuffledItems.size(); ++i) {
                        ItemStack output = shuffledItems.get(i).m_41777_();
                        if (!output.m_41619_()) {
                            for (int slot = 0; slot < capability.getSlots(); ++slot) {
                                ItemStack leftStack = capability.insertItem(slot, output.m_41777_(), true);
                                output.m_41764_(leftStack.m_41613_());
                                if (output.m_41619_()) break;
                            }
                        }
                        if (!output.m_41619_()) continue;
                        index = i;
                        break;
                    }
                    if (index == -1) continue;
                    if (!simulate) {
                        ItemStack output = shuffledItems.get(index);
                        for (int slot = 0; slot < capability.getSlots(); ++slot) {
                            ItemStack leftStack = capability.insertItem(slot, output.m_41777_(), true);
                            if (leftStack.m_41613_() >= output.m_41613_()) continue;
                            leftStack = capability.insertItem(slot, output.m_41777_(), false);
                            output.m_41764_(leftStack.m_41613_());
                            if (output.m_41619_()) break;
                        }
                    }
                    iterator.remove();
                }
            }
            return left.isEmpty() ? null : left;
        }
    }

    public class ItemDurabilityRecipeHandler
    extends RecipeHandlerTrait<Ingredient> {
        protected ItemDurabilityRecipeHandler() {
            super(ItemSlotCapabilityTrait.this, ItemDurabilityRecipeCapability.CAP);
        }

        @Override
        public List<Ingredient> handleRecipeInner(IO io, MBDRecipe recipe, List<Ingredient> left, @Nullable String slotName, boolean simulate) {
            block8: {
                Iterator<Ingredient> iterator;
                ItemStackTransfer capability;
                block7: {
                    if (!this.compatibleWith(io)) {
                        return left;
                    }
                    capability = simulate ? ItemSlotCapabilityTrait.this.storage.copy() : ItemSlotCapabilityTrait.this.storage;
                    iterator = left.iterator();
                    if (io != IO.IN) break block7;
                    block0: while (iterator.hasNext()) {
                        Ingredient ingredient = iterator.next();
                        block1: for (int i = 0; i < capability.getSlots(); ++i) {
                            ItemStack[] ingredientStacks;
                            ItemStack itemStack = capability.getStackInSlot(i);
                            if (!itemStack.m_41763_() || !ingredient.test(itemStack)) continue;
                            for (ItemStack ingredientStack : ingredientStacks = (ItemStack[])Arrays.stream(ingredient.m_43908_()).filter(ItemStack::m_41763_).toArray(ItemStack[]::new)) {
                                if (!ingredientStack.m_150930_(itemStack.m_41720_())) continue;
                                int damage = itemStack.m_41773_();
                                int maxDamage = itemStack.m_41776_();
                                int availableDamage = Math.min(maxDamage - damage, ingredientStack.m_41613_());
                                if (availableDamage <= 0) continue;
                                itemStack.m_41721_(damage + availableDamage);
                                capability.setStackInSlot(i, itemStack);
                                capability.onContentsChanged(i);
                                ingredientStack.m_41764_(ingredientStack.m_41613_() - availableDamage);
                                if (!ingredientStack.m_41619_()) continue block1;
                                iterator.remove();
                                continue block0;
                            }
                        }
                    }
                    break block8;
                }
                if (io != IO.OUT) break block8;
                block3: while (iterator.hasNext()) {
                    Ingredient ingredient = iterator.next();
                    block4: for (int i = 0; i < capability.getSlots(); ++i) {
                        ItemStack[] ingredientStacks;
                        ItemStack itemStack = capability.getStackInSlot(i);
                        if (!itemStack.m_41763_() || !ingredient.test(itemStack)) continue;
                        for (ItemStack ingredientStack : ingredientStacks = (ItemStack[])Arrays.stream(ingredient.m_43908_()).filter(ItemStack::m_41763_).toArray(ItemStack[]::new)) {
                            int damage;
                            int availableDamage;
                            if (!ingredientStack.m_150930_(itemStack.m_41720_()) || (availableDamage = Math.min(damage = itemStack.m_41773_(), ingredientStack.m_41613_())) <= 0) continue;
                            itemStack.m_41721_(damage - availableDamage);
                            capability.setStackInSlot(i, itemStack);
                            capability.onContentsChanged(i);
                            ingredientStack.m_41764_(ingredientStack.m_41613_() - availableDamage);
                            if (!ingredientStack.m_41619_()) continue block4;
                            iterator.remove();
                            continue block3;
                        }
                    }
                }
            }
            return left.isEmpty() ? null : left;
        }
    }

    public class ItemHandlerCap
    implements ICapabilityProviderTrait<IItemHandler> {
        @Override
        public IO getCapabilityIO(@Nullable Direction side) {
            return ItemSlotCapabilityTrait.this.getCapabilityIO(side);
        }

        @Override
        public Capability<IItemHandler> getCapability() {
            return ForgeCapabilities.ITEM_HANDLER;
        }

        @Override
        public IItemHandler getCapContent(IO capbilityIO) {
            return new ItemHandlerWrapper(ItemSlotCapabilityTrait.this.storage, capbilityIO);
        }

        @Override
        public IItemHandler mergeContents(List<IItemHandler> contents) {
            return new ItemHandlerList(contents.toArray(new IItemHandler[0]));
        }
    }
}

