/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.integration.create;

import com.google.common.collect.Table;
import com.google.gson.JsonObject;
import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberRange;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ItemStackTexture;
import com.lowdragmc.mbd2.api.capability.recipe.IO;
import com.lowdragmc.mbd2.api.capability.recipe.IRecipeHandler;
import com.lowdragmc.mbd2.api.capability.recipe.RecipeCapability;
import com.lowdragmc.mbd2.api.recipe.MBDRecipe;
import com.lowdragmc.mbd2.api.recipe.RecipeCondition;
import com.lowdragmc.mbd2.api.recipe.RecipeLogic;
import com.lowdragmc.mbd2.integration.create.CreateStressRecipeCapability;
import com.lowdragmc.mbd2.integration.create.machine.CreateRotationTrait;
import com.simibubi.create.AllBlocks;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;

public class CreateRotationCondition
extends RecipeCondition {
    public static final CreateRotationCondition INSTANCE = new CreateRotationCondition();
    @Configurable(name="config.recipe.condition.rpm.min")
    @NumberRange(range={0.0, 3.4028234663852886E38})
    private float minRPM;
    @Configurable(name="config.recipe.condition.rpm.max")
    @NumberRange(range={0.0, 3.4028234663852886E38})
    private float maxRPM;
    @Configurable(name="config.recipe.condition.stress.min")
    @NumberRange(range={0.0, 3.4028234663852886E38})
    private float minStress;
    @Configurable(name="config.recipe.condition.stress.min")
    @NumberRange(range={0.0, 3.4028234663852886E38})
    private float maxStress;

    public CreateRotationCondition(float minRPM, float maxRPM, float minStress, float maxStress) {
        this.minRPM = minRPM;
        this.maxRPM = maxRPM;
        this.minStress = minStress;
        this.maxStress = maxStress;
    }

    @Override
    public String getType() {
        return "create_rotation";
    }

    @Override
    public Component getTooltips() {
        return Component.m_237110_((String)"recipe.condition.create_rpm.tooltip", (Object[])new Object[]{Float.valueOf(this.minRPM), Float.valueOf(this.maxRPM), Float.valueOf(this.minStress), Float.valueOf(this.maxStress)});
    }

    @Override
    public IGuiTexture getIcon() {
        return new ItemStackTexture(new ItemStack[]{AllBlocks.SHAFT.asStack()});
    }

    @Override
    public boolean test(@Nonnull MBDRecipe recipe, @Nonnull RecipeLogic recipeLogic) {
        Table<IO, RecipeCapability<?>, List<IRecipeHandler<?>>> proxy = recipeLogic.machine.getRecipeCapabilitiesProxy();
        List inputs = (List)proxy.get((Object)IO.IN, (Object)CreateStressRecipeCapability.CAP);
        if (inputs != null) {
            for (IRecipeHandler input : inputs) {
                CreateRotationTrait trait = null;
                if (input instanceof CreateRotationTrait.RPMRecipeHandler) {
                    CreateRotationTrait.RPMRecipeHandler handler = (CreateRotationTrait.RPMRecipeHandler)input;
                    trait = handler.getTrait();
                } else if (input instanceof CreateRotationTrait.StressRecipeHandler) {
                    CreateRotationTrait.StressRecipeHandler handler = (CreateRotationTrait.StressRecipeHandler)input;
                    trait = handler.getTrait();
                }
                if (trait == null) continue;
                float rpm = Math.abs(trait.getLastSpeed());
                float stress = rpm * trait.getImpact();
                if (!(rpm >= this.minRPM) || !(rpm <= this.maxRPM) || !(stress >= this.minStress) || !(stress <= this.maxStress)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    @Nonnull
    public JsonObject serialize() {
        JsonObject config = super.serialize();
        config.addProperty("minRPM", (Number)Float.valueOf(this.minRPM));
        config.addProperty("maxRPM", (Number)Float.valueOf(this.maxRPM));
        config.addProperty("minStress", (Number)Float.valueOf(this.minStress));
        config.addProperty("maxStress", (Number)Float.valueOf(this.maxStress));
        return config;
    }

    @Override
    public RecipeCondition deserialize(@Nonnull JsonObject config) {
        super.deserialize(config);
        this.minRPM = GsonHelper.m_13820_((JsonObject)config, (String)"minRPM", (float)0.0f);
        this.maxRPM = GsonHelper.m_13820_((JsonObject)config, (String)"maxRPM", (float)1.0f);
        this.minStress = GsonHelper.m_13820_((JsonObject)config, (String)"minStress", (float)0.0f);
        this.maxStress = GsonHelper.m_13820_((JsonObject)config, (String)"maxStress", (float)1.0f);
        return this;
    }

    @Override
    public RecipeCondition fromNetwork(FriendlyByteBuf buf) {
        super.fromNetwork(buf);
        this.minRPM = buf.readFloat();
        this.maxRPM = buf.readFloat();
        this.minStress = buf.readFloat();
        this.maxStress = buf.readFloat();
        return this;
    }

    @Override
    public void toNetwork(FriendlyByteBuf buf) {
        super.toNetwork(buf);
        buf.writeFloat(this.minRPM);
        buf.writeFloat(this.maxRPM);
        buf.writeFloat(this.minStress);
        buf.writeFloat(this.maxStress);
    }

    @Override
    public CompoundTag toNBT() {
        CompoundTag tag = super.toNBT();
        tag.m_128350_("minRPM", this.minRPM);
        tag.m_128350_("maxRPM", this.maxRPM);
        tag.m_128350_("minStress", this.minStress);
        tag.m_128350_("maxStress", this.maxStress);
        return tag;
    }

    @Override
    public RecipeCondition fromNBT(CompoundTag tag) {
        super.fromNBT(tag);
        this.minRPM = tag.m_128457_("minRPM");
        this.maxRPM = tag.m_128457_("maxRPM");
        this.minStress = tag.m_128457_("minStress");
        this.maxStress = tag.m_128457_("maxStress");
        return this;
    }

    public float getMinRPM() {
        return this.minRPM;
    }

    public float getMaxRPM() {
        return this.maxRPM;
    }

    public float getMinStress() {
        return this.minStress;
    }

    public float getMaxStress() {
        return this.maxStress;
    }

    public CreateRotationCondition() {
    }
}

