/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.integration.create.machine;

import com.lowdragmc.lowdraglib.client.renderer.IRenderer;
import com.lowdragmc.lowdraglib.client.renderer.impl.IModelRenderer;
import com.lowdragmc.lowdraglib.client.renderer.impl.UIResourceRenderer;
import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.mbd2.MBD2;
import com.lowdragmc.mbd2.common.machine.definition.MBDMachineDefinition;
import com.lowdragmc.mbd2.common.machine.definition.config.ConfigBlockProperties;
import com.lowdragmc.mbd2.common.machine.definition.config.ConfigItemProperties;
import com.lowdragmc.mbd2.common.machine.definition.config.ConfigMachineSettings;
import com.lowdragmc.mbd2.common.machine.definition.config.ConfigPartSettings;
import com.lowdragmc.mbd2.common.machine.definition.config.ConfigRecipeLogicSettings;
import com.lowdragmc.mbd2.common.machine.definition.config.MachineState;
import com.lowdragmc.mbd2.common.machine.definition.config.StateMachine;
import com.lowdragmc.mbd2.integration.create.machine.ConfigKineticMachineSettings;
import com.lowdragmc.mbd2.integration.create.machine.CreateMachineState;
import com.lowdragmc.mbd2.integration.create.machine.MBDKineticInstance;
import com.lowdragmc.mbd2.integration.create.machine.MBDKineticMachineBlock;
import com.lowdragmc.mbd2.integration.create.machine.MBDKineticMachineBlockEntity;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.api.stress.BlockStressValues;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.visualization.SimpleBlockEntityVisualizer;
import java.io.File;
import java.util.Deque;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import org.jetbrains.annotations.Nullable;

@LDLRegister(name="create_machine", group="machine_definition", modID="create")
public class CreateKineticMachineDefinition
extends MBDMachineDefinition {
    @Configurable(name="config.definition.kinetic_machine_settings", subConfigurable=true, tips={"config.definition.kinetic_machine_settings.tooltip"}, collapse=false)
    protected final ConfigKineticMachineSettings kineticMachineSettings;

    protected CreateKineticMachineDefinition(ResourceLocation id, MachineState rootState, @Nullable ConfigBlockProperties blockProperties, @Nullable ConfigItemProperties itemProperties, @Nullable MBDMachineDefinition.ConfigMachineSettingsFactory machineSettings, @Nullable ConfigRecipeLogicSettings recipeLogicSettings, @Nullable MBDMachineDefinition.ConfigPartSettingsFactory partSettings, @Nullable ConfigKineticMachineSettings kineticMachineSettings) {
        super(id, rootState, blockProperties, itemProperties, machineSettings, recipeLogicSettings, partSettings);
        this.kineticMachineSettings = kineticMachineSettings == null ? ConfigKineticMachineSettings.builder().build() : kineticMachineSettings;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public MachineState createDefaultRootState() {
        return StateMachine.createDefault(CreateMachineState::builder);
    }

    public static CreateKineticMachineDefinition createDefault() {
        return new CreateKineticMachineDefinition(MBD2.id("dummy"), (MachineState)StateMachine.createDefault(CreateMachineState::builder), ConfigBlockProperties.builder().build(), ConfigItemProperties.builder().build(), () -> ConfigMachineSettings.builder().build(), ConfigRecipeLogicSettings.builder().build(), () -> ConfigPartSettings.builder().build(), ConfigKineticMachineSettings.builder().build());
    }

    @Override
    public MBDMachineDefinition loadProductiveTag(@Nullable File file, CompoundTag projectTag, Deque<Runnable> postTask) {
        super.loadProductiveTag(file, projectTag, postTask);
        this.kineticMachineSettings.deserializeNBT(projectTag.m_128469_("definition").m_128469_("kineticMachineSettings"));
        return this;
    }

    @Override
    public Block createBlock() {
        MBDKineticMachineBlock block = new MBDKineticMachineBlock(this.blockProperties.apply(this.stateMachine, BlockBehaviour.Properties.m_284310_()), this);
        if (this.kineticMachineSettings.isGenerator) {
            BlockStressValues.CAPACITIES.register((Object)block, this.kineticMachineSettings::getCapacity);
            BlockStressValues.RPM.register((Object)block, (Object)new BlockStressValues.GeneratedRpm(this.kineticMachineSettings.maxRPM, true));
        } else {
            BlockStressValues.IMPACTS.register((Object)block, this.kineticMachineSettings::getImpact);
        }
        return block;
    }

    @Override
    public BlockEntity createBlockEntity(BlockPos pos, BlockState state) {
        return new MBDKineticMachineBlockEntity(this, this.blockEntityType(), pos, state, this::createMachine);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void initRenderer(EntityRenderersEvent.RegisterRenderers event) {
        super.initRenderer(event);
        if (this.kineticMachineSettings.useFlywheel) {
            PartialModel model = this.getRotationPartialModel();
            SimpleBlockEntityVisualizer.builder(this.blockEntityType()).factory((materialManager, be, pt) -> new MBDKineticInstance(materialManager, (MBDKineticMachineBlockEntity)be, pt, model)).skipVanillaRender(be -> false).apply();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private PartialModel getRotationPartialModel() {
        PartialModel model = AllPartialModels.SHAFT_HALF;
        Object t = this.stateMachine.getRootState();
        if (t instanceof CreateMachineState) {
            CreateMachineState state = (CreateMachineState)t;
            IRenderer rotationRenderer = state.getRotationRenderer();
            while (rotationRenderer instanceof UIResourceRenderer) {
                UIResourceRenderer uiResourceRenderer = (UIResourceRenderer)rotationRenderer;
                rotationRenderer = uiResourceRenderer.getRenderer();
            }
            if (rotationRenderer instanceof IModelRenderer) {
                IModelRenderer modelRenderer = (IModelRenderer)rotationRenderer;
                model = PartialModel.of((ResourceLocation)modelRenderer.getModelLocation());
            }
        }
        return model;
    }

    public ConfigKineticMachineSettings kineticMachineSettings() {
        return this.kineticMachineSettings;
    }

    public static class Builder
    extends MBDMachineDefinition.Builder {
        protected ConfigKineticMachineSettings kineticMachineSettings;

        protected Builder() {
        }

        @Override
        public CreateKineticMachineDefinition build() {
            return new CreateKineticMachineDefinition(this.id, this.rootState, this.blockProperties, this.itemProperties, this.machineSettings, this.recipeLogicSettings, this.partSettings, this.kineticMachineSettings);
        }

        public Builder kineticMachineSettings(ConfigKineticMachineSettings kineticMachineSettings) {
            this.kineticMachineSettings = kineticMachineSettings;
            return this;
        }
    }
}

