/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.integration.create.machine;

import com.lowdragmc.lowdraglib.client.renderer.IRenderer;
import com.lowdragmc.lowdraglib.client.renderer.impl.IModelRenderer;
import com.lowdragmc.lowdraglib.client.renderer.impl.UIResourceRenderer;
import com.lowdragmc.lowdraglib.gui.editor.configurator.Configurator;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.mbd2.common.machine.definition.config.MachineState;
import com.lowdragmc.mbd2.common.machine.definition.config.toggle.ToggleRenderer;
import com.lowdragmc.mbd2.integration.create.machine.KineticInstanceRenderer;
import java.util.List;
import javax.annotation.Nullable;
import lombok.NonNull;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CreateMachineState
extends MachineState {
    @Persisted(subPersisted=true)
    private final ToggleRenderer rotationRenderer;

    public CreateMachineState(String name, @NonNull List<MachineState> children, @Nullable IRenderer renderer, @Nullable VoxelShape shape, @Nullable Integer lightLevel, @Nullable AABB renderingBox, @Nullable IRenderer rotationRenderer) {
        super(name, children, renderer, shape, lightLevel, renderingBox);
        if (children == null) {
            throw new NullPointerException("children is marked non-null but is null");
        }
        this.rotationRenderer = rotationRenderer == null ? new ToggleRenderer() : new ToggleRenderer(rotationRenderer);
    }

    public void buildConfigurator(ConfiguratorGroup father) {
        super.buildConfigurator(father);
        if (this.name.equals("base")) {
            ConfiguratorGroup configurator = new ConfiguratorGroup("config.create_machine_state.rotation_renderer");
            configurator.setTips(new String[]{"config.create_machine_state.rotation_renderer.tooltip"});
            this.rotationRenderer.buildConfigurator(configurator);
            father.addConfigurators(new Configurator[]{configurator});
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public IRenderer getRealRenderer() {
        IRenderer baseRenderer = this.getRenderer();
        IRenderer rotationRenderer = this.getRotationRenderer();
        while (rotationRenderer instanceof UIResourceRenderer) {
            UIResourceRenderer uiResourceRenderer = (UIResourceRenderer)rotationRenderer;
            rotationRenderer = uiResourceRenderer.getRenderer();
        }
        if (rotationRenderer instanceof IModelRenderer) {
            IModelRenderer modelRenderer = (IModelRenderer)rotationRenderer;
            return new KineticInstanceRenderer(baseRenderer, modelRenderer.getRotatedModel(Direction.NORTH));
        }
        return baseRenderer;
    }

    public IRenderer getRotationRenderer() {
        if (!this.rotationRenderer.isEnable() || this.rotationRenderer.getValue() == null) {
            MachineState machineState = this.parent;
            if (machineState instanceof CreateMachineState) {
                CreateMachineState state = (CreateMachineState)machineState;
                return state.getRotationRenderer();
            }
            return IRenderer.EMPTY;
        }
        return this.rotationRenderer.getValue();
    }

    protected MachineState.Builder<? extends CreateMachineState> newBuilder() {
        return CreateMachineState.builder();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends MachineState.Builder<CreateMachineState> {
        @Nullable
        private IModelRenderer rotationRenderer;

        @Override
        public CreateMachineState build() {
            return new CreateMachineState(this.name, this.children, this.renderer, this.shape, this.lightLevel, this.renderingBox, (IRenderer)this.rotationRenderer);
        }

        public Builder rotationRenderer(@Nullable IModelRenderer rotationRenderer) {
            this.rotationRenderer = rotationRenderer;
            return this;
        }
    }
}

