/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.integration.create.machine;

import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.syncdata.ISubscription;
import com.lowdragmc.mbd2.api.capability.recipe.IO;
import com.lowdragmc.mbd2.api.capability.recipe.IRecipeCapabilityHolder;
import com.lowdragmc.mbd2.api.capability.recipe.IRecipeHandlerTrait;
import com.lowdragmc.mbd2.api.capability.recipe.RecipeCapability;
import com.lowdragmc.mbd2.api.recipe.MBDRecipe;
import com.lowdragmc.mbd2.api.recipe.RecipeCondition;
import com.lowdragmc.mbd2.common.machine.MBDMachine;
import com.lowdragmc.mbd2.common.machine.definition.MBDMachineDefinition;
import com.lowdragmc.mbd2.common.trait.ITrait;
import com.lowdragmc.mbd2.common.trait.TraitDefinition;
import com.lowdragmc.mbd2.integration.create.CreateRPMRecipeCapability;
import com.lowdragmc.mbd2.integration.create.CreateRotationCondition;
import com.lowdragmc.mbd2.integration.create.CreateStressRecipeCapability;
import com.lowdragmc.mbd2.integration.create.machine.CreateKineticMachineDefinition;
import com.lowdragmc.mbd2.integration.create.machine.MBDKineticMachineBlockEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public class CreateRotationTrait
implements ITrait {
    protected List<Runnable> listeners = new ArrayList<Runnable>();
    public static final TraitDefinition DEFINITION = new TraitDefinition(){

        @Override
        public ITrait createTrait(MBDMachine machine) {
            return new CreateRotationTrait(machine);
        }

        @Override
        public IGuiTexture getIcon() {
            return IGuiTexture.EMPTY;
        }

        public String name() {
            return "!create_stress";
        }

        public String group() {
            return "trait";
        }

        @Override
        public boolean allowMultiple() {
            return false;
        }
    };
    private final MBDMachine machine;
    private final boolean isGenerator;
    private float impact;
    private float available;
    private float lastSpeed;
    private final StressRecipeHandler stressRecipeHandler = new StressRecipeHandler();
    private final RPMRecipeHandler rpmRecipeHandler = new RPMRecipeHandler();

    public CreateRotationTrait(MBDMachine machine) {
        float f;
        CreateKineticMachineDefinition definition;
        this.machine = machine;
        MBDMachineDefinition mBDMachineDefinition = machine.getDefinition();
        this.isGenerator = mBDMachineDefinition instanceof CreateKineticMachineDefinition && (definition = (CreateKineticMachineDefinition)mBDMachineDefinition).kineticMachineSettings().isGenerator();
        mBDMachineDefinition = machine.getDefinition();
        if (mBDMachineDefinition instanceof CreateKineticMachineDefinition) {
            definition = (CreateKineticMachineDefinition)mBDMachineDefinition;
            f = definition.kineticMachineSettings().getImpact();
        } else {
            f = 0.0f;
        }
        this.impact = f;
    }

    public void notifyListeners() {
        this.listeners.forEach(Runnable::run);
    }

    @Override
    public void serverTick() {
        MBDKineticMachineBlockEntity kineticMachine;
        float speed;
        BlockEntity blockEntity = this.machine.getHolder();
        if (blockEntity instanceof MBDKineticMachineBlockEntity && (speed = (kineticMachine = (MBDKineticMachineBlockEntity)blockEntity).getSpeed()) != this.lastSpeed) {
            this.lastSpeed = speed;
            this.notifyListeners();
        }
    }

    @Override
    public TraitDefinition getDefinition() {
        return DEFINITION;
    }

    public void preWorking(IO io) {
        BlockEntity blockEntity = this.machine.getHolder();
        if (blockEntity instanceof MBDKineticMachineBlockEntity) {
            MBDKineticMachineBlockEntity blockEntity2 = (MBDKineticMachineBlockEntity)blockEntity;
            if (this.available > 0.0f && this.isGenerator && io == IO.OUT) {
                blockEntity2.scheduleWorking(this.available, false);
            }
        }
    }

    public void postWorking(IO io) {
        BlockEntity blockEntity = this.machine.getHolder();
        if (blockEntity instanceof MBDKineticMachineBlockEntity) {
            MBDKineticMachineBlockEntity blockEntity2 = (MBDKineticMachineBlockEntity)blockEntity;
            if (this.isGenerator && io == IO.OUT) {
                blockEntity2.stopWorking();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public IO getHandlerIO() {
        IO iO;
        MBDMachineDefinition mBDMachineDefinition = this.getMachine().getDefinition();
        if (mBDMachineDefinition instanceof CreateKineticMachineDefinition) {
            CreateKineticMachineDefinition definition = (CreateKineticMachineDefinition)mBDMachineDefinition;
            if (definition.kineticMachineSettings.isGenerator) {
                iO = IO.OUT;
                return iO;
            }
        }
        iO = IO.IN;
        return iO;
    }

    @Override
    public List<IRecipeHandlerTrait<?>> getRecipeHandlerTraits() {
        return List.of(this.stressRecipeHandler, this.rpmRecipeHandler);
    }

    @Override
    public MBDMachine getMachine() {
        return this.machine;
    }

    public boolean isGenerator() {
        return this.isGenerator;
    }

    public float getImpact() {
        return this.impact;
    }

    public float getAvailable() {
        return this.available;
    }

    public float getLastSpeed() {
        return this.lastSpeed;
    }

    public class StressRecipeHandler
    implements IRecipeHandlerTrait<Float> {
        public CreateRotationTrait getTrait() {
            return CreateRotationTrait.this;
        }

        @Override
        public ISubscription addChangedListener(Runnable listener) {
            CreateRotationTrait.this.listeners.add(listener);
            return () -> CreateRotationTrait.this.listeners.remove(listener);
        }

        @Override
        public List<Float> handleRecipeInner(IO io, MBDRecipe recipe, List<Float> left, @Nullable String slotName, boolean simulate) {
            if (!this.compatibleWith(io)) {
                return left;
            }
            BlockEntity blockEntity = CreateRotationTrait.this.machine.getHolder();
            if (blockEntity instanceof MBDKineticMachineBlockEntity) {
                MBDKineticMachineBlockEntity holder = (MBDKineticMachineBlockEntity)blockEntity;
                float sum = left.stream().reduce(Float.valueOf(0.0f), Float::sum).floatValue();
                if (io == IO.IN && !CreateRotationTrait.this.isGenerator) {
                    float capacity = Mth.m_14154_((float)holder.getSpeed()) * CreateRotationTrait.this.impact;
                    if (capacity > 0.0f) {
                        sum -= capacity;
                    }
                } else if (io == IO.OUT && CreateRotationTrait.this.isGenerator) {
                    if (simulate) {
                        CreateRotationTrait.this.available = holder.scheduleWorking(sum, true);
                    }
                    sum -= CreateRotationTrait.this.available;
                }
                return sum <= 0.0f ? null : Collections.singletonList(Float.valueOf(sum));
            }
            return left;
        }

        @Override
        public void preWorking(IRecipeCapabilityHolder holder, IO io, MBDRecipe recipe) {
            CreateRotationTrait.this.preWorking(io);
        }

        @Override
        public void postWorking(IRecipeCapabilityHolder holder, IO io, MBDRecipe recipe) {
            CreateRotationTrait.this.postWorking(io);
        }

        @Override
        public IO getHandlerIO() {
            return CreateRotationTrait.this.getHandlerIO();
        }

        @Override
        public RecipeCapability<Float> getRecipeCapability() {
            return CreateStressRecipeCapability.CAP;
        }
    }

    public class RPMRecipeHandler
    implements IRecipeHandlerTrait<Float> {
        public CreateRotationTrait getTrait() {
            return CreateRotationTrait.this;
        }

        @Override
        public ISubscription addChangedListener(Runnable listener) {
            CreateRotationTrait.this.listeners.add(listener);
            return () -> CreateRotationTrait.this.listeners.remove(listener);
        }

        @Override
        public List<Float> handleRecipeInner(IO io, MBDRecipe recipe, List<Float> left, @Nullable String slotName, boolean simulate) {
            if (!this.compatibleWith(io)) {
                return left;
            }
            BlockEntity blockEntity = CreateRotationTrait.this.machine.getHolder();
            if (blockEntity instanceof MBDKineticMachineBlockEntity) {
                MBDKineticMachineBlockEntity holder = (MBDKineticMachineBlockEntity)blockEntity;
                float sum = left.stream().reduce(Float.valueOf(0.0f), Float::max).floatValue();
                if (io == IO.IN && !CreateRotationTrait.this.isGenerator) {
                    float rpm = Mth.m_14154_((float)holder.getSpeed());
                    float stress = rpm * CreateRotationTrait.this.getImpact();
                    for (RecipeCondition condition : recipe.conditions) {
                        CreateRotationCondition rotationCondition;
                        if (!(condition instanceof CreateRotationCondition) || !(rpm < (rotationCondition = (CreateRotationCondition)condition).getMinRPM() || rpm > rotationCondition.getMaxRPM() || stress < rotationCondition.getMinStress()) && !(stress > rotationCondition.getMaxStress())) continue;
                        return left;
                    }
                    if (rpm >= sum) {
                        return null;
                    }
                } else if (io == IO.OUT && CreateRotationTrait.this.isGenerator) {
                    if (simulate) {
                        CreateRotationTrait.this.available = holder.scheduleWorkingRPM(sum, true);
                    }
                    return null;
                }
            }
            return left;
        }

        @Override
        public void preWorking(IRecipeCapabilityHolder holder, IO io, MBDRecipe recipe) {
            CreateRotationTrait.this.preWorking(io);
        }

        @Override
        public void postWorking(IRecipeCapabilityHolder holder, IO io, MBDRecipe recipe) {
            CreateRotationTrait.this.postWorking(io);
        }

        @Override
        public IO getHandlerIO() {
            return CreateRotationTrait.this.getHandlerIO();
        }

        @Override
        public RecipeCapability<Float> getRecipeCapability() {
            return CreateRPMRecipeCapability.CAP;
        }
    }
}

