/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.integration.create.machine;

import com.lowdragmc.lowdraglib.syncdata.IManaged;
import com.lowdragmc.lowdraglib.syncdata.managed.IRef;
import com.lowdragmc.lowdraglib.syncdata.managed.MultiManagedStorage;
import com.lowdragmc.mbd2.MBD2;
import com.lowdragmc.mbd2.api.blockentity.IMachineBlockEntity;
import com.lowdragmc.mbd2.api.capability.MBDCapabilities;
import com.lowdragmc.mbd2.api.machine.IMachine;
import com.lowdragmc.mbd2.common.machine.MBDMachine;
import com.lowdragmc.mbd2.common.trait.ITrait;
import com.lowdragmc.mbd2.integration.create.machine.CreateKineticMachineDefinition;
import com.lowdragmc.mbd2.integration.create.machine.CreateRotationTrait;
import com.simibubi.create.content.kinetics.KineticNetwork;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticEffectHandler;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MBDKineticMachineBlockEntity
extends KineticBlockEntity
implements IMachineBlockEntity {
    public final MultiManagedStorage rootStorage = new MultiManagedStorage();
    private boolean isAsyncSyncing = false;
    private final long offset = MBD2.RND.nextLong();
    private IMachine metaMachine;
    public float workingSpeed;
    public boolean reActivateSource;
    public CreateKineticMachineDefinition definition;

    public MBDKineticMachineBlockEntity(CreateKineticMachineDefinition definition, BlockEntityType<?> type, BlockPos pos, BlockState blockState, Function<IMachineBlockEntity, IMachine> machineFactory) {
        super(type, pos, blockState);
        this.setMachine(machineFactory.apply(this));
        this.definition = definition;
    }

    public void setMachine(IMachine newMachine) {
        MBDMachine machine;
        IMachine iMachine;
        if (this.metaMachine == newMachine) {
            return;
        }
        if (this.metaMachine != null && this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.metaMachine.onUnload();
        }
        if ((iMachine = this.metaMachine) instanceof MBDMachine) {
            machine = (MBDMachine)iMachine;
            machine.detach();
        }
        this.metaMachine = newMachine;
        if (newMachine instanceof MBDMachine) {
            machine = (MBDMachine)newMachine;
            ITrait trait = CreateRotationTrait.DEFINITION.createTrait(machine);
            machine.getAdditionalTraits().add(trait);
            if (trait instanceof IManaged) {
                IManaged managed = (IManaged)trait;
                for (IRef ref : managed.getSyncStorage().getPersistedFields()) {
                    ref.setPersistedPrefixName("trait." + CreateRotationTrait.DEFINITION.getName());
                }
                this.rootStorage.attach(managed.getSyncStorage());
            }
            machine.initCapabilitiesProxy();
        }
    }

    public void invalidate() {
        super.invalidate();
        this.metaMachine.onUnload();
    }

    public void m_6339_() {
        super.m_6339_();
        this.getMetaMachine().onLoad();
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == MBDCapabilities.CAPABILITY_MACHINE) {
            return MBDCapabilities.CAPABILITY_MACHINE.orEmpty(cap, LazyOptional.of(this::getMetaMachine));
        }
        IMachine iMachine = this.metaMachine;
        if (iMachine instanceof MBDMachine) {
            MBDMachine machine = (MBDMachine)iMachine;
            return machine.getCapability(cap, side);
        }
        return super.getCapability(cap, side);
    }

    public AABB getRenderBoundingBox() {
        MBDMachine machine;
        AABB value;
        IMachine iMachine = this.metaMachine;
        if (iMachine instanceof MBDMachine && (value = (machine = (MBDMachine)iMachine).getRenderBoundingBox()) != null) {
            return value;
        }
        return super.getRenderBoundingBox();
    }

    public KineticEffectHandler getEffects() {
        return this.effects;
    }

    public float scheduleWorking(float stress, boolean simulate) {
        if (this.definition.kineticMachineSettings.isGenerator) {
            float capacity = this.definition.kineticMachineSettings.getCapacity();
            float speed = Math.min((float)this.definition.kineticMachineSettings.maxRPM, stress / capacity);
            if (!simulate) {
                this.workingSpeed = speed;
                this.updateGeneratedRotation();
            }
            return speed * capacity;
        }
        return 0.0f;
    }

    public float scheduleWorkingRPM(float rpm, boolean simulate) {
        float stress = rpm * this.definition.kineticMachineSettings.getCapacity();
        return this.scheduleWorking(stress, simulate);
    }

    public void onSpeedChanged(float previousSpeed) {
        super.onSpeedChanged(previousSpeed);
        if (!this.f_58857_.f_46443_ && !this.definition.kineticMachineSettings.isGenerator && Math.abs(this.speed) > (float)this.definition.kineticMachineSettings.maxRPM) {
            this.f_58857_.m_46961_(this.f_58858_, true);
        }
    }

    public void stopWorking() {
        if (this.definition.kineticMachineSettings.isGenerator && this.getGeneratedSpeed() != 0.0f) {
            this.workingSpeed = 0.0f;
            this.updateGeneratedRotation();
        }
    }

    public float getGeneratedSpeed() {
        return this.workingSpeed;
    }

    protected void notifyStressCapacityChange(float capacity) {
        this.getOrCreateNetwork().updateCapacityFor((KineticBlockEntity)this, capacity);
    }

    public void removeSource() {
        if (this.definition.kineticMachineSettings.isGenerator && this.hasSource() && this.isSource()) {
            this.reActivateSource = true;
        }
        super.removeSource();
    }

    public void setSource(BlockPos source) {
        super.setSource(source);
        if (!this.definition.kineticMachineSettings.isGenerator) {
            return;
        }
        BlockEntity blockEntity = this.f_58857_.m_7702_(source);
        if (blockEntity instanceof KineticBlockEntity) {
            KineticBlockEntity sourceTe = (KineticBlockEntity)blockEntity;
            if (this.reActivateSource && Math.abs(sourceTe.getSpeed()) >= Math.abs(this.getGeneratedSpeed())) {
                this.reActivateSource = false;
            }
        }
    }

    public void tick() {
        super.tick();
        if (this.definition.kineticMachineSettings.isGenerator && this.reActivateSource) {
            this.updateGeneratedRotation();
            this.reActivateSource = false;
        }
    }

    public float calculateStressApplied() {
        float impact;
        this.lastStressApplied = impact = this.definition.kineticMachineSettings.getImpact();
        return impact;
    }

    public float calculateAddedStressCapacity() {
        float capacity;
        this.lastCapacityProvided = capacity = this.definition.kineticMachineSettings.getCapacity();
        return capacity;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        boolean added = super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        float stressBase = this.calculateAddedStressCapacity();
        if (stressBase != 0.0f && IRotate.StressImpact.isEnabled()) {
            CreateLang.translate((String)"gui.goggles.generator_stats", (Object[])new Object[0]).forGoggles(tooltip);
            CreateLang.translate((String)"tooltip.capacityProvided", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
            float speed = this.getTheoreticalSpeed();
            if (speed != this.getGeneratedSpeed() && speed != 0.0f) {
                stressBase *= this.getGeneratedSpeed() / speed;
            }
            speed = Math.abs(speed);
            float stressTotal = stressBase * speed;
            CreateLang.number((double)stressTotal).translate("generic.unit.stress", new Object[0]).style(ChatFormatting.AQUA).space().add(CreateLang.translate((String)"gui.goggles.at_current_speed", (Object[])new Object[0]).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
            added = true;
        }
        return added;
    }

    public void updateGeneratedRotation() {
        if (!this.definition.kineticMachineSettings.isGenerator) {
            return;
        }
        float speed = this.getGeneratedSpeed();
        float prevSpeed = this.speed;
        if (!this.f_58857_.f_46443_) {
            if (prevSpeed != speed) {
                IRotate.SpeedLevel levelafter;
                IRotate.SpeedLevel levelBefore;
                if (!this.hasSource() && (levelBefore = IRotate.SpeedLevel.of((float)this.speed)) != (levelafter = IRotate.SpeedLevel.of((float)speed))) {
                    this.effects.queueRotationIndicators();
                }
                this.applyNewSpeed(prevSpeed, speed);
            }
            if (this.hasNetwork() && speed != 0.0f) {
                KineticNetwork network = this.getOrCreateNetwork();
                this.notifyStressCapacityChange(this.calculateAddedStressCapacity());
                this.getOrCreateNetwork().updateStressFor((KineticBlockEntity)this, this.calculateStressApplied());
                network.updateStress();
            }
            this.onSpeedChanged(prevSpeed);
            this.sendData();
        }
    }

    public void applyNewSpeed(float prevSpeed, float speed) {
        if (speed == 0.0f) {
            if (this.hasSource()) {
                this.notifyStressCapacityChange(0.0f);
                this.getOrCreateNetwork().updateStressFor((KineticBlockEntity)this, this.calculateStressApplied());
            } else {
                this.detachKinetics();
                this.setSpeed(0.0f);
                this.setNetwork(null);
            }
        } else if (prevSpeed == 0.0f) {
            this.setSpeed(speed);
            this.setNetwork(this.createNetworkId());
            this.attachKinetics();
        } else if (this.hasSource()) {
            if (Math.abs(prevSpeed) >= Math.abs(speed)) {
                if (Math.signum(prevSpeed) != Math.signum(speed)) {
                    this.f_58857_.m_46961_(this.f_58858_, true);
                }
            } else {
                this.detachKinetics();
                this.setSpeed(speed);
                this.source = null;
                this.setNetwork(this.createNetworkId());
                this.attachKinetics();
            }
        } else {
            this.detachKinetics();
            this.setSpeed(speed);
            this.attachKinetics();
        }
    }

    public Long createNetworkId() {
        return this.f_58858_.m_121878_();
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128350_("workingSpeed", this.workingSpeed);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.workingSpeed = compound.m_128441_("workingSpeed") ? compound.m_128457_("workingSpeed") : 0.0f;
    }

    public MultiManagedStorage getRootStorage() {
        return this.rootStorage;
    }

    public boolean isAsyncSyncing() {
        return this.isAsyncSyncing;
    }

    public void setAsyncSyncing(boolean isAsyncSyncing) {
        this.isAsyncSyncing = isAsyncSyncing;
    }

    @Override
    public long getOffset() {
        return this.offset;
    }

    @Override
    public IMachine getMetaMachine() {
        return this.metaMachine;
    }
}

