/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.integration.embers.trait;

import com.lowdragmc.mbd2.api.capability.recipe.IO;
import com.rekindled.embers.api.power.IEmberCapability;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EmberCapabilityWrapper
implements IEmberCapability {
    private final IEmberCapability storage;
    private final IO io;

    public EmberCapabilityWrapper(IEmberCapability storage, IO io) {
        this.storage = storage;
        this.io = io;
    }

    public double getEmber() {
        return this.storage.getEmber();
    }

    public double getEmberCapacity() {
        return this.storage.getEmberCapacity();
    }

    public void setEmber(double v) {
        this.storage.setEmber(v);
    }

    public void setEmberCapacity(double v) {
        this.storage.setEmberCapacity(v);
    }

    public double addAmount(double v, boolean b) {
        if (this.io == IO.IN || this.io == IO.BOTH) {
            return this.storage.addAmount(v, b);
        }
        return 0.0;
    }

    public double removeAmount(double v, boolean b) {
        if (this.io == IO.OUT || this.io == IO.BOTH) {
            return this.storage.removeAmount(v, b);
        }
        return 0.0;
    }

    public void writeToNBT(CompoundTag compoundTag) {
        this.storage.writeToNBT(compoundTag);
    }

    public void onContentsChanged() {
        this.storage.onContentsChanged();
    }

    public void invalidate() {
        this.storage.invalidate();
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return this.storage.getCapability(cap, side);
    }

    public CompoundTag serializeNBT() {
        return (CompoundTag)this.storage.serializeNBT();
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.storage.deserializeNBT((Tag)nbt);
    }

    public boolean acceptsVolatile() {
        return this.storage.acceptsVolatile();
    }
}

