/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.integration.embers.trait;

import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import com.lowdragmc.mbd2.api.capability.recipe.IO;
import com.lowdragmc.mbd2.api.capability.recipe.IRecipeHandlerTrait;
import com.lowdragmc.mbd2.api.recipe.MBDRecipe;
import com.lowdragmc.mbd2.common.machine.MBDMachine;
import com.lowdragmc.mbd2.common.trait.AutoIO;
import com.lowdragmc.mbd2.common.trait.IAutoIOTrait;
import com.lowdragmc.mbd2.common.trait.ICapabilityProviderTrait;
import com.lowdragmc.mbd2.common.trait.RecipeHandlerTrait;
import com.lowdragmc.mbd2.common.trait.SimpleCapabilityTrait;
import com.lowdragmc.mbd2.integration.embers.EmbersEmberRecipeCapability;
import com.lowdragmc.mbd2.integration.embers.trait.CopiableEmberCapability;
import com.lowdragmc.mbd2.integration.embers.trait.EmberCapabilityWrapper;
import com.lowdragmc.mbd2.integration.embers.trait.EmbersEmberCapabilityTraitDefinition;
import com.rekindled.embers.api.capabilities.EmbersCapabilities;
import com.rekindled.embers.api.power.IEmberCapability;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraftforge.common.capabilities.Capability;
import org.jetbrains.annotations.Nullable;

public class EmbersEmberCapabilityTrait
extends SimpleCapabilityTrait
implements IAutoIOTrait {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(EmbersEmberCapabilityTrait.class);
    @Persisted
    @DescSynced
    public final CopiableEmberCapability storage;
    private final EmberRecipeHandler recipeHandler = new EmberRecipeHandler();
    private final EmberCap emberCap = new EmberCap();

    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    public EmbersEmberCapabilityTrait(MBDMachine machine, EmbersEmberCapabilityTraitDefinition definition) {
        super(machine, definition);
        this.storage = this.createStorages();
        this.storage.setOnContentsChanged(this::notifyListeners);
    }

    @Override
    public EmbersEmberCapabilityTraitDefinition getDefinition() {
        return (EmbersEmberCapabilityTraitDefinition)super.getDefinition();
    }

    @Override
    public void onLoadingTraitInPreview() {
        this.storage.setEmber(this.storage.getEmberCapacity() / 2.0);
    }

    protected CopiableEmberCapability createStorages() {
        return new CopiableEmberCapability(this.getDefinition().getCapacity());
    }

    @Override
    public List<IRecipeHandlerTrait<?>> getRecipeHandlerTraits() {
        return List.of(this.recipeHandler);
    }

    @Override
    public List<ICapabilityProviderTrait<?>> getCapabilityProviderTraits() {
        return List.of(this.emberCap);
    }

    @Override
    @Nullable
    public AutoIO getAutoIO() {
        return this.getDefinition().getAutoIO().isEnable() ? this.getDefinition().getAutoIO() : null;
    }

    @Override
    public void handleAutoIO(BlockPos port, Direction side, IO io) {
        if (io == IO.IN) {
            Optional.ofNullable(this.getMachine().getLevel().m_7702_(port.m_121945_(side))).flatMap(be -> be.getCapability(EmbersCapabilities.EMBER_CAPABILITY, side.m_122424_()).resolve()).ifPresent(source -> source.removeAmount(this.storage.addAmount(source.removeAmount(this.getDefinition().getCapacity(), false), true), true));
        } else {
            Optional.ofNullable(this.getMachine().getLevel().m_7702_(port.m_121945_(side))).flatMap(be -> be.getCapability(EmbersCapabilities.EMBER_CAPABILITY, side.m_122424_()).resolve()).ifPresent(target -> target.addAmount(this.storage.removeAmount(target.addAmount(this.getDefinition().getCapacity(), false), true), true));
        }
    }

    public CopiableEmberCapability getStorage() {
        return this.storage;
    }

    public EmberRecipeHandler getRecipeHandler() {
        return this.recipeHandler;
    }

    public EmberCap getEmberCap() {
        return this.emberCap;
    }

    public class EmberRecipeHandler
    extends RecipeHandlerTrait<Double> {
        protected EmberRecipeHandler() {
            super(EmbersEmberCapabilityTrait.this, EmbersEmberRecipeCapability.CAP);
        }

        @Override
        public List<Double> handleRecipeInner(IO io, MBDRecipe recipe, List<Double> left, @Nullable String slotName, boolean simulate) {
            CopiableEmberCapability capability;
            if (!this.compatibleWith(io)) {
                return left;
            }
            double required = left.stream().mapToDouble(Double::doubleValue).reduce(0.0, Double::sum);
            CopiableEmberCapability copiableEmberCapability = capability = simulate ? EmbersEmberCapabilityTrait.this.storage.copy() : EmbersEmberCapabilityTrait.this.storage;
            if (io == IO.IN) {
                double extracted = capability.removeAmount(required, !simulate);
                required -= extracted;
            } else {
                double received = capability.addAmount(required, !simulate);
                required -= received;
            }
            return required > 0.0 ? List.of(Double.valueOf(required)) : null;
        }
    }

    public class EmberCap
    implements ICapabilityProviderTrait<IEmberCapability> {
        @Override
        public IO getCapabilityIO(@Nullable Direction side) {
            return EmbersEmberCapabilityTrait.this.getCapabilityIO(side);
        }

        @Override
        public Capability<IEmberCapability> getCapability() {
            return EmbersCapabilities.EMBER_CAPABILITY;
        }

        @Override
        public IEmberCapability getCapContent(IO capbilityIO) {
            return new EmberCapabilityWrapper((IEmberCapability)EmbersEmberCapabilityTrait.this.storage, capbilityIO);
        }

        @Override
        public IEmberCapability mergeContents(List<IEmberCapability> contents) {
            return contents.get(0);
        }
    }
}

