/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.integration.emi;

import com.lowdragmc.lowdraglib.emi.IGui2Renderable;
import com.lowdragmc.lowdraglib.emi.ModularEmiRecipe;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.mbd2.api.recipe.MBDRecipe;
import com.lowdragmc.mbd2.api.recipe.MBDRecipeType;
import com.lowdragmc.mbd2.api.registry.MBDRegistries;
import com.lowdragmc.mbd2.common.machine.definition.MBDMachineDefinition;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;

public class MBDRecipeTypeEmiCategory
extends EmiRecipeCategory {
    public static final Function<MBDRecipeType, MBDRecipeTypeEmiCategory> CATEGORIES = Util.m_143827_(MBDRecipeTypeEmiCategory::new);
    public final MBDRecipeType recipeType;

    public MBDRecipeTypeEmiCategory(MBDRecipeType recipeType) {
        super(recipeType.getRegistryName(), IGui2Renderable.toDrawable((IGuiTexture)recipeType.getIcon(), (int)16, (int)16));
        this.recipeType = recipeType;
    }

    public static void registerDisplays(EmiRegistry registry) {
        for (MBDRecipeType recipeType : MBDRegistries.RECIPE_TYPES) {
            if (!recipeType.isXEIVisible()) continue;
            Minecraft.m_91087_().m_91403_().m_105141_().m_44013_((RecipeType)recipeType).stream().filter(recipe -> !recipe.isFuel).map(recipe -> new MBDEmiRecipe(CATEGORIES.apply(recipeType), (MBDRecipe)recipe)).forEach(arg_0 -> ((EmiRegistry)registry).addRecipe(arg_0));
        }
    }

    public static void registerWorkStations(EmiRegistry registry) {
        for (MBDRecipeType mbdRecipeType : MBDRegistries.RECIPE_TYPES) {
            if (!mbdRecipeType.isXEIVisible()) continue;
            for (MBDMachineDefinition machine : MBDRegistries.MACHINE_DEFINITIONS) {
                for (MBDMachineDefinition definition : MBDRegistries.MACHINE_DEFINITIONS) {
                    MBDRecipeType recipeType = definition.recipeLogicSettings().getRecipeType();
                    if (recipeType != mbdRecipeType) continue;
                    registry.addWorkstation((EmiRecipeCategory)CATEGORIES.apply(mbdRecipeType), (EmiIngredient)EmiStack.of((ItemLike)machine.item()));
                }
            }
        }
    }

    public Component getName() {
        return Component.m_237115_((String)this.recipeType.getRegistryName().m_214298_());
    }

    public static class MBDEmiRecipe
    extends ModularEmiRecipe<Widget> {
        final MBDRecipeTypeEmiCategory category;
        final MBDRecipe recipe;

        public MBDEmiRecipe(MBDRecipeTypeEmiCategory category, MBDRecipe recipe) {
            super(() -> recipe.recipeType.getUiCreator().create(recipe).setClientSideWidget());
            this.category = category;
            this.recipe = recipe;
        }

        public EmiRecipeCategory getCategory() {
            return this.category;
        }

        @Nullable
        public ResourceLocation getId() {
            return this.recipe.m_6423_();
        }
    }
}

