/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.integration.gtm;

import com.gregtechceu.gtceu.common.data.GTItems;
import com.lowdragmc.lowdraglib.gui.editor.configurator.Configurator;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.configurator.NumberConfigurator;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ItemStackTexture;
import com.lowdragmc.lowdraglib.gui.texture.ProgressTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceBorderTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.ProgressWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.jei.IngredientIO;
import com.lowdragmc.mbd2.api.capability.recipe.RecipeCapability;
import com.lowdragmc.mbd2.api.recipe.content.Content;
import com.lowdragmc.mbd2.api.recipe.content.SerializerLong;
import com.lowdragmc.mbd2.common.gui.recipe.CornerNumberWidget;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;

public class GTMEnergyRecipeCapability
extends RecipeCapability<Long> {
    public static final GTMEnergyRecipeCapability CAP = new GTMEnergyRecipeCapability();
    public static final ResourceBorderTexture HUD_BACKGROUND = new ResourceBorderTexture("mbd2:textures/gui/progress_bar_boiler_empty_steel.png", 54, 10, 1, 1);
    public static final ResourceBorderTexture HUD_BAR = new ResourceBorderTexture("mbd2:textures/gui/progress_bar_boiler_heat.png", 54, 10, 1, 1);

    protected GTMEnergyRecipeCapability() {
        super("gtm_energy", SerializerLong.INSTANCE);
    }

    @Override
    public Long createDefaultContent() {
        return 128L;
    }

    @Override
    public Widget createPreviewWidget(Long content) {
        WidgetGroup previewGroup = new WidgetGroup(0, 0, 18, 18);
        previewGroup.addWidget((Widget)new ImageWidget(1, 1, 16, 16, (IGuiTexture)new ItemStackTexture(new Item[]{GTItems.BATTERY_HV_SODIUM.m_5456_()})));
        previewGroup.addWidget((Widget)new CornerNumberWidget(0, 0, 18, 18).setValue(content));
        return previewGroup;
    }

    @Override
    public Widget createXEITemplate() {
        ProgressWidget energyBar = new ProgressWidget(ProgressWidget.JEIProgress, 0, 0, 100, 15, new ProgressTexture(IGuiTexture.EMPTY, (IGuiTexture)HUD_BAR.copy()));
        energyBar.setBackground(new IGuiTexture[]{HUD_BACKGROUND});
        energyBar.setOverlay((IGuiTexture)new TextTexture("0 eu"));
        return energyBar;
    }

    @Override
    public void bindXEIWidget(Widget widget, Content content, IngredientIO ingredientIO) {
        if (widget instanceof ProgressWidget) {
            ProgressWidget energyBar = (ProgressWidget)widget;
            Long energy = (Long)this.of(content.content);
            IGuiTexture iGuiTexture = energyBar.getOverlay();
            if (iGuiTexture instanceof TextTexture) {
                TextTexture textTexture = (TextTexture)iGuiTexture;
                if (content.perTick) {
                    textTexture.updateText(energy + " eu/t");
                } else {
                    textTexture.updateText(energy + " eu");
                }
            }
        }
    }

    @Override
    public void createContentConfigurator(ConfiguratorGroup father, Supplier<Long> supplier, Consumer<Long> onUpdate) {
        Configurator[] configuratorArray = new Configurator[1];
        configuratorArray[0] = new NumberConfigurator("recipe.capability.gtm_energy.energy", supplier::get, number -> onUpdate.accept(number.longValue()), (Number)1, true).setRange((Number)1, (Number)Long.MAX_VALUE);
        father.addConfigurators(configuratorArray);
    }

    @Override
    public Component getLeftErrorInfo(List<Long> left) {
        return Component.m_237113_((String)(left.stream().mapToLong(Long::longValue).sum() + " eu"));
    }
}

