/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.integration.gtm.trait;

import com.gregtechceu.gtceu.api.capability.IEnergyContainer;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.lowdragmc.lowdraglib.syncdata.IContentChangeAware;
import com.lowdragmc.lowdraglib.syncdata.ITagSerializable;
import com.lowdragmc.mbd2.common.machine.MBDMachine;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;

public class CopiableEnergyContainer
implements IEnergyContainer,
ITagSerializable<Tag>,
IContentChangeAware {
    public Runnable onContentsChanged = () -> {};
    private final MBDMachine machine;
    protected final boolean explosionMachine;
    protected final long energyCapacity;
    protected final long inputAmperage;
    protected final long inputVoltage;
    protected final long outputAmperage;
    protected final long outputVoltage;
    protected long energyStored = 0L;
    protected long amps;
    protected long lastTS = Long.MIN_VALUE;

    public CopiableEnergyContainer(MBDMachine machine, boolean explosionMachine, long energyCapacity, long inputAmperage, long inputVoltage, long outputAmperage, long outputVoltage) {
        this.machine = machine;
        this.explosionMachine = explosionMachine;
        this.energyCapacity = energyCapacity;
        this.inputAmperage = inputAmperage;
        this.inputVoltage = inputVoltage;
        this.outputAmperage = outputAmperage;
        this.outputVoltage = outputVoltage;
    }

    public CopiableEnergyContainer copy() {
        return new CopiableEnergyContainer(this.machine, this.explosionMachine, this.energyCapacity, this.inputAmperage, this.inputVoltage, this.outputAmperage, this.outputVoltage);
    }

    public long acceptEnergyFromNetwork(Direction side, long voltage, long amperage) {
        long latestTS = this.machine.getOffsetTimer();
        if (this.lastTS < latestTS) {
            this.amps = 0L;
            this.lastTS = latestTS;
        }
        if (this.amps >= this.getInputAmperage()) {
            return 0L;
        }
        long canAccept = this.getEnergyCapacity() - this.getEnergyStored();
        if (voltage > 0L && (side == null || this.inputsEnergy(side))) {
            long amperesAccepted;
            if (voltage > this.getInputVoltage()) {
                Level level = this.machine.getLevel();
                BlockPos pos = this.machine.getPos();
                float explosionPower = GTUtil.getExplosionPower((long)voltage);
                level.m_7471_(pos, false);
                level.m_254849_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, explosionPower, this.explosionMachine ? Level.ExplosionInteraction.BLOCK : Level.ExplosionInteraction.NONE);
                return Math.min(amperage, this.getInputAmperage() - this.amps);
            }
            if (canAccept >= voltage && (amperesAccepted = Math.min(canAccept / voltage, Math.min(amperage, this.getInputAmperage() - this.amps))) > 0L) {
                this.setEnergyStored(this.getEnergyStored() + voltage * amperesAccepted);
                this.amps += amperesAccepted;
                return amperesAccepted;
            }
        }
        return 0L;
    }

    public void setEnergyStored(long energyStored) {
        if (this.energyStored == energyStored) {
            return;
        }
        this.energyStored = energyStored;
        this.onContentsChanged.run();
    }

    public boolean inputsEnergy(Direction side) {
        return true;
    }

    public long changeEnergy(long energyToAdd) {
        long newEnergyStored;
        long oldEnergyStored = this.getEnergyStored();
        long l = newEnergyStored = this.energyCapacity - oldEnergyStored < energyToAdd ? this.energyCapacity : oldEnergyStored + energyToAdd;
        if (newEnergyStored < 0L) {
            newEnergyStored = 0L;
        }
        this.setEnergyStored(newEnergyStored);
        return newEnergyStored - oldEnergyStored;
    }

    public Tag serializeNBT() {
        return LongTag.m_128882_((long)this.energyStored);
    }

    public void deserializeNBT(Tag nbt) {
        if (nbt instanceof LongTag) {
            LongTag tag = (LongTag)nbt;
            this.energyStored = tag.m_7046_();
        }
    }

    public Runnable getOnContentsChanged() {
        return this.onContentsChanged;
    }

    public void setOnContentsChanged(Runnable onContentsChanged) {
        this.onContentsChanged = onContentsChanged;
    }

    public long getEnergyCapacity() {
        return this.energyCapacity;
    }

    public long getInputAmperage() {
        return this.inputAmperage;
    }

    public long getInputVoltage() {
        return this.inputVoltage;
    }

    public long getOutputAmperage() {
        return this.outputAmperage;
    }

    public long getOutputVoltage() {
        return this.outputVoltage;
    }

    public long getEnergyStored() {
        return this.energyStored;
    }
}

