/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.integration.gtm.trait;

import com.gregtechceu.gtceu.api.capability.IEnergyContainer;
import com.lowdragmc.mbd2.api.capability.recipe.IO;
import net.minecraft.core.Direction;

public class EnergyContainerWrapper
implements IEnergyContainer {
    private final IEnergyContainer container;
    private final IO io;

    public EnergyContainerWrapper(IEnergyContainer container, IO io) {
        this.container = container;
        this.io = io;
    }

    public boolean outputsEnergy(Direction side) {
        return this.io == IO.OUT;
    }

    public long getOutputAmperage() {
        return this.container.getOutputAmperage();
    }

    public long getOutputVoltage() {
        return this.container.getOutputVoltage();
    }

    public long acceptEnergyFromNetwork(Direction side, long voltage, long amperage) {
        if (this.io != IO.IN && this.io != IO.BOTH) {
            return 0L;
        }
        return this.container.acceptEnergyFromNetwork(side, voltage, amperage);
    }

    public boolean inputsEnergy(Direction side) {
        return this.io == IO.IN || this.io == IO.BOTH;
    }

    public long changeEnergy(long differenceAmount) {
        return this.container.changeEnergy(differenceAmount);
    }

    public long getEnergyStored() {
        return this.container.getEnergyStored();
    }

    public long getEnergyCapacity() {
        return this.container.getEnergyCapacity();
    }

    public long getInputAmperage() {
        return this.container.getInputAmperage();
    }

    public long getInputVoltage() {
        return this.container.getInputVoltage();
    }
}

