/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.integration.kubejs.events;

import com.lowdragmc.mbd2.MBD2;
import com.lowdragmc.mbd2.common.machine.definition.config.event.MachineClientTickEvent;
import com.lowdragmc.mbd2.common.machine.definition.config.event.MachineCustomDataUpdateEvent;
import com.lowdragmc.mbd2.common.machine.definition.config.event.MachineCustomKeyframeEvent;
import com.lowdragmc.mbd2.common.machine.definition.config.event.MachineEvent;
import com.lowdragmc.mbd2.integration.kubejs.events.MBDMachineEvents;
import dev.latvian.mods.kubejs.event.EventHandler;
import dev.latvian.mods.kubejs.event.EventJS;
import dev.latvian.mods.kubejs.event.Extra;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public interface MBDClientEvents {
    public static final Map<Class<? extends MachineEvent>, Consumer<MachineEvent>> eventHandlers = new HashMap<Class<? extends MachineEvent>, Consumer<MachineEvent>>();
    public static final EventHandler CLIENT_TICK = MBDClientEvents.registerMachineEvent("onClientTick", MachineClientTickEvent.class, MBDMachineEvents.MachineClientTickEventJS.class, MBDMachineEvents.MachineClientTickEventJS::new);
    public static final EventHandler CUSTOM_DATA_UPDATE = MBDClientEvents.registerMachineEvent("onCustomDataUpdate", MachineCustomDataUpdateEvent.class, MBDMachineEvents.MachineCustomDataUpdateEventJS.class, MBDMachineEvents.MachineCustomDataUpdateEventJS::new);
    @Nullable
    public static final EventHandler CUSTOM_KEYFRAME = MBDClientEvents.createCustomKeyframeEvent();

    public static EventHandler createCustomKeyframeEvent() {
        if (MBD2.isGeckolibLoaded()) {
            return MBDClientEvents.registerMachineEvent("onCustomKeyframe", MachineCustomKeyframeEvent.class, MBDMachineEvents.MachineCustomKeyframeEventJS.class, MBDMachineEvents.MachineCustomKeyframeEventJS::new);
        }
        return null;
    }

    public static void init() {
    }

    public static <E extends MachineEvent> EventHandler registerMachineEvent(String name, Class<E> eventClass, Class<? extends MBDMachineEvents.MachineEventJS<E>> eventJSClass, Function<E, MBDMachineEvents.MachineEventJS<E>> eventJSFactory) {
        EventHandler handler = MBDMachineEvents.MBD_MACHINE_EVENTS.client(name, () -> eventJSClass).extra(Extra.ID);
        eventHandlers.put(eventClass, event -> handler.post((EventJS)eventJSFactory.apply(event), (Object)event.machine.getDefinition().id()));
        return handler;
    }

    public static void postMachineEvent(MachineEvent machineEvent) {
        Optional.ofNullable(eventHandlers.get(((Object)((Object)machineEvent)).getClass())).ifPresent(handler -> handler.accept(machineEvent));
    }
}

