/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.integration.mekanism.trait.chemical;

import com.lowdragmc.lowdraglib.syncdata.IContentChangeAware;
import com.lowdragmc.lowdraglib.syncdata.ITagSerializable;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.chemical.BasicChemicalTank;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.attribute.ChemicalAttributeValidator;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.SlurryStack;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ChemicalStorage<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>>
extends BasicChemicalTank<CHEMICAL, STACK>
implements IContentChangeAware,
ITagSerializable<CompoundTag> {
    private Runnable onContentsChanged = () -> {};
    public final Predicate<@NotNull CHEMICAL> validator;
    @Nullable
    public final ChemicalAttributeValidator attributeValidator;

    protected ChemicalStorage(long capacity, Predicate<@NotNull CHEMICAL> validator, @Nullable ChemicalAttributeValidator attributeValidator) {
        super(capacity, (a, b) -> true, (a, b) -> true, validator, attributeValidator, null);
        this.validator = validator;
        this.attributeValidator = attributeValidator;
    }

    public abstract STACK readFromNBT(CompoundTag var1);

    public abstract ChemicalStorage<CHEMICAL, STACK> copy();

    public void onContentsChanged() {
        if (this.onContentsChanged != null) {
            this.onContentsChanged.run();
        }
    }

    @Nonnull
    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        if (!this.isEmpty()) {
            nbt.m_128365_("stored", (Tag)this.stored.write(new CompoundTag()));
        }
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        if (nbt.m_128425_("stored", 10)) {
            this.setStackUnchecked((ChemicalStack)this.readFromNBT(nbt.m_128469_("stored")));
        }
    }

    public Runnable getOnContentsChanged() {
        return this.onContentsChanged;
    }

    public void setOnContentsChanged(Runnable onContentsChanged) {
        this.onContentsChanged = onContentsChanged;
    }

    @MethodsReturnNonnullByDefault
    @ParametersAreNonnullByDefault
    public static class Slurry
    extends ChemicalStorage<mekanism.api.chemical.slurry.Slurry, SlurryStack> {
        public Slurry(long capacity, Predicate<mekanism.api.chemical.slurry.Slurry> validator, @Nullable ChemicalAttributeValidator attributeValidator) {
            super(capacity, validator, attributeValidator);
        }

        public Slurry copy() {
            Slurry copied = new Slurry(this.getCapacity(), this.validator, this.attributeValidator);
            copied.setStack((ChemicalStack)((SlurryStack)this.getStack()));
            return copied;
        }

        @Override
        public SlurryStack readFromNBT(CompoundTag nbt) {
            return SlurryStack.readFromNBT((CompoundTag)nbt);
        }

        public SlurryStack createStack(SlurryStack stored, long size) {
            return new SlurryStack(stored, size);
        }

        @NotNull
        public SlurryStack getEmptyStack() {
            return SlurryStack.EMPTY;
        }
    }

    @MethodsReturnNonnullByDefault
    @ParametersAreNonnullByDefault
    public static class Pigment
    extends ChemicalStorage<mekanism.api.chemical.pigment.Pigment, PigmentStack> {
        public Pigment(long capacity, Predicate<mekanism.api.chemical.pigment.Pigment> validator, @Nullable ChemicalAttributeValidator attributeValidator) {
            super(capacity, validator, attributeValidator);
        }

        public Pigment copy() {
            Pigment copied = new Pigment(this.getCapacity(), this.validator, this.attributeValidator);
            copied.setStack((ChemicalStack)((PigmentStack)this.getStack()));
            return copied;
        }

        @Override
        public PigmentStack readFromNBT(CompoundTag nbt) {
            return PigmentStack.readFromNBT((CompoundTag)nbt);
        }

        public PigmentStack createStack(PigmentStack stored, long size) {
            return new PigmentStack(stored, size);
        }

        @NotNull
        public PigmentStack getEmptyStack() {
            return PigmentStack.EMPTY;
        }
    }

    @MethodsReturnNonnullByDefault
    @ParametersAreNonnullByDefault
    public static class Infuse
    extends ChemicalStorage<InfuseType, InfusionStack> {
        public Infuse(long capacity, Predicate<InfuseType> validator, @Nullable ChemicalAttributeValidator attributeValidator) {
            super(capacity, validator, attributeValidator);
        }

        public Infuse copy() {
            Infuse copied = new Infuse(this.getCapacity(), this.validator, this.attributeValidator);
            copied.setStack((ChemicalStack)((InfusionStack)this.getStack()));
            return copied;
        }

        @Override
        public InfusionStack readFromNBT(CompoundTag nbt) {
            return InfusionStack.readFromNBT((CompoundTag)nbt);
        }

        public InfusionStack createStack(InfusionStack stored, long size) {
            return new InfusionStack(stored, size);
        }

        @NotNull
        public InfusionStack getEmptyStack() {
            return InfusionStack.EMPTY;
        }
    }

    @MethodsReturnNonnullByDefault
    @ParametersAreNonnullByDefault
    public static class Gas
    extends ChemicalStorage<mekanism.api.chemical.gas.Gas, GasStack> {
        public Gas(long capacity, Predicate<@NotNull mekanism.api.chemical.gas.Gas> validator, @Nullable ChemicalAttributeValidator attributeValidator) {
            super(capacity, validator, attributeValidator);
        }

        public Gas copy() {
            Gas copied = new Gas(this.getCapacity(), this.validator, this.attributeValidator);
            copied.setStack((ChemicalStack)((GasStack)this.getStack()));
            return copied;
        }

        @Override
        public GasStack readFromNBT(CompoundTag nbt) {
            return GasStack.readFromNBT((CompoundTag)nbt);
        }

        public GasStack createStack(GasStack stored, long size) {
            return new GasStack(stored, size);
        }

        @NotNull
        public GasStack getEmptyStack() {
            return GasStack.EMPTY;
        }
    }
}

